/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.proxy;

import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.proxy.MonProxyFactory;
import com.jamonapi.utils.Misc;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fest.util.VisibleForTesting;

public class JAMonDriver
implements Driver {
    private static final String jamonURL = "jdbc:jamon:";

    public static void register() {
    }

    private static Driver registerDriver(String className) throws SQLException {
        Driver d = null;
        try {
            d = (Driver)Class.forName(className).newInstance();
            DriverManager.registerDriver(d);
        }
        catch (Exception e) {
            String message = "MonProxy-Exception: loading JDBC Driver=" + e.getMessage();
            MonitorFactory.add(new MonKeyImp(message, new Object[]{message, Misc.getExceptionTrace(e)}, "Exception"), 1.0);
            DriverManager.println(message);
            throw new SQLException("Can not load real driver (" + className + ") from JAMonDriver: " + e.getLocalizedMessage());
        }
        return d;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        URLInfo urlInfo = new URLInfo(url, info);
        Driver realDriver = this.getRegisteredDriver(urlInfo.getRealURL());
        if (realDriver == null) {
            realDriver = JAMonDriver.registerDriver(urlInfo.getRealDriverName());
        }
        Monitor mon = MonitorFactory.start("MonProxy-Interface (class=com.jamonapi.proxy.JAMonDriver): public java.sql.Connection com.jamonapi.proxy.JAMonDriver.connect(java.lang.String, java.util.Properties) throws java.sql.SQLException");
        Connection conn = null;
        try {
            conn = MonProxyFactory.monitor(realDriver.connect(urlInfo.getRealURL(), info));
        }
        catch (SQLException sqlException) {
            String sqlMessage = ",ErrorCode=" + sqlException.getErrorCode() + ",SQLState=" + sqlException.getSQLState();
            String label = "MonProxy-Exception: Root cause exception=" + sqlException.getClass().getName() + sqlMessage;
            MonKeyImp key = new MonKeyImp(label, new Object[]{label, Misc.getExceptionTrace(sqlException)}, "Exception");
            MonitorFactory.add(key, 1.0);
            throw sqlException;
        }
        finally {
            mon.stop();
        }
        return conn;
    }

    private Driver getRegisteredDriver(String url) {
        Driver registeredDriver = null;
        try {
            registeredDriver = DriverManager.getDriver(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return registeredDriver;
    }

    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        return url.toLowerCase().startsWith(jamonURL);
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[]{JAMonDriver.getPropertyInfo("jamonrealdriver", null, "The driver to be proxy monitored.  Example: jdbc:jamon:sybase:Tds:myserver:1234/mydatabase?LITERAL_PARAMS=true&PACKETSIZE=512&jamonrealdriver=com.sybase.jdbc3.jdbc.SybDriver&HOSTNAME=myhost", true)};
    }

    private static DriverPropertyInfo getPropertyInfo(String name, String value, String description, boolean required) {
        DriverPropertyInfo prop = new DriverPropertyInfo(name, value);
        prop.description = description;
        prop.required = required;
        return prop;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 3;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public static String getRealDriverName(String url) {
        return new URLInfo(url).getRealDriverName();
    }

    public static String getRealURL(String url) {
        return new URLInfo(url).getRealURL();
    }

    static {
        try {
            JAMonDriver.registerDriver("com.jamonapi.proxy.JAMonDriver");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @VisibleForTesting
    static class URLInfo {
        String realDriverName;
        String realURL;
        String jamonURL;
        int maxSqlSize;

        URLInfo(String jamonURL) {
            this(jamonURL, null);
        }

        URLInfo(String jamonURL, Properties info) {
            this.jamonURL = jamonURL;
            String string = this.realDriverName = info == null ? null : info.getProperty("jamonrealdriver");
            if (this.realDriverName == null) {
                this.realDriverName = this.parseURL(".*jamonrealdriver[\\s=]*([\\w\\.]*)[\\W]?", jamonURL);
            }
            this.realURL = jamonURL.replaceAll(JAMonDriver.jamonURL, "jdbc:");
            this.realURL = this.realURL.replaceAll("jamonrealdriver[\\s=\\.\\w]*[\\W]?", "");
        }

        private String parseURL(String pattern, String url) {
            String result = "";
            if (url == null) {
                return result;
            }
            Pattern re = Pattern.compile(pattern);
            Matcher matcher = re.matcher(url);
            if (matcher.lookingAt()) {
                result = matcher.group(1);
            }
            return result.trim();
        }

        String getRealDriverName() {
            return this.realDriverName;
        }

        String getRealURL() {
            return this.realURL;
        }

        String getJAMonURL() {
            return this.jamonURL;
        }
    }
}

