package com.jamonapi;

import com.jamonapi.utils.LocaleContext;

import java.text.DecimalFormat;


/**
 * Base class for FrequencyDists.  Note toString() is used to display ActivityStats in the jamonadmin.jsp page.
 * Values will be 0 if activity stats tracking is not enabled.
 */

final class FrequencyDistBase extends FrequencyDistImp {

    /** Creates a new instance of FrequencyDistBase */
    public FrequencyDistBase(String displayHeader, double endValue, String name) {
        this.monData.displayHeader = displayHeader;
        this.endValue = endValue;
        this.monData.name = name;

    }

    private String format(double value) {
        DecimalFormat decimalFormat = LocaleContext.getFloatingPointFormatter();
        return decimalFormat.format(value);
    }

    @Override
    public String toString() {
        if (!isEnabled() || monData.hits == 0)
            return "";
        else {
            StringBuffer buff = new StringBuffer();
            buff.append(format(getHits()));
            buff.append("/");
            buff.append(format(getAvg()));
            buff.append(" (");
            buff.append(format(getAvgActive())).append("/");
            buff.append(format(getAvgPrimaryActive())).append("/");
            buff.append(format(getAvgGlobalActive())).append(")");
            return buff.toString();
        }

    }

}
