/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.ActivityStats;
import com.jamonapi.Counter;
import com.jamonapi.DecoMon;
import com.jamonapi.MonKey;
import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorFactoryInterface;
import com.jamonapi.MonitorImp;
import com.jamonapi.NullMonitor;
import com.jamonapi.RangeBase;
import com.jamonapi.RangeHolder;
import com.jamonapi.RangeImp;
import com.jamonapi.TimeMon;
import com.jamonapi.TimeMon2;
import com.jamonapi.TimeMonNano;
import com.jamonapi.utils.DetailData;
import com.jamonapi.utils.Misc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class FactoryEnabled
implements MonitorFactoryInterface {
    private Map map;
    private Counter allActive;
    private Counter primaryActive;
    private boolean activityTracking = false;
    private RangeFactory rangeFactory;
    private GetMonitor getMonitor;
    private int maxMonitors;
    private AtomicLong totalKeySize;
    private int maxSqlSize;
    private static final boolean PRIMARY = true;
    private static final boolean NOT_PRIMARY = false;
    private static final boolean TIME_MONITOR = true;
    private static final boolean NOT_TIME_MONITOR = false;
    private static final int DEFAULT_MAP_SIZE = 500;
    private static final NullMonitor NULL_MON = new NullMonitor();

    public FactoryEnabled() {
        this.initialize();
    }

    private synchronized void initialize() {
        this.allActive = new Counter();
        this.primaryActive = new Counter();
        this.rangeFactory = new RangeFactory();
        this.activityTracking = false;
        this.setRangeDefault("ms.", RangeHolder.getMSHolder());
        this.setRangeDefault("percent", RangeHolder.getPercentHolder());
        this.setMap(Misc.createConcurrentMap(500));
        if (this.isTotalKeySizeTrackingEnabled()) {
            this.enableTotalKeySizeTracking();
        }
    }

    @Override
    public Monitor add(MonKey key, double value) {
        return this.getMonitor(key).add(value);
    }

    @Override
    public Monitor add(String label, String units, double value) {
        return this.getMonitor(new MonKeyImp(label, units)).add(value);
    }

    @Override
    public Monitor start(MonKey key) {
        return this.getTimeMonitor(key, false).start();
    }

    @Override
    public Monitor start(String label) {
        return this.getTimeMonitor(new MonKeyImp(label, "ms."), false).start();
    }

    @Override
    public Monitor startNano(String label) {
        return this.getNanoMonitor(new MonKeyImp(label, "ns.")).start();
    }

    @Override
    public Monitor startNano(MonKey key) {
        return this.getNanoMonitor(key).start();
    }

    @Override
    public Monitor startPrimary(MonKey key) {
        return this.getTimeMonitor(key, true).start();
    }

    @Override
    public Monitor startPrimary(String label) {
        return this.getTimeMonitor(new MonKeyImp(label, "ms."), true).start();
    }

    @Override
    public Monitor start() {
        return new TimeMon2().start();
    }

    @Override
    public Monitor getMonitor() {
        return new MonitorImp(new MonKeyImp("defaultMon", "defaultMon"), null, new ActivityStats(), false);
    }

    @Override
    public void setMap(Map map) {
        this.getMonitor = new GetMonitorMap();
        this.map = map;
        if (map instanceof ConcurrentHashMap) {
            this.getMonitor = new GetMonitor();
        }
    }

    @Override
    public Monitor getMonitor(MonKey key) {
        return this.getMonitor(key, false, false);
    }

    @Override
    public Monitor getMonitor(String label, String units) {
        return this.getMonitor(new MonKeyImp(label, units));
    }

    @Override
    public Monitor getTimeMonitor(MonKey key) {
        return this.getTimeMonitor(key, false);
    }

    @Override
    public Monitor getTimeMonitor(String label) {
        return this.getTimeMonitor(new MonKeyImp(label, "ms."), false);
    }

    @Override
    public void setRangeDefault(String key, RangeHolder rangeHolder) {
        RangeBase range = null;
        if (rangeHolder != null && rangeHolder.getSize() > 0) {
            range = new RangeBase(rangeHolder);
        }
        this.rangeFactory.setRangeDefault(key, range);
    }

    @Override
    public String[] getRangeHeader() {
        return this.rangeFactory.getHeader();
    }

    @Override
    public Object[][] getRangeNames() {
        return this.rangeFactory.getData();
    }

    @Override
    public void remove(MonKey key) {
        this.map.remove(key);
        if (this.totalKeySize != null) {
            this.decrementKeySize(key.getSize());
        }
    }

    @Override
    public void remove(String label, String units) {
        this.remove(new MonKeyImp(label, units));
    }

    @Override
    public boolean exists(MonKey key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean exists(String label, String units) {
        return this.map.containsKey(new MonKeyImp(label, units));
    }

    @Override
    public int getNumRows() {
        return this.map.size();
    }

    @Override
    public MonitorComposite getRootMonitor() {
        return new MonitorComposite(this.getMonitors());
    }

    @Override
    public MonitorComposite getComposite(String units) {
        return new MonitorComposite(this.getMonitors(units));
    }

    @Override
    public String getVersion() {
        return "2.76";
    }

    @Override
    public long getTotalKeySize() {
        return this.isTotalKeySizeTrackingEnabled() ? this.totalKeySize.get() : 0L;
    }

    private MonitorImp getTimeMonitor(MonKey key, boolean isPrimary) {
        return this.getMonitor(key, isPrimary, true);
    }

    private MonitorImp getMonitor(MonKey key, boolean isPrimary, boolean isTimeMonitor) {
        MonitorImp mon = this.getMonitor.getMon(key, isPrimary, isTimeMonitor);
        if (mon.isEnabled()) {
            mon = isTimeMonitor ? new TimeMon(key, mon.getMonInternals()) : new DecoMon(key, mon.getMonInternals());
        }
        return mon;
    }

    private MonitorImp getNanoMonitor(MonKey key) {
        boolean isPrimary = false;
        boolean isTimeMon = true;
        MonitorImp mon = this.getMonitor.getMon(key, isPrimary, isTimeMon);
        if (mon.isEnabled()) {
            mon = new TimeMonNano(key, mon.getMonInternals());
        }
        return mon;
    }

    private MonitorImp createMon(MonKey key, boolean isPrimary, boolean isTimeMonitor) {
        ActivityStats activityStats = new ActivityStats(new Counter(), this.primaryActive, this.allActive);
        RangeImp range = this.rangeFactory.getRangeDefault(key.getRangeKey(), activityStats);
        MonitorImp mon = new MonitorImp(key, range, activityStats, isTimeMonitor);
        if (this.isTotalKeySizeTrackingEnabled()) {
            this.incrementKeySize(key.getSize());
        }
        if (this.activityTracking) {
            mon.setActivityTracking(this.activityTracking);
        }
        mon.setPrimary(isPrimary);
        return mon;
    }

    private void incrementKeySize(int keySize) {
        this.totalKeySize.addAndGet(keySize);
    }

    private void decrementKeySize(int keySize) {
        this.totalKeySize.addAndGet(-keySize);
    }

    private MonitorImp[] getMonitors(String units) {
        MonitorImp[] monitors = this.getMonitors();
        if (monitors == null || units == null) {
            return null;
        }
        if ("AllMonitors".equalsIgnoreCase(units)) {
            return monitors;
        }
        ArrayList<MonitorImp> rows = new ArrayList<MonitorImp>(500);
        int size = monitors.length;
        for (int i = 0; i < size; ++i) {
            if (!units.equalsIgnoreCase(monitors[i].getMonKey().getRangeKey())) continue;
            rows.add(monitors[i]);
        }
        if (rows.size() == 0) {
            return null;
        }
        return rows.toArray(new MonitorImp[0]);
    }

    private Collection getAllMonitors() {
        Collection monitors = this.map.values();
        if (monitors == null || monitors.size() == 0) {
            return null;
        }
        return monitors;
    }

    private MonitorImp[] getMonitors() {
        Collection monitors = this.getAllMonitors();
        if (monitors == null || monitors.size() == 0) {
            return null;
        }
        return monitors.toArray(new MonitorImp[0]);
    }

    private MonitorImp getExistingMonitor(MonKey key) {
        return (MonitorImp)this.map.get(key);
    }

    private void putMon(MonKey key, MonitorImp mon) {
        this.map.put(key, mon);
    }

    @Override
    public void reset() {
        this.initialize();
    }

    @Override
    public void enableGlobalActive(boolean enable) {
        this.allActive.enable(enable);
    }

    @Override
    public boolean isGlobalActiveEnabled() {
        return this.allActive.isEnabled();
    }

    @Override
    @Deprecated
    public Iterator iterator() {
        return this.map.values().iterator();
    }

    @Override
    public Map getMap() {
        return this.map;
    }

    @Override
    public void enableActivityTracking(boolean enable) {
        this.activityTracking = enable;
        MonitorImp[] monitors = this.getMonitors();
        int len = monitors == null ? 0 : monitors.length;
        for (int i = 0; i < len; ++i) {
            monitors[i].setActivityTracking(enable);
        }
    }

    @Override
    public boolean isActivityTrackingEnabled() {
        return this.activityTracking;
    }

    @Override
    public int getMaxNumMonitors() {
        return this.maxMonitors;
    }

    @Override
    public void setMaxNumMonitors(int maxMonitors) {
        this.maxMonitors = maxMonitors;
    }

    private boolean monitorThresholdReached() {
        return this.maxMonitors > 0 && this.map.size() >= this.maxMonitors;
    }

    @Override
    public void enableTotalKeySizeTracking() {
        this.totalKeySize = new AtomicLong();
    }

    @Override
    public void disableTotalKeySizeTracking() {
        this.totalKeySize = null;
    }

    @Override
    public boolean isTotalKeySizeTrackingEnabled() {
        return this.totalKeySize != null;
    }

    @Override
    public int getMaxSqlSize() {
        return this.maxSqlSize;
    }

    @Override
    public void setMaxSqlSize(int size) {
        this.maxSqlSize = size;
    }

    private class GetMonitorMap
    extends GetMonitor {
        private GetMonitorMap() {
        }

        @Override
        protected synchronized MonitorImp getMon(MonKey key, boolean isPrimary, boolean isTimeMonitor) {
            MonitorImp mon = FactoryEnabled.this.getExistingMonitor(key);
            if (mon == null) {
                if (FactoryEnabled.this.monitorThresholdReached()) {
                    return NULL_MON;
                }
                mon = FactoryEnabled.this.createMon(key, isPrimary, isTimeMonitor);
                FactoryEnabled.this.putMon(key, mon);
            }
            return mon;
        }
    }

    private class GetMonitor {
        private GetMonitor() {
        }

        protected MonitorImp getMon(MonKey key, boolean isPrimary, boolean isTimeMonitor) {
            MonitorImp mon = FactoryEnabled.this.getExistingMonitor(key);
            if (mon == null) {
                if (FactoryEnabled.this.monitorThresholdReached()) {
                    return NULL_MON;
                }
                mon = FactoryEnabled.this.createMon(key, isPrimary, isTimeMonitor);
                MonitorImp tempMon = ((ConcurrentHashMap)FactoryEnabled.this.map).putIfAbsent(key, mon);
                if (tempMon != null) {
                    mon = tempMon;
                }
            }
            return mon;
        }
    }

    private static class RangeFactory
    implements DetailData {
        private Map rangeFactoryMap = Misc.createConcurrentMap(50);

        private RangeFactory() {
        }

        private void setRangeDefault(String key, RangeImp range) {
            this.rangeFactoryMap.put(key, range);
        }

        private RangeImp getRangeDefault(String key, ActivityStats activityStats) {
            RangeImp range = (RangeImp)this.rangeFactoryMap.get(key);
            if (range != null) {
                range = range.copy(activityStats);
            }
            return range;
        }

        @Override
        public String[] getHeader() {
            return new String[]{"RangeName"};
        }

        @Override
        public Object[][] getData() {
            return this.getRangeNames(this.getSortedRangeNames());
        }

        private Object[][] getRangeNames(Object[] rangeNames) {
            int len = rangeNames == null ? 0 : rangeNames.length;
            Object[][] data = new Object[len + 1][];
            data[0] = new Object[]{"AllMonitors"};
            for (int i = 0; i < len; ++i) {
                data[i + 1] = new Object[]{rangeNames[i]};
            }
            return data;
        }

        private Object[] getSortedRangeNames() {
            Object[] rangeNames = this.rangeFactoryMap.keySet().toArray();
            if (rangeNames == null) {
                return null;
            }
            Arrays.sort(rangeNames);
            return rangeNames;
        }
    }
}

