/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.CompositeListener;
import com.jamonapi.JAMonListener;
import com.jamonapi.utils.DetailData;

public final class ListenerType
implements DetailData {
    private JAMonListener listener;
    private Object lockObj;

    ListenerType(Object lockObj) {
        this.lockObj = lockObj;
    }

    private CompositeListener addCompositeListener(JAMonListener listenerToAdd) {
        if (this.listener instanceof CompositeListener) {
            return ((CompositeListener)this.listener).addListener(listenerToAdd);
        }
        return new CompositeListener().addListener(this.listener).addListener(listenerToAdd);
    }

    public final JAMonListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(JAMonListener listenerToAdd) {
        Object object = this.lockObj;
        synchronized (object) {
            this.listener = this.listener == null || listenerToAdd == null ? listenerToAdd : this.addCompositeListener(listenerToAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAMonListener getListener(String listenerName) {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.listener == null) {
                return null;
            }
            if (this.listener.getName().equalsIgnoreCase(listenerName)) {
                return this.listener;
            }
            if (this.listener instanceof CompositeListener) {
                return ((CompositeListener)this.listener).getListener(listenerName);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(String listenerName) {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.listener == null) {
                return;
            }
            if (this.listener.getName().equalsIgnoreCase(listenerName)) {
                this.listener = null;
            } else if (this.listener instanceof CompositeListener) {
                CompositeListener compListener = (CompositeListener)this.listener;
                compListener.removeListener(listenerName);
                if (compListener.getNumListeners() == 0) {
                    this.listener = null;
                } else if (compListener.getNumListeners() == 1) {
                    this.listener = compListener.getListener(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        Object object = this.lockObj;
        synchronized (object) {
            return this.listener != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListener(String listenerName) {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.listener == null) {
                return false;
            }
            if (this.listener.getName().equalsIgnoreCase(listenerName)) {
                return true;
            }
            if (this.listener instanceof CompositeListener) {
                return ((CompositeListener)this.listener).hasListener(listenerName);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[][] getData() {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.listener == null) {
                return null;
            }
            if (this.listener instanceof CompositeListener) {
                CompositeListener compListener = (CompositeListener)this.listener;
                return compListener.getData();
            }
            return new CompositeListener().addListener(this.listener).getData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getHeader() {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.listener instanceof CompositeListener) {
                CompositeListener compListener = (CompositeListener)this.listener;
                return compListener.getHeader();
            }
            return new CompositeListener().getHeader();
        }
    }
}

