/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import com.jamonapi.utils.BufferHolder;
import com.jamonapi.utils.BufferListDetailData;
import com.jamonapi.utils.DetailData;
import com.jamonapi.utils.FIFOBufferHolder;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BufferList
implements DetailData {
    private boolean enabled = true;
    private int bufferSize = 50;
    private String[] header;
    private BufferHolder bufferHolder;

    public BufferList(String[] header) {
        this.header = header;
        this.bufferHolder = new FIFOBufferHolder();
    }

    public BufferList(String[] header, BufferHolder bufferHolder) {
        this.header = header;
        this.bufferHolder = bufferHolder;
    }

    public BufferList(String[] header, int bufferSize) {
        this.header = header;
        this.bufferSize = bufferSize;
        this.bufferHolder = new FIFOBufferHolder();
    }

    public BufferList(String[] header, int bufferSize, BufferHolder bufferHolder) {
        this.header = header;
        this.bufferSize = bufferSize;
        this.bufferHolder = bufferHolder;
    }

    private BufferList(String[] header, int bufferSize, boolean enabled, BufferHolder bufferHolder) {
        this.header = header;
        this.bufferSize = bufferSize;
        this.enabled = enabled;
        this.bufferHolder = bufferHolder;
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    public synchronized void setBufferHolder(BufferHolder bufferHolder) {
        this.bufferHolder = bufferHolder;
    }

    public synchronized void setBufferSize(int newBufferSize) {
        if (this.bufferSize > newBufferSize) {
            this.resetBuffer(this.reduceBuffer(newBufferSize));
        }
        this.bufferSize = newBufferSize;
    }

    private LinkedList reduceBuffer(int newSize) {
        LinkedList newBuffer = new LinkedList();
        List original = this.bufferHolder.getOrderedCollection();
        Collections.reverse(original);
        Iterator iter = original.iterator();
        for (int i = 0; iter.hasNext() && i < newSize; ++i) {
            newBuffer.add(iter.next());
        }
        return newBuffer;
    }

    public synchronized void resetBuffer() {
        this.reset();
    }

    private void resetBuffer(LinkedList list) {
        this.bufferHolder.setCollection(list);
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    public boolean hasData() {
        return !this.isEmpty();
    }

    public int getRowCount() {
        return this.bufferHolder == null ? 0 : this.bufferHolder.getCollection().size();
    }

    public List getCollection() {
        return this.bufferHolder.getCollection();
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void enable() {
        this.enabled = true;
    }

    public synchronized void disable() {
        this.enabled = false;
    }

    public synchronized void reset() {
        this.bufferHolder.setCollection(new LinkedList());
    }

    @Override
    public String[] getHeader() {
        return this.header;
    }

    @Override
    @Deprecated
    public Object[][] getData() {
        return new BufferListDetailData(this).getData();
    }

    public DetailData getDetailData() {
        return new BufferListDetailData(this);
    }

    public synchronized void addRow(Object[] row) {
        this.addRow((Object)row);
    }

    public synchronized void addRow(Object obj) {
        if (!this.enabled || this.bufferSize <= 0) {
            return;
        }
        if (this.getRowCount() >= this.bufferSize && this.bufferHolder.shouldReplaceWith(obj)) {
            this.bufferHolder.remove(obj);
        }
        if (this.getRowCount() < this.bufferSize) {
            this.bufferHolder.add(obj);
        }
    }

    public synchronized BufferList copy() {
        return new BufferList(this.header, this.bufferSize, this.enabled, this.bufferHolder.copy());
    }
}

