/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.log4j;

import com.jamonapi.JAMonListenerFactory;
import com.jamonapi.MonKey;
import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.log4j.Log4jBufferListener;
import com.jamonapi.log4j.Log4jMonKey;
import com.jamonapi.utils.DefaultGeneralizer;
import com.jamonapi.utils.Generalizer;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class JAMonAppender
extends AppenderSkeleton {
    private final String PREFIX = "com.jamonapi.log4j.JAMonAppender.";
    private int bufferSize = 100;
    private String units = "log4j";
    private boolean enableListenerDetails = true;
    private boolean enableLevelMonitoring = true;
    private boolean generalize = false;
    private Generalizer generalizer = new DefaultGeneralizer();

    protected void append(LoggingEvent event) {
        String message;
        String string = message = this.getLayout() == null ? event.getRenderedMessage() : this.getLayout().format(event);
        if (this.getEnableLevelMonitoring()) {
            MonitorFactory.add(this.createKey("com.jamonapi.log4j.JAMonAppender.TOTAL", message, event), 1.0);
            MonitorFactory.add(this.createKey("com.jamonapi.log4j.JAMonAppender." + event.getLevel(), message, event), 1.0);
        }
        if (this.getGeneralize()) {
            MonitorFactory.add(this.createKey(this.generalize(message), message, event), 1.0);
        }
    }

    private MonKey createKey(String summaryLabel, String detailLabel, LoggingEvent event) {
        if (this.enableListenerDetails) {
            return new Log4jMonKey(summaryLabel, detailLabel, this.units, event);
        }
        return new MonKeyImp(summaryLabel, detailLabel, this.units);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public boolean getEnableListenerDetails() {
        return this.enableListenerDetails;
    }

    public void setEnableListenerDetails(boolean arrayDetails) {
        this.enableListenerDetails = arrayDetails;
    }

    public void setEnableLevelMonitoring(boolean enableLevelMonitoring) {
        this.enableLevelMonitoring = enableLevelMonitoring;
    }

    public boolean getEnableLevelMonitoring() {
        return this.enableLevelMonitoring;
    }

    public void setEnableListeners(String level) {
        if (Level.DEBUG.toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender." + Level.DEBUG, this.units));
        } else if (Level.INFO.toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender." + Level.INFO, this.units));
        } else if (Level.WARN.toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender." + Level.WARN, this.units));
        } else if (Level.ERROR.toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender." + Level.ERROR, this.units));
        } else if (Level.FATAL.toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender." + Level.FATAL, this.units));
        } else if ("TOTAL".toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender.TOTAL", this.units));
        } else if (Level.ALL.toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender." + Level.DEBUG, this.units));
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender." + Level.INFO, this.units));
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender." + Level.WARN, this.units));
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender." + Level.ERROR, this.units));
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender." + Level.FATAL, this.units));
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender.TOTAL", this.units));
        } else if ("BASIC".toString().equalsIgnoreCase(level.toUpperCase())) {
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender.TOTAL", this.units));
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender." + Level.ERROR, this.units));
            this.addDefaultListener(MonitorFactory.getMonitor("com.jamonapi.log4j.JAMonAppender." + Level.FATAL, this.units));
        }
    }

    private void addDefaultListener(Monitor mon) {
        if (!mon.hasListeners()) {
            Log4jBufferListener listener = new Log4jBufferListener();
            listener.getBufferList().setBufferSize(this.bufferSize);
            mon.addListener("value", listener);
        }
    }

    public void setListenerBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setGeneralize(boolean generalize) {
        this.generalize = generalize;
    }

    public boolean getGeneralize() {
        return this.generalize;
    }

    private String generalize(String detailedMessage) {
        return this.generalizer != null ? this.generalizer.generalize(detailedMessage) : detailedMessage;
    }

    public void setEnableDefaultGeneralizer(boolean enableDefaultGeneralizer) {
        if (enableDefaultGeneralizer) {
            this.generalizer = new DefaultGeneralizer();
            this.setGeneralize(true);
        } else {
            this.generalizer = null;
        }
    }

    public boolean hasGeneralizer() {
        return this.generalizer != null;
    }

    public void setGeneralizerClass(Generalizer generalizer) {
        this.generalizer = generalizer;
    }

    public void setGeneralizerDynamic(String generalizerClassStr) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.generalizer = (Generalizer)Class.forName(generalizerClassStr).newInstance();
    }

    static {
        JAMonListenerFactory.put(new Log4jBufferListener());
    }
}

