/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.CopyJAMonListener;
import com.jamonapi.JAMonBufferListener;
import com.jamonapi.JAMonListener;
import com.jamonapi.NExtremeArrayBufferHolder;
import com.jamonapi.SharedJAMonBufferListener;
import com.jamonapi.utils.BufferHolder;
import com.jamonapi.utils.BufferList;
import com.jamonapi.utils.DateMathComparator;
import com.jamonapi.utils.FIFOBufferHolder;
import com.jamonapi.utils.JAMonArrayComparator;
import com.jamonapi.utils.Misc;
import java.util.Iterator;
import java.util.Map;

public class JAMonListenerFactory {
    private static final boolean NATURAL_ORDER = true;
    private static final boolean REVERSE_ORDER = false;
    private static String[] HEADER = new String[]{"ListenerName", "Listener"};
    private static Map map = Misc.createCaseInsensitiveMap();

    public static void put(JAMonListener jamonListener) {
        map.put(jamonListener.getName(), jamonListener);
    }

    public static Object[][] getData() {
        Iterator iter = map.entrySet().iterator();
        Object[][] data = new Object[map.size()][];
        int i = 0;
        while (iter.hasNext()) {
            data[i] = new Object[2];
            Map.Entry entry = iter.next();
            data[i][0] = entry.getKey();
            data[i][1] = entry.getValue();
            ++i;
        }
        return data;
    }

    public static String[] getHeader() {
        return HEADER;
    }

    public static JAMonListener get(String listenerName) {
        try {
            JAMonListener factoryInstance = (JAMonListener)map.get(listenerName);
            if (factoryInstance instanceof CopyJAMonListener) {
                return ((CopyJAMonListener)((Object)factoryInstance)).copy();
            }
            JAMonListener newInst = (JAMonListener)factoryInstance.getClass().newInstance();
            newInst.setName(factoryInstance.getName());
            return newInst;
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting listener from factory: " + listenerName + ", " + e);
        }
    }

    private static BufferHolder getBufferHolderNLargest7Days() {
        JAMonArrayComparator jac = new JAMonArrayComparator();
        DateMathComparator dmc = new DateMathComparator(6, -7);
        jac.addCompareCol(JAMonBufferListener.DATE_COL, dmc);
        jac.addCompareCol(JAMonBufferListener.VALUE_COL, true);
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(jac);
        return bufferHolder;
    }

    private static BufferHolder getBufferHolderNLargest24Hrs() {
        JAMonArrayComparator jac = new JAMonArrayComparator();
        DateMathComparator dmc = new DateMathComparator(11, -24);
        jac.addCompareCol(JAMonBufferListener.DATE_COL, dmc);
        jac.addCompareCol(JAMonBufferListener.VALUE_COL, true);
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(jac);
        return bufferHolder;
    }

    private static BufferHolder getBufferHolderNSmallest7Days() {
        JAMonArrayComparator jac = new JAMonArrayComparator();
        DateMathComparator dmc = new DateMathComparator(6, -7);
        jac.addCompareCol(JAMonBufferListener.DATE_COL, dmc);
        jac.addCompareCol(JAMonBufferListener.VALUE_COL, false);
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(jac);
        return bufferHolder;
    }

    private static BufferHolder getBufferHolderNSmallest24Hrs() {
        JAMonArrayComparator jac = new JAMonArrayComparator();
        DateMathComparator dmc = new DateMathComparator(11, -24);
        jac.addCompareCol(JAMonBufferListener.DATE_COL, dmc);
        jac.addCompareCol(JAMonBufferListener.VALUE_COL, false);
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(jac);
        return bufferHolder;
    }

    private static JAMonBufferListener getFIFO() {
        FIFOBufferHolder bufferHolder = new FIFOBufferHolder();
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, bufferHolder);
        return new JAMonBufferListener("FIFOBuffer", bufferList);
    }

    private static JAMonBufferListener getNLargest() {
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(true, JAMonBufferListener.VALUE_COL);
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, bufferHolder);
        return new JAMonBufferListener("NLargestValueBuffer", bufferList);
    }

    private static JAMonBufferListener getNSmallest() {
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(false, JAMonBufferListener.VALUE_COL);
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, bufferHolder);
        return new JAMonBufferListener("NSmallestValueBuffer", bufferList);
    }

    private static JAMonBufferListener getNLargest7Days() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNLargest7Days());
        return new JAMonBufferListener("NLargestValueBuffer7Days", bufferList);
    }

    private static JAMonBufferListener getNLargest24Hrs() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNLargest24Hrs());
        return new JAMonBufferListener("NLargestValueBuffer24Hrs", bufferList);
    }

    private static JAMonBufferListener getNSmallest7Days() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNSmallest7Days());
        return new JAMonBufferListener("NSmallestValueBuffer7Days", bufferList);
    }

    private static JAMonBufferListener getNSmallest24Hrs() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNSmallest24Hrs());
        return new JAMonBufferListener("NSmallestValueBuffer24Hrs", bufferList);
    }

    private static JAMonBufferListener getSharedFIFO() {
        FIFOBufferHolder bufferHolder = new FIFOBufferHolder();
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, bufferHolder);
        return new SharedJAMonBufferListener("SharedFIFOBuffer", bufferList);
    }

    private static JAMonBufferListener getSharedNSmallest() {
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(false, JAMonBufferListener.VALUE_COL);
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, bufferHolder);
        return new SharedJAMonBufferListener("SharedNSmallestValueBuffer", bufferList);
    }

    private static JAMonBufferListener getSharedNLargest() {
        NExtremeArrayBufferHolder bufferHolder = new NExtremeArrayBufferHolder(true, JAMonBufferListener.VALUE_COL);
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, bufferHolder);
        return new SharedJAMonBufferListener("SharedNLargestValueBuffer", bufferList);
    }

    private static JAMonBufferListener getSharedNLargest7Days() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNLargest7Days());
        return new SharedJAMonBufferListener("SharedNLargestValueBuffer7Days", bufferList);
    }

    private static JAMonBufferListener getSharedNLargest24Hrs() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNLargest24Hrs());
        return new SharedJAMonBufferListener("SharedNLargestValueBuffer24Hrs", bufferList);
    }

    private static JAMonBufferListener getSharedNSmallest7Days() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNSmallest7Days());
        return new SharedJAMonBufferListener("SharedNSmallestValueBuffer7Days", bufferList);
    }

    private static JAMonBufferListener getSharedNSmallest24Hrs() {
        BufferList bufferList = new BufferList(JAMonBufferListener.DEFAULT_HEADER, JAMonListenerFactory.getBufferHolderNSmallest24Hrs());
        return new SharedJAMonBufferListener("SharedNSmallestValueBuffer24Hrs", bufferList);
    }

    static {
        JAMonListenerFactory.put(JAMonListenerFactory.getFIFO());
        JAMonListenerFactory.put(JAMonListenerFactory.getNLargest());
        JAMonListenerFactory.put(JAMonListenerFactory.getNSmallest());
        JAMonListenerFactory.put(JAMonListenerFactory.getNLargest7Days());
        JAMonListenerFactory.put(JAMonListenerFactory.getNLargest24Hrs());
        JAMonListenerFactory.put(JAMonListenerFactory.getNSmallest7Days());
        JAMonListenerFactory.put(JAMonListenerFactory.getNSmallest24Hrs());
        JAMonListenerFactory.put(JAMonListenerFactory.getSharedFIFO());
        JAMonListenerFactory.put(JAMonListenerFactory.getSharedNLargest());
        JAMonListenerFactory.put(JAMonListenerFactory.getSharedNSmallest());
        JAMonListenerFactory.put(JAMonListenerFactory.getSharedNLargest7Days());
        JAMonListenerFactory.put(JAMonListenerFactory.getSharedNLargest24Hrs());
        JAMonListenerFactory.put(JAMonListenerFactory.getSharedNSmallest7Days());
        JAMonListenerFactory.put(JAMonListenerFactory.getSharedNSmallest24Hrs());
    }
}

