/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public class JamonPropertiesLoader {
    private String fileName;

    public JamonPropertiesLoader() {
        this("jamonapi.properties");
    }

    JamonPropertiesLoader(String fileName) {
        this.fileName = fileName;
    }

    public Properties getJamonProperties() {
        Properties defaults = this.getDefaults();
        Properties userProvided = this.propertyLoader(this.fileName);
        this.replaceWithCommandLineProps(userProvided, defaults);
        Properties jamonProps = new Properties(defaults);
        jamonProps.putAll((Map<?, ?>)userProvided);
        return jamonProps;
    }

    public URL getPropertiesDirectory() {
        return this.getClass().getClassLoader().getResource(".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Properties propertyLoader(String fileName) {
        Properties properties = new Properties();
        InputStream input = null;
        try {
            input = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (input != null) {
                properties.load(input);
            }
            this.close(input);
        }
        catch (Throwable t) {
            this.close(input);
            catch (Throwable throwable) {
                this.close(input);
                throw throwable;
            }
        }
        return properties;
    }

    void close(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void replaceWithCommandLineProps(Properties properties, Properties defaults) {
        for (Object key : defaults.keySet()) {
            String value = System.getProperty(key.toString());
            if (value == null) continue;
            properties.put(key, value);
        }
    }

    Properties getDefaults() {
        Properties defaults = new Properties();
        defaults.put("distributedDataRefreshRateInMinutes", "5");
        defaults.put("jamonDataPersister", "com.jamonapi.distributed.DistributedJamonHazelcastPersister");
        return defaults;
    }
}

