/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.aop.spring;

import com.jamonapi.JAMonListenerFactory;
import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.aop.spring.JamonAopKeyHelper;
import com.jamonapi.aop.spring.JamonAopKeyHelperInt;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class JamonAspect {
    private static final String EXCEPTION = "Exception";
    protected JamonAopKeyHelperInt keyHelper;

    public JamonAspect() {
        this.keyHelper = new JamonAopKeyHelper();
        this.setExceptionBufferListener(true);
    }

    public JamonAspect(JamonAopKeyHelperInt keyHelper) {
        this.setKeyHelper(keyHelper);
        this.setExceptionBufferListener(true);
    }

    public Object monitor(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object retVal = null;
        String label = this.keyHelper.getLabel(proceedingJoinPoint);
        String details = this.keyHelper.getDetails(proceedingJoinPoint);
        MonKeyImp key = new MonKeyImp(label, details, "ms.");
        Monitor mon = MonitorFactory.start(key);
        try {
            retVal = proceedingJoinPoint.proceed();
        }
        catch (Throwable t) {
            String exceptionDetails = this.keyHelper.getDetails(proceedingJoinPoint, t);
            key.setDetails(exceptionDetails);
            this.trackException(t, exceptionDetails);
            throw t;
        }
        finally {
            mon.stop();
        }
        return retVal;
    }

    private void trackException(Throwable exception, String exceptionDetails) {
        MonitorFactory.add(new MonKeyImp(this.keyHelper.getExceptionLabel(exception), exceptionDetails, EXCEPTION), 1.0);
        MonitorFactory.add(new MonKeyImp("com.jamonapi.Exceptions", exceptionDetails, EXCEPTION), 1.0);
    }

    public void setKeyHelper(JamonAopKeyHelperInt keyHelper) {
        this.keyHelper = keyHelper;
    }

    public void setExceptionBufferListener(boolean enable) {
        MonKeyImp key = new MonKeyImp("com.jamonapi.Exceptions", EXCEPTION);
        boolean hasBufferListener = MonitorFactory.getMonitor(key).hasListener("value", "FIFOBuffer");
        if (enable && !hasBufferListener) {
            MonitorFactory.getMonitor(key).addListener("value", JAMonListenerFactory.get("FIFOBuffer"));
        } else if (!enable && hasBufferListener) {
            MonitorFactory.getMonitor(key).removeListener("value", "FIFOBuffer");
        }
    }

    public void setUseArgsWithMethodDetails(boolean useArgsWithMethodDetails) {
        this.keyHelper.setUseArgsWithMethodDetails(useArgsWithMethodDetails);
    }

    public void setUseArgsWithExceptionDetails(boolean useArgsWithExceptionDetails) {
        this.keyHelper.setUseArgsWithExceptionDetails(useArgsWithExceptionDetails);
    }
}

