/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.distributed;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorFactory;
import com.jamonapi.distributed.JamonDataPersister;
import com.jamonapi.distributed.LocalJamonDataPersister;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class DistributedJamonHazelcastPersister
implements JamonDataPersister {
    private IMap<String, MonitorComposite> jamonDataMap;
    private IMap<String, Date> instances;
    private HazelcastInstance hazelCast;
    private LocalJamonDataPersister localJamonData = new LocalJamonDataPersister();

    public DistributedJamonHazelcastPersister() {
        this.hazelCast = Hazelcast.newHazelcastInstance();
    }

    public DistributedJamonHazelcastPersister(HazelcastInstance hazelCast) {
        this.hazelCast = hazelCast;
    }

    @Override
    public Set<String> getInstances() {
        TreeSet<String> allInstances = new TreeSet<String>(this.localJamonData.getInstances());
        allInstances.addAll(this.getHazelcastInstances());
        return allInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put() {
        String label = DistributedJamonHazelcastPersister.class.getCanonicalName() + ".put()";
        Monitor mon = MonitorFactory.getTimeMonitor(label);
        if (mon.getActive() < 1.0) {
            mon.start();
            try {
                this.intitialize();
                String key = this.getInstance();
                this.jamonDataMap.set((Object)key, (Object)MonitorFactory.getRootMonitor().setInstanceName(key));
                this.instances.set((Object)key, (Object)new Date());
            }
            catch (Throwable t) {
                MonitorFactory.addException(mon, t);
            }
            finally {
                mon.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitorComposite get(String key) {
        MonitorComposite monitorComposite = this.localJamonData.get(key);
        if (monitorComposite == null) {
            String label = DistributedJamonHazelcastPersister.class.getCanonicalName() + ".get()";
            Monitor mon = MonitorFactory.start(label);
            try {
                this.intitialize();
                this.instances.get((Object)key);
                monitorComposite = (MonitorComposite)this.jamonDataMap.get((Object)key);
            }
            catch (Throwable t) {
                MonitorFactory.addException(mon, t);
                MonitorComposite monitorComposite2 = this.localJamonData.get("local");
                return monitorComposite2;
            }
            finally {
                mon.stop();
            }
        }
        return monitorComposite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String instanceKey) {
        if ("local".equalsIgnoreCase(instanceKey)) {
            this.localJamonData.remove(instanceKey);
            return;
        }
        String label = DistributedJamonHazelcastPersister.class.getCanonicalName() + ".remove()";
        Monitor mon = MonitorFactory.start(label);
        try {
            this.intitialize();
            this.instances.remove((Object)instanceKey);
            this.jamonDataMap.remove((Object)instanceKey);
        }
        catch (Throwable t) {
            MonitorFactory.addException(mon, t);
        }
        finally {
            mon.stop();
        }
    }

    @Override
    public String getInstance() {
        try {
            this.intitialize();
            return this.hazelCast.getCluster().getLocalMember().toString();
        }
        catch (Throwable t) {
            MonitorFactory.addException(t);
            return null;
        }
    }

    public void shutDownHazelCast() {
        try {
            this.intitialize();
            this.hazelCast.shutdown();
        }
        catch (Throwable t) {
            MonitorFactory.addException(t);
        }
    }

    private Set<String> getHazelcastInstances() {
        try {
            this.intitialize();
            return this.instances.keySet();
        }
        catch (Throwable e) {
            MonitorFactory.addException(e);
            HashSet<String> error = new HashSet<String>();
            error.add("HazelcastExceptionThrown");
            return error;
        }
    }

    private void intitialize() {
        if (this.jamonDataMap == null) {
            this.jamonDataMap = this.hazelCast.getMap(MonitorComposite.class.getCanonicalName());
            this.instances = this.hazelCast.getMap("com.jamonapi.instances");
        }
    }
}

