/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.log4j;

import com.jamonapi.JAMonBufferListener;
import com.jamonapi.JAMonListener;
import com.jamonapi.MonKey;
import com.jamonapi.Monitor;
import com.jamonapi.log4j.Log4jMonKey;
import com.jamonapi.utils.BufferList;
import com.jamonapi.utils.DetailData;
import com.jamonapi.utils.DetailDataWrapper;
import com.jamonapi.utils.Misc;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jBufferListener
extends JAMonBufferListener {
    private static final long serialVersionUID = 278L;
    private boolean isLog4jMonKey = false;
    private static JAMonBufferListener.HeaderInfo log4jHeader = Log4jBufferListener.getHeaderInfo(new String[]{"Label", "LoggerName", "Level", "ThreadName", "Exception"});

    public Log4jBufferListener() {
        super("Log4jBufferListener");
    }

    public Log4jBufferListener(String name) {
        super(name);
    }

    public Log4jBufferListener(String name, BufferList list) {
        super(name, list);
    }

    private Log4jBufferListener(String name, BufferList list, boolean isLog4jMonKey) {
        this(name, list);
        this.isLog4jMonKey = isLog4jMonKey;
    }

    @Override
    public void processEvent(Monitor mon) {
        MonKey monKey = mon.getMonKey();
        if (monKey instanceof Log4jMonKey && !this.isLog4jMonKey) {
            this.isLog4jMonKey = true;
        }
        if (this.isLog4jMonKey) {
            Log4jMonKey key = (Log4jMonKey)monKey;
            this.getBufferList().addRow(this.toArray(key.getLoggingEvent(), mon));
        } else {
            super.processEvent(mon);
        }
    }

    protected Object[] toArray(LoggingEvent event, Monitor mon) {
        Object[] data = log4jHeader.getData(mon);
        data[0] = mon.getMonKey().getDetails();
        data[1] = event.getLoggerName();
        data[2] = event.getLevel().toString();
        data[3] = event.getThreadName();
        data[4] = event.getThrowableInformation() == null || event.getThrowableInformation().getThrowable() == null ? "" : Misc.getExceptionTrace(event.getThrowableInformation().getThrowable());
        return data;
    }

    @Override
    public JAMonListener copy() {
        return new Log4jBufferListener(this.getName(), this.getBufferList().copy(), this.isLog4jMonKey);
    }

    public String[] getHeader() {
        if (this.isLog4jMonKey) {
            return log4jHeader.getHeader();
        }
        return this.getBufferList().getHeader();
    }

    @Override
    public DetailData getDetailData() {
        DetailData data = super.getDetailData();
        if (this.isLog4jMonKey) {
            return new DetailDataWrapper(log4jHeader.getHeader(), data.getData());
        }
        return data;
    }
}

