/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.FactoryDisabled;
import com.jamonapi.FactoryEnabled;
import com.jamonapi.JamonPropertiesLoader;
import com.jamonapi.MonKey;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorFactoryInterface;
import com.jamonapi.RangeHolder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MonitorFactory {
    public static final String EXCEPTIONS_LABEL = "com.jamonapi.Exceptions";
    private static MonitorFactoryInterface factory;
    private static MonitorFactoryInterface enabledFactory;
    private static MonitorFactoryInterface disabledFactory;
    private static MonitorFactoryInterface debugFactory;

    public static MonitorFactoryInterface getFactory() {
        return factory;
    }

    public static MonitorFactoryInterface getDebugFactory() {
        if (MonitorFactory.isEnabled()) {
            return debugFactory;
        }
        return disabledFactory;
    }

    public static Monitor add(String label, String units, double value) {
        return factory.add(label, units, value);
    }

    public static Monitor add(MonKey key, double value) {
        return factory.add(key, value);
    }

    public static Monitor start(String label) {
        return factory.start(label);
    }

    public static Monitor start() {
        return factory.start();
    }

    public static Monitor getMonitor() {
        return factory.getMonitor();
    }

    public static Monitor startPrimary(String label) {
        return factory.startPrimary(label);
    }

    public static Monitor startPrimary(MonKey key) {
        return factory.startPrimary(key);
    }

    public static Monitor start(MonKey key) {
        return factory.start(key);
    }

    public static Monitor startNano(String label) {
        return factory.startNano(label);
    }

    public static Monitor startNano(MonKey key) {
        return factory.startNano(key);
    }

    public static Monitor getMonitor(String label, String units) {
        return factory.getMonitor(label, units);
    }

    public static Monitor getMonitor(MonKey key) {
        return factory.getMonitor(key);
    }

    public static Monitor getTimeMonitor(String label) {
        return factory.getTimeMonitor(label);
    }

    public static Monitor getTimeMonitor(MonKey key) {
        return factory.getTimeMonitor(key);
    }

    public static boolean exists(String label, String units) {
        return factory.exists(label, units);
    }

    public static boolean exists(MonKey key) {
        return factory.exists(key);
    }

    public static MonitorComposite getComposite(String units) {
        return factory.getComposite(units);
    }

    public static int getNumRows() {
        return factory.getNumRows();
    }

    public static String[] getRangeHeader() {
        return factory.getRangeHeader();
    }

    public static Object[][] getRangeNames() {
        return factory.getRangeNames();
    }

    public static MonitorComposite getRootMonitor() {
        return factory.getRootMonitor();
    }

    public static String getVersion() {
        return factory.getVersion();
    }

    public static void remove(String label, String units) {
        factory.remove(label, units);
    }

    public static void remove(MonKey key) {
        factory.remove(key);
    }

    public static void setMap(Map map) {
        factory.setMap(map);
    }

    public static Map getMap() {
        return factory.getMap();
    }

    public static void setRangeDefault(String key, RangeHolder rangeHolder) {
        factory.setRangeDefault(key, rangeHolder);
    }

    public static void setEnabled(boolean enable) {
        factory = enable ? enabledFactory : disabledFactory;
    }

    public static void setDebugEnabled(boolean enable) {
        debugFactory = enable ? enabledFactory : disabledFactory;
    }

    public static void enable() {
        MonitorFactory.setEnabled(true);
    }

    public static void disable() {
        MonitorFactory.setEnabled(false);
    }

    public static boolean isEnabled() {
        return factory == enabledFactory;
    }

    public static boolean isDebugEnabled() {
        return debugFactory == enabledFactory;
    }

    public static boolean isGlobalActiveEnabled() {
        return factory.isGlobalActiveEnabled();
    }

    public static void enableGlobalActive(boolean enable) {
        factory.enableGlobalActive(enable);
    }

    public static void reset() {
        if (MonitorFactory.isEnabled()) {
            MonitorFactory.init();
        }
    }

    private static void init() {
        boolean isKeySizeTrackingEnabled = factory == null ? false : factory.isTotalKeySizeTrackingEnabled();
        debugFactory = enabledFactory = new FactoryEnabled();
        factory = enabledFactory;
        if (isKeySizeTrackingEnabled) {
            factory.enableTotalKeySizeTracking();
        }
        disabledFactory = new FactoryDisabled(enabledFactory);
    }

    @Deprecated
    public static String[] getHeader() {
        return factory.getRootMonitor().getBasicHeader();
    }

    public static Object[][] getData() {
        return factory.getRootMonitor().getBasicData();
    }

    public static String getReport() {
        return factory.getRootMonitor().getReport();
    }

    public static String getReport(String units) {
        return MonitorFactory.getComposite(units).getReport();
    }

    @Deprecated
    public static Iterator iterator() {
        return factory.iterator();
    }

    public static void enableActivityTracking(boolean enable) {
        factory.enableActivityTracking(enable);
    }

    public static boolean isActivityTrackingEnabled() {
        return factory.isActivityTrackingEnabled();
    }

    public static void setMaxNumMonitors(int maxMonitors) {
        factory.setMaxNumMonitors(maxMonitors);
    }

    public static int getMaxNumMonitors() {
        return factory.getMaxNumMonitors();
    }

    public static void enableTotalKeySizeTracking() {
        factory.enableTotalKeySizeTracking();
    }

    public static void disableTotalKeySizeTracking() {
        factory.disableTotalKeySizeTracking();
    }

    public static boolean isTotalKeySizeTrackingEnabled() {
        return factory.isTotalKeySizeTrackingEnabled();
    }

    public static long getTotalKeySize() {
        return factory.getTotalKeySize();
    }

    public static void setMaxSqlSize(int size) {
        factory.setMaxSqlSize(size);
    }

    public static int getMaxSqlSize() {
        return factory.getMaxSqlSize();
    }

    public static Monitor addException(Monitor mon, Throwable throwable) {
        return factory.addException(mon, throwable);
    }

    public static Monitor addException(Throwable throwable) {
        return factory.addException(throwable);
    }

    public static void addListeners(List<JamonPropertiesLoader.JamonListener> listeners) {
        factory.addListeners(listeners);
    }

    static {
        MonitorFactory.init();
    }
}

