/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.jmx;

import com.jamonapi.JamonPropertiesLoader;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.jmx.ExceptionDeltaMXBeanImp;
import com.jamonapi.jmx.ExceptionMXBeanImp;
import com.jamonapi.jmx.GcMXBeanImp;
import com.jamonapi.jmx.JamonMXBeanImp;
import com.jamonapi.jmx.Log4jDeltaMXBeanImp;
import com.jamonapi.jmx.Log4jMXBeanImp;
import com.jamonapi.jmx.MonitorMXBean;
import com.jamonapi.jmx.MonitorMXBeanFactory;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JmxUtils {
    static long getCount(String label, String units) {
        if (MonitorFactory.exists(label, units)) {
            Monitor mon = MonitorFactory.getMonitor(label, units);
            return (long)mon.getHits();
        }
        return 0L;
    }

    static double getDouble(String label, String units, String value) {
        if (MonitorFactory.exists(label, units)) {
            Monitor mon = MonitorFactory.getMonitor(label, units);
            return (Double)mon.getValue(value);
        }
        return 0.0;
    }

    static Date getDate(String label, String units, String value) {
        if (MonitorFactory.exists(label, units)) {
            Monitor mon = MonitorFactory.getMonitor(label, units);
            return (Date)mon.getValue(value);
        }
        return null;
    }

    static ObjectName getObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerMbeans() {
        JmxUtils.registerMbeans(ManagementFactory.getPlatformMBeanServer());
    }

    public static void registerMbeans(MBeanServer mBeanServer) {
        Object mxBeanImp = null;
        try {
            mBeanServer.registerMBean(new Log4jMXBeanImp(), Log4jMXBeanImp.getObjectName());
            mBeanServer.registerMBean(new ExceptionMXBeanImp(), ExceptionMXBeanImp.getObjectName());
            mBeanServer.registerMBean(new ExceptionDeltaMXBeanImp(), ExceptionDeltaMXBeanImp.getObjectName());
            mBeanServer.registerMBean(new Log4jDeltaMXBeanImp(), Log4jDeltaMXBeanImp.getObjectName());
            mBeanServer.registerMBean(new JamonMXBeanImp(), JamonMXBeanImp.getObjectName());
            JmxUtils.registerGcMXBean(mBeanServer);
            JmxUtils.registerMbeansFromPropsFile(mBeanServer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void registerMbeansFromPropsFile(MBeanServer mBeanServer) throws Exception {
        JamonPropertiesLoader loader = new JamonPropertiesLoader();
        List<JamonPropertiesLoader.JamonJmxBean> jamonJmxBeans = loader.getMxBeans();
        for (JamonPropertiesLoader.JamonJmxBean beanInfo : jamonJmxBeans) {
            MonitorMXBean mXbean = MonitorMXBeanFactory.create(beanInfo.getLabel(), beanInfo.getUnits(), beanInfo.getName());
            mBeanServer.registerMBean(mXbean, MonitorMXBeanFactory.getObjectName(mXbean));
            MonitorMXBean mXbeanDelta = MonitorMXBeanFactory.createDelta(beanInfo.getLabel(), beanInfo.getUnits(), beanInfo.getName());
            mBeanServer.registerMBean(mXbeanDelta, MonitorMXBeanFactory.getDeltaObjectName(mXbeanDelta));
        }
    }

    public static void unregisterMbeans() {
        JmxUtils.unregisterMbeans(ManagementFactory.getPlatformMBeanServer());
    }

    public static void unregisterMbeans(MBeanServer mBeanServer) {
        try {
            mBeanServer.unregisterMBean(Log4jMXBeanImp.getObjectName());
            mBeanServer.unregisterMBean(ExceptionMXBeanImp.getObjectName());
            mBeanServer.unregisterMBean(ExceptionDeltaMXBeanImp.getObjectName());
            mBeanServer.unregisterMBean(Log4jDeltaMXBeanImp.getObjectName());
            mBeanServer.unregisterMBean(JamonMXBeanImp.getObjectName());
            JmxUtils.unregisterGcMXBean(mBeanServer);
            JmxUtils.unregisterMbeansFromPropsFile(mBeanServer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void unregisterMbeansFromPropsFile(MBeanServer mBeanServer) throws Exception {
        JamonPropertiesLoader loader = new JamonPropertiesLoader();
        List<JamonPropertiesLoader.JamonJmxBean> jamonJmxBeans = loader.getMxBeans();
        for (JamonPropertiesLoader.JamonJmxBean beanInfo : jamonJmxBeans) {
            MonitorMXBean mXbean = MonitorMXBeanFactory.create(beanInfo.getLabel(), beanInfo.getUnits(), beanInfo.getName());
            mBeanServer.unregisterMBean(MonitorMXBeanFactory.getObjectName(mXbean));
            MonitorMXBean mXbeanDelta = MonitorMXBeanFactory.createDelta(beanInfo.getLabel(), beanInfo.getUnits(), beanInfo.getName());
            mBeanServer.unregisterMBean(MonitorMXBeanFactory.getDeltaObjectName(mXbeanDelta));
        }
    }

    public static Set<ObjectName> getGarbageCollectionMbeans(MBeanServer mBeanServer) throws Exception {
        return JmxUtils.queryMBeans(mBeanServer, "type=GarbageCollector");
    }

    static Set<ObjectName> queryMBeans(MBeanServer mBeanServer, String containsStr) {
        Set<ObjectName> mbeans = mBeanServer.queryNames(null, null);
        HashSet<ObjectName> gcMbeans = new HashSet<ObjectName>();
        for (ObjectName objectInstance : mbeans) {
            if (!objectInstance.toString().contains(containsStr)) continue;
            gcMbeans.add(objectInstance);
        }
        return gcMbeans;
    }

    private static void registerGcMXBean(MBeanServer mBeanServer) {
        try {
            GcMXBeanImp gcMXBean = new GcMXBeanImp();
            mBeanServer.registerMBean(gcMXBean, GcMXBeanImp.getObjectName());
            Set<ObjectName> gcMbeans = JmxUtils.getGarbageCollectionMbeans(mBeanServer);
            for (ObjectName name : gcMbeans) {
                mBeanServer.addNotificationListener(name, GcMXBeanImp.getObjectName(), null, null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void unregisterGcMXBean(MBeanServer mBeanServer) {
        try {
            Set<ObjectName> gcMbeans = JmxUtils.getGarbageCollectionMbeans(mBeanServer);
            for (ObjectName name : gcMbeans) {
                mBeanServer.removeNotificationListener(name, GcMXBeanImp.getObjectName());
            }
            JmxUtils.unregisterAllMXBeans(mBeanServer);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void unregisterAllMXBeans(MBeanServer mBeanServer) throws MBeanRegistrationException, InstanceNotFoundException {
        Set<ObjectName> gcMbeans = JmxUtils.queryMBeans(mBeanServer, "Jamon.Gc.");
        for (ObjectName name : gcMbeans) {
            mBeanServer.unregisterMBean(name);
        }
    }
}

