/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.jmx;

import com.jamonapi.jmx.JmxUtils;
import com.jamonapi.jmx.MonitorMXBean;
import java.util.Date;

public class MonitorMXBeanImp
implements MonitorMXBean {
    protected final String label;
    protected final String units;
    protected final String name;
    private static final String LASTVALUE = "lastvalue";
    private static final String MAX = "max";
    private static final String MIN = "min";
    private static final String MAXACTIVE = "maxactive";
    private static final String TOTAL = "total";
    private static final String AVG = "avg";
    private static final String HITS = "hits";
    private static final String STDDEV = "stddev";
    private static final String FIRSTACCESS = "firstaccess";
    private static final String LASTACCESS = "lastaccess";
    private static final String ACTIVE = "active";
    private static final String AVGACTIVE = "avgactive";

    public MonitorMXBeanImp(String label, String units) {
        this(label, units, label);
    }

    public MonitorMXBeanImp(String label, String units, String name) {
        this.label = label;
        this.units = units;
        this.name = name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getTotal() {
        return this.getDouble(TOTAL);
    }

    @Override
    public double getAvg() {
        return this.getDouble(AVG);
    }

    @Override
    public double getMin() {
        return this.getDouble(MIN);
    }

    @Override
    public double getMax() {
        return this.getDouble(MAX);
    }

    @Override
    public double getHits() {
        return this.getDouble(HITS);
    }

    @Override
    public double getStdDev() {
        return this.getDouble(STDDEV);
    }

    @Override
    public Date getFirstAccess() {
        return this.getDate(FIRSTACCESS);
    }

    @Override
    public Date getLastAccess() {
        return this.getDate(LASTACCESS);
    }

    @Override
    public double getLastValue() {
        return this.getDouble(LASTVALUE);
    }

    @Override
    public double getActive() {
        return this.getDouble(ACTIVE);
    }

    @Override
    public double getMaxActive() {
        return this.getDouble(MAXACTIVE);
    }

    @Override
    public double getAvgActive() {
        return this.getDouble(AVGACTIVE);
    }

    private double getDouble(String value) {
        return JmxUtils.getDouble(this.label, this.units, value);
    }

    private Date getDate(String value) {
        return JmxUtils.getDate(this.label, this.units, value);
    }
}

