/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.jmx;

import com.jamonapi.JAMonBufferListener;
import com.jamonapi.JAMonListener;
import com.jamonapi.MonitorFactory;
import com.jamonapi.jmx.ExceptionMXBean;
import com.jamonapi.jmx.JmxUtils;
import java.util.Date;
import javax.management.ObjectName;

public class ExceptionMXBeanImp
implements ExceptionMXBean {
    private static final int STACKTRACE_INDEX = 1;

    public static ObjectName getObjectName() {
        return JmxUtils.getObjectName(ExceptionMXBean.class.getPackage().getName() + ":type=current,name=Exceptions");
    }

    @Override
    public String getMostRecentException() {
        if (!MonitorFactory.exists("com.jamonapi.Exceptions", "Exception")) {
            return "No exceptions have been thrown";
        }
        if (!MonitorFactory.getMonitor("com.jamonapi.Exceptions", "Exception").hasListener("value", "FIFOBuffer")) {
            return "Exception Stacktrace tracking is not enabled.";
        }
        JAMonListener listener = MonitorFactory.getMonitor("com.jamonapi.Exceptions", "Exception").getListenerType("value").getListener("FIFOBuffer");
        if (!(listener instanceof JAMonBufferListener) || ((JAMonBufferListener)listener).isEmpty()) {
            return "There are no stacktraces";
        }
        return ExceptionMXBeanImp.getMostRecentStacktrace((JAMonBufferListener)listener);
    }

    @Override
    public long getExceptionCount() {
        return JmxUtils.getCount("com.jamonapi.Exceptions", "Exception");
    }

    @Override
    public Date getWhen() {
        return JmxUtils.getDate("com.jamonapi.Exceptions", "Exception", "lastaccess");
    }

    private static String getMostRecentStacktrace(JAMonBufferListener listener) {
        Object[][] stackTraces = listener.getDetailData().getData();
        int mostRecent = stackTraces.length - 1;
        return stackTraces[mostRecent][1].toString();
    }
}

