/*
 * Decompiled with CFR 0.152.
 */
package com.janeluo.easypdf;

import com.alibaba.fastjson.JSONObject;
import com.janeluo.easypdf.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableRow;

public class DocReader {
    private URL xslUrl = null;
    private boolean autoTitle = false;
    private boolean ignoreBlankPara = false;
    private Map<String, Object> jsonObject;
    private Map<String, String> jsonData;

    public void setXSLUrl(URL url) {
        this.xslUrl = url;
    }

    public void setAutoTitle(boolean autoTitle) {
        this.autoTitle = autoTitle;
    }

    public void ignoreBlankPara(boolean ignore) {
        this.ignoreBlankPara = ignore;
    }

    private int getTitleIndex(Range range) {
        int index = 0;
        int maxFontSize = 0;
        boolean center = false;
        int nParas = Math.min(3, range.numParagraphs());
        for (int i = 0; i < nParas; ++i) {
            Paragraph para = range.getParagraph(i);
            int fontSize = 0;
            for (int j = 0; j < para.numCharacterRuns(); ++j) {
                CharacterRun run = para.getCharacterRun(j);
                fontSize = Math.max(fontSize, run.getFontSize());
            }
            if (fontSize > maxFontSize) {
                index = i;
                maxFontSize = fontSize;
                continue;
            }
            if (fontSize != maxFontSize || center || para.getJustification() != 1) continue;
            index = i;
            center = true;
        }
        return index;
    }

    private void appendParaAttrs(StringBuilder builder, Paragraph para) {
        switch (para.getJustification()) {
            case 1: {
                builder.append(" align=\"center\"");
                break;
            }
            case 2: {
                builder.append(" align=\"right\"");
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private void appendRunAttrs(StringBuilder builder, CharacterRun run, boolean isSpan) {
        StringBuilder style = new StringBuilder();
        if (isSpan) {
            if (run.isBold()) {
                style.append("bold");
            }
            if (run.isItalic()) {
                if (style.length() > 0) {
                    style.append(",");
                }
                style.append("italic");
            }
            if (run.getUnderlineCode() == 1) {
                if (style.length() > 0) {
                    style.append(",");
                }
                style.append("underline");
            }
            if (style.length() > 0) {
                builder.append(" font-style=\"").append((CharSequence)style).append("\"");
            }
        }
        builder.append(" font-size=\"");
        builder.append(run.getFontSize() / 2);
        builder.append("\"");
    }

    private String textEscape(String text) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String escape = Util.escapeXmlChars(text.charAt(i));
            if (escape != null) {
                builder.append(escape);
                continue;
            }
            builder.append(text.charAt(i));
        }
        return builder.toString();
    }

    private void readCharacterRuns(Paragraph para, int paraIndex, StringBuilder builder, boolean isTitle) {
        StringBuilder allText = null;
        if (isTitle && this.jsonObject != null) {
            allText = new StringBuilder();
        }
        for (int j = 0; j < para.numCharacterRuns(); ++j) {
            String vid;
            CharacterRun run = para.getCharacterRun(j);
            String text = run.text().replaceAll("[\u0000-\u001f]", "");
            System.out.println("run text: " + text + " >i=" + paraIndex);
            if (run.isSpecialCharacter() || text.matches(" HYPERLINK .+") || text.matches("HYPERLINK .+") || text.matches(" PAGEREF .+") || text.matches(" TOC .+")) continue;
            if (text.matches("^[\\s\u3000]+$")) {
                if (run.getUnderlineCode() == 1) {
                    vid = "vid_" + paraIndex + "_" + j;
                    builder.append("    <value id=\"");
                    builder.append(vid);
                    builder.append("\" minlen=\"");
                    builder.append(text.length());
                    builder.append("\"");
                    this.appendRunAttrs(builder, run, false);
                    builder.append(" />\n");
                    if (this.jsonData == null) continue;
                    this.jsonData.put(vid, "");
                    continue;
                }
                builder.append("    <hspace");
                builder.append(" size=\"");
                builder.append(text.length());
                builder.append("\"");
                this.appendRunAttrs(builder, run, false);
                builder.append(" />\n");
                continue;
            }
            if (text.matches("^_+$")) {
                vid = "vid_" + paraIndex + "_" + j;
                builder.append("    <value id=\"");
                builder.append(vid);
                builder.append("\" minlen=\"");
                builder.append(text.length());
                builder.append("\"");
                this.appendRunAttrs(builder, run, false);
                builder.append(" />\n");
                if (this.jsonData == null) continue;
                this.jsonData.put(vid, "");
                continue;
            }
            if (text.length() <= 0) continue;
            builder.append("    <span");
            this.appendRunAttrs(builder, run, true);
            builder.append(">");
            builder.append(this.textEscape(text));
            builder.append("</span>\n");
            if (allText == null) continue;
            allText.append(text);
        }
        if (isTitle && this.jsonObject != null) {
            this.jsonObject.put("title", allText != null ? allText.toString() : "");
        }
    }

    public void read(InputStream docStream, OutputStream xmlStream, OutputStream jsonStream) throws IOException {
        if (docStream == null || xmlStream == null) {
            System.err.println("Invalid argument");
            return;
        }
        if (jsonStream != null) {
            this.jsonObject = new HashMap<String, Object>();
            this.jsonData = new HashMap<String, String>();
        }
        HWPFDocument document = new HWPFDocument(docStream);
        Range range = document.getRange();
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        if (this.xslUrl != null) {
            builder.append("<?xml-stylesheet type=\"text/xsl\" href=\"").append(this.xslUrl.getPath()).append("\"?>\n");
        }
        builder.append("\n<!-- Automatic generated by TextPDF DocReader -->\n");
        builder.append("\n<textpdf>\n");
        xmlStream.write(builder.toString().getBytes(StandardCharsets.UTF_8));
        builder.setLength(0);
        int titleIndex = 0;
        if (this.autoTitle) {
            titleIndex = this.getTitleIndex(range);
        }
        Table table = null;
        for (int i = 0; i < range.numParagraphs(); ++i) {
            Paragraph para = range.getParagraph(i);
            boolean isTitle = false;
            if (para.pageBreakBefore()) {
                builder.append("  <pagebreak />\n");
            }
            if (para.isInTable()) {
                if (table == null) {
                    table = range.getTable(para);
                    int maxCells = 0;
                    for (int m = 0; m < table.numRows(); ++m) {
                        TableRow row = table.getRow(m);
                        maxCells = Math.max(maxCells, row.numCells());
                    }
                    StringBuilder columns = new StringBuilder();
                    columns.append("1");
                    for (int n = 1; n <= maxCells; ++n) {
                        if (n == maxCells) {
                            columns.append(",0");
                            continue;
                        }
                        columns.append(",1");
                    }
                    builder.append("  <table columns=\"").append((CharSequence)columns).append("\">\n");
                }
                String text = para.text().replaceAll("[\u0000-\u001f]", "");
                builder.append("    <cell>");
                builder.append(this.textEscape(text));
                builder.append("</cell>\n");
                continue;
            }
            if (table != null) {
                builder.append("  </table>\n");
                table = null;
            }
            if (this.ignoreBlankPara && para.numCharacterRuns() == 0) continue;
            if (this.autoTitle && i == titleIndex) {
                builder.append("  <title");
                isTitle = true;
            } else {
                builder.append("  <para");
            }
            this.appendParaAttrs(builder, para);
            builder.append(">\n");
            this.readCharacterRuns(para, i, builder, isTitle);
            if (this.autoTitle && i == titleIndex) {
                builder.append("  </title>\n");
            } else {
                builder.append("  </para>\n");
            }
            xmlStream.write(builder.toString().getBytes(StandardCharsets.UTF_8));
            builder.setLength(0);
        }
        xmlStream.write("</textpdf>\n".getBytes());
        if (jsonStream != null) {
            this.jsonObject.put("data", this.jsonData);
            String jsonString = JSONObject.toJSONString(this.jsonObject);
            jsonStream.write(jsonString.getBytes(StandardCharsets.UTF_8));
        }
    }
}

