/*
 * Decompiled with CFR 0.152.
 */
package com.janeluo.easypdf;

import com.alibaba.fastjson.JSONObject;
import com.janeluo.easypdf.TextChunk;
import com.janeluo.easypdf.TextDoc;
import com.janeluo.easypdf.TextTable;
import com.janeluo.easypdf.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;

public class HTMLDoc
extends TextDoc {
    public static final int TYPE_INPUT = 1;
    public static final int TYPE_COMBO = 2;
    private boolean isOpen = false;
    private JSONObject jsonObject;
    private List<String> cssPaths;
    private List<String> jsPaths;
    private String declare = null;
    private String extra = null;
    private int type = 1;
    private String htmlOpen = "<!DOCTYPE html>\n<html>\n  <head>\n    <title>__TITLE__</title>\n    <meta name=\"author\" content=\"Lucky Byte, Inc.\"/>\n    <meta name=\"generator\" content=\"TextPDF\" />\n    <meta name=\"description\" content=\"TextPDF HTML Editor\" />\n    <meta name=\"keywords\" content=\"TextPDF,PDF,Template\" />\n    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=__ENCODING__\">\n    __CSS_URL__\n    __JS_URL__\n  </head>\n  <body>\n";
    private final String htmlClose = "  </body>\n</html>\n";
    private final Map<String, String> block_labels = new HashMap<String, String>(){
        {
            this.put("title", "h1");
            this.put("chapter", "h2");
            this.put("section", "h3");
            this.put("para", "p");
        }
    };

    public HTMLDoc(OutputStream outputStream) {
        super(outputStream);
    }

    public void setJSONObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public void setLinkPaths(List<String> css_paths, List<String> js_paths) {
        this.cssPaths = css_paths;
        this.jsPaths = js_paths;
    }

    public void setDeclare(String declare) {
        this.declare = declare;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public void setType(int type) {
        this.type = type;
    }

    private boolean writeStream(String string) {
        try {
            this.outputStream.write(string.getBytes(this.encoding));
            return true;
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Unsupported encoding.");
            return false;
        }
        catch (IOException e) {
            System.err.println("Write to html stream failed.");
            return false;
        }
    }

    private void substituteDeclare() {
        if (this.declare != null) {
            this.htmlOpen = this.htmlOpen.replace("<!DOCTYPE html>", this.declare);
        }
    }

    private void substituteTitle() {
        Object value;
        if (this.jsonObject != null && this.jsonObject.containsKey((Object)"title") && (value = this.jsonObject.get((Object)"title")) instanceof String) {
            this.htmlOpen = this.htmlOpen.replace("__TITLE__", Util.escapeHtmlString((String)value));
        }
        this.htmlOpen = this.htmlOpen.replace("__TITLE__", "");
    }

    private void substituteCSSLinks() {
        if (this.cssPaths != null) {
            StringBuilder builder = new StringBuilder();
            for (String path : this.cssPaths) {
                builder.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
                builder.append(Util.escapeHtmlString(path));
                builder.append("\"/>\n");
            }
            this.htmlOpen = this.htmlOpen.replace("__CSS_URL__", builder.toString().trim());
        } else {
            this.htmlOpen = this.htmlOpen.replace("__CSS_URL__", "");
        }
    }

    private void substituteJSLinks() {
        if (this.jsPaths != null) {
            StringBuilder builder = new StringBuilder();
            for (String path : this.jsPaths) {
                builder.append("    <script src=\"");
                builder.append(Util.escapeHtmlString(path));
                builder.append("\"></script>\n");
            }
            this.htmlOpen = this.htmlOpen.replace("__JS_URL__", builder.toString().trim());
        } else {
            this.htmlOpen = this.htmlOpen.replace("__JS_URL__", "");
        }
    }

    @Override
    public boolean open() {
        if (this.outputStream == null) {
            return false;
        }
        this.substituteDeclare();
        this.substituteTitle();
        this.htmlOpen = this.htmlOpen.replace("__ENCODING__", this.encoding);
        this.substituteCSSLinks();
        this.substituteJSLinks();
        this.isOpen = true;
        return this.writeStream(this.htmlOpen);
    }

    @Override
    public void close() {
        if (this.isOpen && this.outputStream != null) {
            if (this.extra != null) {
                this.writeStream(this.extra);
            }
            this.writeStream("  </body>\n</html>\n");
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    private String getHtmlLabel(String blockName) {
        return this.block_labels.get(blockName.toLowerCase());
    }

    private Map<String, String> getHtmlAttrs(TextChunk chunk, boolean blockElement) {
        Map<String, String> chunkAttrs = chunk.getAttrs();
        HashMap<String, String> htmlAttrs = new HashMap<String, String>();
        StringBuilder styleString = new StringBuilder();
        for (String key : chunkAttrs.keySet()) {
            if ("font-style".equalsIgnoreCase(key)) {
                String[] styles;
                for (String style : styles = chunkAttrs.get(key).split(",")) {
                    String styleName = style.trim();
                    if ("bold".equalsIgnoreCase(styleName)) {
                        styleString.append("font-weight: bold; ");
                        continue;
                    }
                    if ("italic".equalsIgnoreCase(styleName)) {
                        styleString.append("font-style: italic; ");
                        continue;
                    }
                    if (!"underline".equalsIgnoreCase(styleName)) continue;
                    styleString.append("font-decoration: underline; ");
                }
                continue;
            }
            if (blockElement && "indent".equalsIgnoreCase(key)) {
                styleString.append("text-indent: ").append(chunkAttrs.get(key)).append("px; ");
                continue;
            }
            if (!blockElement || !"align".equalsIgnoreCase(key)) continue;
            styleString.append("text-align: ").append(chunkAttrs.get(key)).append("; ");
        }
        if (styleString.toString().length() > 0) {
            htmlAttrs.put("style", styleString.toString());
        }
        return htmlAttrs;
    }

    private String htmlCharEscape(String contents) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < contents.length(); ++i) {
            char ch = contents.charAt(i);
            if (ch == '\n') {
                builder.append("<br/>");
                continue;
            }
            String escape = Util.escapeHtmlChars(ch);
            if (escape != null) {
                builder.append(escape);
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    private void writeValue(TextChunk chunk) {
        Map<String, String> attrs = chunk.getAttrs();
        String id = attrs.get("id");
        String minlen = attrs.get("minlen");
        switch (this.type) {
            case 1: {
                this.writeStream("<input type=\"text\"");
                if (id != null && id.length() > 0) {
                    this.writeStream(" id=\"" + id + "\" name=\"" + id + "\"");
                }
                if (minlen != null && minlen.length() > 0) {
                    this.writeStream(" size=\"" + minlen + "\"");
                }
                this.writeStream(" />");
                break;
            }
            case 2: {
                this.writeStream("<input type=\"text\"");
                if (minlen != null && minlen.length() > 0) {
                    this.writeStream(" size=\"" + minlen + "\"");
                }
                this.writeStream(" readonly=\"readonly\"");
                this.writeStream(" />");
                this.writeStream("<select");
                if (id != null && id.length() > 0) {
                    this.writeStream(" id=\"" + id + "\" name=\"" + id + "\"");
                }
                this.writeStream(">\n");
                this.writeStream("<option value =\"1\">\u5fc5\u8f93</option>\n");
                this.writeStream("<option value =\"0\">\u53ef\u9009</option>\n");
                this.writeStream("</select>\n");
                break;
            }
        }
    }

    @Override
    public void writeBlock(String blockName, List<TextChunk> chunkList) throws IOException {
        if (this.outputStream == null || chunkList.size() == 0) {
            return;
        }
        String label = this.getHtmlLabel(blockName);
        if (label == null) {
            System.err.println("unable map block name '" + blockName + "'to html label.");
            return;
        }
        for (int i = 0; i < chunkList.size(); ++i) {
            TextChunk chunk = chunkList.get(i);
            if (chunk.isValue()) {
                this.writeValue(chunk);
                continue;
            }
            if (i == 0) {
                this.writeStream("    <" + label + " class=\"" + blockName + "\"");
            } else {
                this.writeStream("<span");
            }
            Map<String, String> htmlAttrs = this.getHtmlAttrs(chunk, i == 0);
            for (String key : htmlAttrs.keySet()) {
                this.writeStream(" " + key + "=\"" + htmlAttrs.get(key) + "\"");
            }
            this.writeStream(">");
            this.writeStream(this.htmlCharEscape(chunk.getContents()));
            if (i <= 0) continue;
            this.writeStream("</span>");
        }
        this.writeStream("</" + label + ">\n");
    }

    @Override
    public void newPage() {
        this.writeStream("    <hr/>\n");
    }

    @Override
    public void addHrule(Attributes attrs) {
        this.writeStream("    <hr/>\n");
    }

    @Override
    public void addImage(Attributes attrs) {
        String value = attrs.getValue("src");
        if (value == null) {
            System.err.println("img missing src attribute.");
            return;
        }
        this.writeStream("<img src=\"" + Util.escapeHtmlString(value) + "\"/>");
    }

    @Override
    public void writeTable(TextTable table) {
        if (!this.isOpen() || table == null) {
            return;
        }
        Map<String, String> attrs = table.getAttrs();
        int[] columns = null;
        String value = attrs.get("columns");
        if (value != null) {
            try {
                int i;
                String[] array = value.split(",");
                columns = new int[array.length];
                int total = 0;
                for (i = 0; i < array.length; ++i) {
                    columns[i] = Integer.parseInt(array[i]);
                    total += columns[i];
                }
                for (i = 0; i < columns.length; ++i) {
                    columns[i] = columns[i] * 100 / total;
                }
            }
            catch (Exception ex) {
                System.err.println("column must has a integer value");
            }
        }
        if (columns == null) {
            return;
        }
        this.writeStream("    <table border=\"2\" width=\"100%\">\n");
        for (int i = 0; i < table.getCells().size(); ++i) {
            int colno = i % columns.length;
            if (colno == 0) {
                if (i > 0) {
                    this.writeStream("      </tr>\n");
                }
                this.writeStream("      <tr>\n");
            }
            if (columns[colno] <= 0) continue;
            TextChunk textChunk = table.getCells().get(i);
            this.writeStream("        <td width=\"" + columns[colno] + "%\">" + textChunk.getContents() + "</td>\n");
        }
        this.writeStream("      </tr>\n");
        this.writeStream("    </table>\n");
    }
}

