/*
 * Decompiled with CFR 0.152.
 */
package com.janeluo.easypdf;

import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.events.Event;
import com.itextpdf.kernel.events.IEventHandler;
import com.itextpdf.kernel.events.PdfDocumentEvent;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfDocumentInfo;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.canvas.draw.ILineDrawer;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.LineSeparator;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.property.VerticalAlignment;
import com.itextpdf.layout.splitting.ISplitCharacters;
import com.janeluo.easypdf.BlockType;
import com.janeluo.easypdf.FontStyle;
import com.janeluo.easypdf.PDFBlockDefault;
import com.janeluo.easypdf.TextChunk;
import com.janeluo.easypdf.TextDoc;
import com.janeluo.easypdf.TextTable;
import com.janeluo.easypdf.draw.CustomLineSeparator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class PDFDoc
extends TextDoc {
    private static final Logger log = LoggerFactory.getLogger(PDFDoc.class);
    public static final int FONT_FAMILY_HEI = 1;
    public static final int FONT_FAMILY_SONG = 2;
    protected InputStream templateInputStream;
    private final Map<String, BlockType> blockTypes = new HashMap<String, BlockType>(){
        {
            this.put("title", BlockType.BLOCK_TITLE);
            this.put("chapter", BlockType.BLOCK_CHAPTER);
            this.put("section", BlockType.BLOCK_SECTION);
            this.put("para", BlockType.BLOCK_PARA);
        }
    };
    private final List<PDFBlockDefault> pdfBlockDefaults;
    private PdfDocument pdfDocument;
    private Document document;
    private final Map<String, Image> images;
    private final ISplitCharacters splitCharacters = (glyphLine, i) -> true;

    public PDFDoc(InputStream templateInputStream, OutputStream outputStream) {
        super(outputStream);
        this.templateInputStream = templateInputStream;
        this.pdfBlockDefaults = new ArrayList<PDFBlockDefault>();
        this.images = new HashMap<String, Image>();
        this.pdfBlockDefaults.add(new PDFBlockDefault(BlockType.BLOCK_TITLE, 1, 18, FontStyle.BOLD, TextAlignment.CENTER, 0.0f, 0.0f, 16.0f));
        this.pdfBlockDefaults.add(new PDFBlockDefault(BlockType.BLOCK_CHAPTER, 2, 16, FontStyle.BOLD, TextAlignment.LEFT, 0.0f, 14.0f, 0.0f));
        this.pdfBlockDefaults.add(new PDFBlockDefault(BlockType.BLOCK_SECTION, 2, 14, FontStyle.BOLD, TextAlignment.LEFT, 0.0f, 12.0f, 0.0f));
        this.pdfBlockDefaults.add(new PDFBlockDefault(BlockType.BLOCK_PARA, 2, 12, FontStyle.NONE, TextAlignment.LEFT, 22.0f, 6.0f, 0.0f));
    }

    private void addMetaInfo() {
        PdfDocumentInfo info = this.pdfDocument.getDocumentInfo();
    }

    @Override
    public boolean open() {
        try {
            PdfWriter writer = new PdfWriter(this.outputStream);
            if (this.templateInputStream != null) {
                PdfDocument srcDoc = new PdfDocument(new PdfReader(this.templateInputStream));
                PdfPage firstPage = srcDoc.getFirstPage();
                PageSize pageSize = new PageSize(firstPage.getPageSize().getWidth(), firstPage.getPageSize().getHeight());
                this.pdfDocument = new PdfDocument(writer);
                this.pdfDocument.setDefaultPageSize(pageSize);
                PdfFormXObject background = firstPage.copyAsFormXObject(this.pdfDocument);
                this.pdfDocument.addEventHandler("EndPdfPage", (IEventHandler)new PaginationEventHandler(background));
            } else {
                this.pdfDocument = new PdfDocument(writer);
            }
            this.document = new Document(this.pdfDocument);
            this.document.setMargins((float)this.pageMarginTop, (float)this.pageMarginRight, (float)this.pageMarginBottom, (float)this.pageMarginLeft);
            writer.setCompressionLevel(9);
            this.addMetaInfo();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void close() {
        this.pdfDocument.close();
    }

    @Override
    public boolean isOpen() {
        if (this.pdfDocument == null) {
            return false;
        }
        return !this.pdfDocument.isClosed();
    }

    @Override
    public void setPageSize(PageSize pageSize) {
        super.setPageSize(pageSize);
        if (this.isOpen()) {
            this.pdfDocument.addNewPage(pageSize);
        }
    }

    @Override
    public void setPageMargin(int left, int right, int top, int bottom) {
        super.setPageMargin(left, right, top, bottom);
        if (this.isOpen()) {
            this.document.setMargins((float)this.pageMarginTop, (float)this.pageMarginRight, (float)this.pageMarginBottom, (float)this.pageMarginLeft);
        }
    }

    public void setBlockDefault(BlockType blockType, int fontFamily, int fontSize, FontStyle fontStyle, TextAlignment alignment, float indent, float lineSpaceBefore, float lineSpaceAfter) {
        for (PDFBlockDefault block : this.pdfBlockDefaults) {
            if (block.blockType != blockType) continue;
            block.fontFamily = fontFamily;
            block.fontSize = fontSize;
            block.fontStyle = fontStyle;
            block.alignment = alignment;
            block.indent = indent;
            block.lineSpaceBefore = lineSpaceBefore;
            block.lineSpaceAfter = lineSpaceAfter;
            break;
        }
    }

    public void setBlockDefaultFontFamily(BlockType blockType, int fontFamily) {
        for (PDFBlockDefault block : this.pdfBlockDefaults) {
            if (block.blockType != blockType) continue;
            block.fontFamily = fontFamily;
            break;
        }
    }

    public void setBlockDefaultFontSize(BlockType blockType, int fontSize) {
        for (PDFBlockDefault block : this.pdfBlockDefaults) {
            if (block.blockType != blockType) continue;
            block.fontSize = fontSize;
            break;
        }
    }

    public void setBlockDefaultFontStyle(BlockType blockType, FontStyle fontStyle) {
        for (PDFBlockDefault block : this.pdfBlockDefaults) {
            if (block.blockType != blockType) continue;
            block.fontStyle = fontStyle;
            break;
        }
    }

    public void setBlockDefaultAlignment(BlockType blockType, TextAlignment alignment) {
        for (PDFBlockDefault block : this.pdfBlockDefaults) {
            if (block.blockType != blockType) continue;
            block.alignment = alignment;
            break;
        }
    }

    public void setBlockDefaultIndent(BlockType blockType, float indent) {
        for (PDFBlockDefault block : this.pdfBlockDefaults) {
            if (block.blockType != blockType) continue;
            block.indent = indent;
            break;
        }
    }

    public void setBlockDefaultLineSpaceBefore(BlockType blockType, float lineSpaceBefore) {
        for (PDFBlockDefault block : this.pdfBlockDefaults) {
            if (block.blockType != blockType) continue;
            block.lineSpaceBefore = lineSpaceBefore;
            break;
        }
    }

    public void setBlockDefaultLineSpaceAfter(BlockType blockType, float lineSpaceAfter) {
        for (PDFBlockDefault block : this.pdfBlockDefaults) {
            if (block.blockType != blockType) continue;
            block.lineSpaceAfter = lineSpaceAfter;
            break;
        }
    }

    private void setChunkFont(TextChunk textChunk, Text chunk, PDFBlockDefault blockDefault) throws IOException {
        Map<String, String> attrs = textChunk.getAttrs();
        int fontFamily = blockDefault.fontFamily;
        int fontSize = blockDefault.fontSize;
        FontStyle fontStyle = blockDefault.fontStyle;
        PdfFont pdfFont = null;
        String value = attrs.get("font-family");
        if (value != null) {
            if ("heiti".equalsIgnoreCase(value) || "hei".equalsIgnoreCase(value)) {
                fontFamily = 1;
            } else if ("songti".equalsIgnoreCase(value) || "song".equalsIgnoreCase(value)) {
                fontFamily = 2;
            } else {
                System.err.println("Font family '" + value + "' unknown!");
            }
        }
        if ((value = attrs.get("font-size")) != null) {
            try {
                fontSize = Integer.parseInt(value);
            }
            catch (Exception ex) {
                System.err.println("Font size '" + value + "' invalid.");
            }
        }
        if ((value = attrs.get("font-style")) != null) {
            String[] styles;
            for (String style : styles = value.split(",")) {
                String label = style.trim();
                if ("bold".equalsIgnoreCase(label)) {
                    chunk.setBold();
                    continue;
                }
                if ("italic".equalsIgnoreCase(label)) {
                    chunk.setItalic();
                    continue;
                }
                if (!"underline".equalsIgnoreCase(label)) continue;
                chunk.setUnderline();
            }
        } else {
            switch (fontStyle) {
                case BOLD: {
                    chunk.setBold();
                    break;
                }
                case ITALIC: {
                    chunk.setItalic();
                    break;
                }
                case UNDERLINE: {
                    chunk.setUnderline();
                    break;
                }
            }
        }
        switch (fontFamily) {
            case 1: {
                pdfFont = PdfFontFactory.createFont((String)"font/SIMHEI.TTF", (String)"Identity-H", (PdfFontFactory.EmbeddingStrategy)PdfFontFactory.EmbeddingStrategy.PREFER_EMBEDDED);
                break;
            }
            case 2: {
                pdfFont = PdfFontFactory.createFont((String)"font/SIMSUN.TTC,0", (String)"Identity-H", (PdfFontFactory.EmbeddingStrategy)PdfFontFactory.EmbeddingStrategy.PREFER_EMBEDDED);
                break;
            }
        }
        chunk.setFontSize((float)fontSize);
        chunk.setFont(pdfFont);
    }

    private Text formatChunk(TextChunk text_chunk, PDFBlockDefault blockDefault) {
        Text chunk = new Text("");
        Map<String, String> attrs = text_chunk.getAttrs();
        String value = attrs.get("super");
        if ("true".equalsIgnoreCase(value)) {
            chunk.setTextRise(6.0f);
            if (!attrs.containsKey("font-size")) {
                attrs.put("font-size", "8");
            }
        }
        if ("true".equalsIgnoreCase(value = attrs.get("sub"))) {
            chunk.setTextRise(-3.0f);
            if (!attrs.containsKey("font-size")) {
                attrs.put("font-size", "8");
            }
        }
        String contents = text_chunk.getContents();
        value = text_chunk.getAttrs().get("minlen");
        if (value != null && value.length() > 0) {
            if (contents.length() == 0) {
                chunk.setUnderline(1.0f, -4.0f);
            }
            try {
                int minlen = Integer.parseInt(value);
                int currlen = 0;
                for (int i = 0; i < contents.length(); ++i) {
                    char ch = contents.charAt(i);
                    if (ch < '\u007f') {
                        ++currlen;
                        continue;
                    }
                    currlen += 2;
                }
                if (currlen < minlen) {
                    StringBuilder builder = new StringBuilder(contents);
                    while (currlen < minlen) {
                        builder.append(' ');
                        ++currlen;
                    }
                    contents = builder.toString();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("minlen need a integer value.");
            }
        }
        chunk.setText(contents);
        try {
            this.setChunkFont(text_chunk, chunk, blockDefault);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return chunk;
    }

    private void formatParagraph(Paragraph para, List<TextChunk> chunkList) {
        TextChunk textChunk = chunkList.get(0);
        if (textChunk != null) {
            String lineHeight;
            Map<String, String> attrs;
            block48: {
                String fixedPosition;
                float left;
                block47: {
                    String relativePosition;
                    float right;
                    String margin;
                    String height;
                    attrs = textChunk.getAttrs();
                    String value = attrs.get("align");
                    if (value != null) {
                        if ("left".equalsIgnoreCase(value)) {
                            para.setTextAlignment(TextAlignment.LEFT);
                        } else if ("center".equalsIgnoreCase(value)) {
                            para.setTextAlignment(TextAlignment.CENTER);
                        } else if ("right".equalsIgnoreCase(value)) {
                            para.setTextAlignment(TextAlignment.RIGHT);
                        } else {
                            System.err.println("Block alignment type '" + value + "' unknown.");
                        }
                    }
                    if ((value = attrs.get("indent")) != null) {
                        try {
                            float indent = Float.parseFloat(value);
                            para.setFirstLineIndent(indent);
                        }
                        catch (Exception ex) {
                            System.err.println("Indent attribute must has a float value");
                        }
                    }
                    if ((value = attrs.get("space-before")) != null) {
                        try {
                            float space = Float.parseFloat(value);
                            para.setMarginTop(space);
                        }
                        catch (Exception ex) {
                            System.err.println("space-before attribute must has a float value");
                        }
                    }
                    if ((value = attrs.get("space-after")) != null) {
                        try {
                            float space = Float.parseFloat(value);
                            para.setMarginBottom(space);
                        }
                        catch (Exception ex) {
                            if (log.isErrorEnabled()) {
                                log.error("space-after attribute must has a float value", (Throwable)ex);
                            }
                            System.err.println("space-after attribute must has a float value");
                        }
                    }
                    if ((height = attrs.get("height")) != null && !"".equals(height)) {
                        para.setHeight(Float.parseFloat(height));
                    }
                    if ((margin = attrs.get("margin")) != null) {
                        String[] split = margin.split(" ");
                        try {
                            float top;
                            if (split.length == 1) {
                                para.setMargin(Float.parseFloat(margin));
                            } else if (split.length == 2) {
                                top = Float.parseFloat(split[0]);
                                float bottom = Float.parseFloat(split[0]);
                                left = Float.parseFloat(split[1]);
                                right = Float.parseFloat(split[1]);
                                para.setMargins(top, right, bottom, left);
                            }
                            if (split.length == 4) {
                                top = Float.parseFloat(split[0]);
                                float right2 = Float.parseFloat(split[1]);
                                float bottom = Float.parseFloat(split[2]);
                                float left2 = Float.parseFloat(split[3]);
                                para.setMargins(top, right2, bottom, left2);
                            }
                        }
                        catch (Exception ex) {
                            if (log.isErrorEnabled()) {
                                log.error("margin attribute must has a float value", (Throwable)ex);
                            }
                            System.err.println("margin attribute must has a float value");
                        }
                    }
                    if ((relativePosition = attrs.get("relative-position")) != null && !"".equals(relativePosition)) {
                        String[] split = relativePosition.split(" ");
                        if (split.length == 4) {
                            try {
                                float left3 = Float.parseFloat(split[0]);
                                float top = Float.parseFloat(split[1]);
                                right = Float.parseFloat(split[2]);
                                float bottom = Float.parseFloat(split[3]);
                                para.setRelativePosition(left3, top, right, bottom);
                            }
                            catch (Exception ex) {
                                if (log.isErrorEnabled()) {
                                    log.error("relative-position attribute must has a float value", (Throwable)ex);
                                    break block47;
                                }
                                System.err.println("relative-position attribute must has a float value");
                            }
                        } else if (log.isErrorEnabled()) {
                            log.error("relative-position attribute must like 'relative-position:\"left top right bottom\"'");
                        } else {
                            System.err.println("relative-position attribute must like 'relative-position:\"left top right bottom\"'");
                        }
                    }
                }
                if ((fixedPosition = attrs.get("fixed-position")) != null && !"".equals(fixedPosition)) {
                    String[] split = fixedPosition.split(" ");
                    if (split.length == 2) {
                        try {
                            left = Float.parseFloat(split[0]);
                            float bottom = Float.parseFloat(split[1]);
                            para.setFixedPosition(left, bottom, UnitValue.createPercentValue((float)100.0f));
                        }
                        catch (Exception ex) {
                            if (log.isErrorEnabled()) {
                                log.error("fixed-position attribute must has a float value", (Throwable)ex);
                                break block48;
                            }
                            System.err.println("fixed-position attribute must has a float value");
                        }
                    } else if (log.isErrorEnabled()) {
                        log.error("fixed-position attribute must like 'fixed-position:\"left bottom\"'");
                    } else {
                        System.err.println("fixed-position attribute must like 'fixed-position:\"left bottom\"'");
                    }
                }
            }
            if (null != (lineHeight = attrs.get("line-height")) && !"".equals(lineHeight)) {
                try {
                    para.setMultipliedLeading(Float.parseFloat(lineHeight));
                }
                catch (NumberFormatException ex) {
                    if (log.isErrorEnabled()) {
                        log.error("line-height attribute must has a float value", (Throwable)ex);
                    }
                    System.err.println("line-height attribute must has a float value");
                }
            }
        }
    }

    private void addParagraph(BlockType blockType, List<TextChunk> chunkList, PDFBlockDefault pdfBlockDefault) {
        Paragraph para = new Paragraph();
        for (TextChunk textChunk : chunkList) {
            Text chunk = this.formatChunk(textChunk, pdfBlockDefault);
            chunk.setSplitCharacters(this.splitCharacters);
            para.add((ILeafElement)chunk);
        }
        para.setMarginTop(pdfBlockDefault.lineSpaceBefore);
        para.setMarginBottom(pdfBlockDefault.lineSpaceAfter);
        para.setTextAlignment(pdfBlockDefault.alignment);
        para.setFirstLineIndent(pdfBlockDefault.indent);
        this.formatParagraph(para, chunkList);
        this.document.add((IBlockElement)para);
    }

    @Override
    public void writeBlock(String blockName, List<TextChunk> chunkList) {
        if (blockName == null || chunkList == null || chunkList.size() == 0) {
            return;
        }
        if (this.pdfDocument == null || this.pdfDocument.isClosed()) {
            System.err.println("Document unopen yet, please open it first.");
            return;
        }
        String lowerBlockName = blockName.toLowerCase();
        if (!this.blockTypes.containsKey(lowerBlockName)) {
            System.err.println("Block type '" + blockName + "' unknown!");
            return;
        }
        BlockType blockType = this.blockTypes.get(lowerBlockName);
        for (PDFBlockDefault pdfBlockDefault : this.pdfBlockDefaults) {
            if (pdfBlockDefault.blockType != blockType) continue;
            this.addParagraph(blockType, chunkList, pdfBlockDefault);
            break;
        }
    }

    @Override
    public void newPage() {
        if (this.pdfDocument == null || this.pdfDocument.isClosed()) {
            System.err.println("Document unopen yet, please open it first.");
            return;
        }
        this.pdfDocument.addNewPage();
    }

    @Override
    public void addHrule(Attributes attrs) {
        try {
            int width = 1;
            int percent = 100;
            String value = attrs.getValue("width");
            if (value != null) {
                try {
                    width = Integer.parseInt(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((value = attrs.getValue("percent")) != null) {
                try {
                    percent = Integer.parseInt(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.document.add(new AreaBreak());
            this.document.add((IBlockElement)new LineSeparator((ILineDrawer)new CustomLineSeparator(width, percent)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void addImage(Attributes attrs) {
        try {
            String src = attrs.getValue("src");
            if (src == null) {
                System.err.println("img missing src attribute.");
                return;
            }
            Image img = this.images.get(src);
            if (img == null) {
                img = new Image(ImageDataFactory.create((String)src));
                this.images.put(src, img);
            }
            this.document.add(img);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Table createTable(Map<String, String> attrs) {
        float width = 100.0f;
        float[] columns = null;
        String value = attrs.get("columns");
        if (value != null) {
            try {
                String[] array = value.split(",");
                columns = new float[array.length];
                for (int i = 0; i < array.length; ++i) {
                    columns[i] = Integer.parseInt(array[i]);
                }
            }
            catch (Exception ex) {
                System.err.println("column must has a integer value");
            }
        }
        Table table = columns == null ? new Table(UnitValue.createPercentArray((int)1)) : new Table(UnitValue.createPercentArray(columns));
        value = attrs.get("width");
        if (value != null) {
            try {
                width = Float.parseFloat(value);
            }
            catch (Exception ex) {
                System.err.println("width must has a float value");
            }
        }
        table.setWidth(UnitValue.createPercentValue((float)width));
        table.setFixedLayout();
        String margin = attrs.get("margin");
        if (margin != null) {
            String[] split = margin.split(" ");
            try {
                float top;
                if (split.length == 1) {
                    table.setMargin(Float.parseFloat(margin));
                } else if (split.length == 2) {
                    top = Float.parseFloat(split[0]);
                    float bottom = Float.parseFloat(split[0]);
                    float left = Float.parseFloat(split[1]);
                    float right = Float.parseFloat(split[1]);
                    table.setMargins(top, right, bottom, left);
                }
                if (split.length == 4) {
                    top = Float.parseFloat(split[0]);
                    float right = Float.parseFloat(split[1]);
                    float bottom = Float.parseFloat(split[2]);
                    float left = Float.parseFloat(split[3]);
                    table.setMargins(top, right, bottom, left);
                }
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error("margin attribute must has a float value", (Throwable)ex);
                }
                System.err.println("margin attribute must has a float value");
            }
        }
        return table;
    }

    private Cell createTableCell(TextChunk textChunk, PDFBlockDefault blockDefault) {
        String border;
        String[] colors;
        String backgroundColor;
        String padding;
        Text chunk = this.formatChunk(textChunk, blockDefault);
        Paragraph phrase = new Paragraph();
        phrase.add((ILeafElement)chunk);
        Map<String, String> attrs = textChunk.getAttrs();
        String value = attrs.get("colspan");
        int colspan = 1;
        if (value != null) {
            try {
                colspan = Integer.parseInt(value);
            }
            catch (Exception ex) {
                System.err.println("colspan must has a integer value");
            }
        }
        Cell cell = new Cell(1, colspan);
        cell.add((IBlockElement)phrase);
        cell.setVerticalAlignment(VerticalAlignment.MIDDLE);
        value = attrs.get("align");
        if (value != null) {
            if ("left".equalsIgnoreCase(value)) {
                cell.setTextAlignment(TextAlignment.LEFT);
            } else if ("center".equalsIgnoreCase(value)) {
                cell.setTextAlignment(TextAlignment.CENTER);
            } else if ("right".equalsIgnoreCase(value)) {
                cell.setTextAlignment(TextAlignment.RIGHT);
            }
        }
        if ((padding = attrs.get("padding")) != null) {
            String[] split = padding.split(" ");
            try {
                float top;
                if (split.length == 1) {
                    cell.setPadding(Float.parseFloat(padding));
                } else if (split.length == 2) {
                    top = Float.parseFloat(split[0]);
                    float bottom = Float.parseFloat(split[0]);
                    float left = Float.parseFloat(split[1]);
                    float right = Float.parseFloat(split[1]);
                    cell.setPaddings(top, right, bottom, left);
                }
                if (split.length == 4) {
                    top = Float.parseFloat(split[0]);
                    float right = Float.parseFloat(split[1]);
                    float bottom = Float.parseFloat(split[2]);
                    float left = Float.parseFloat(split[3]);
                    cell.setPaddings(top, right, bottom, left);
                }
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error("padding attribute must has a float value", (Throwable)ex);
                }
                System.err.println("padding attribute must has a float value");
            }
        }
        if ((backgroundColor = attrs.get("background-color")) != null && (colors = backgroundColor.split(" ")).length == 3) {
            try {
                int r = Integer.parseInt(colors[0]);
                int g = Integer.parseInt(colors[1]);
                int b = Integer.parseInt(colors[2]);
                cell.setBackgroundColor((Color)new DeviceRgb(r, g, b));
            }
            catch (Exception ex) {
                log.error("background-color item must has a float value", (Throwable)ex);
            }
        }
        if (!"".equals(border = attrs.getOrDefault("border", "")) && "no-border".equals(border)) {
            cell.setBorder(Border.NO_BORDER);
        }
        return cell;
    }

    @Override
    public void writeTable(TextTable table) {
        if (!this.isOpen() || table == null) {
            return;
        }
        PDFBlockDefault blockDefault = null;
        for (PDFBlockDefault def : this.pdfBlockDefaults) {
            if (def.blockType != BlockType.BLOCK_PARA) continue;
            blockDefault = def;
            break;
        }
        Table pdfTable = this.createTable(table.getAttrs());
        for (TextChunk textChunk : table.getCells()) {
            pdfTable.addCell(this.createTableCell(textChunk, blockDefault));
        }
        this.document.add((IBlockElement)pdfTable);
    }

    protected class PaginationEventHandler
    implements IEventHandler {
        protected PdfFormXObject background;

        public PaginationEventHandler(PdfFormXObject background) {
            this.background = background;
        }

        public void handleEvent(Event event) {
            PdfDocument pdfDoc = ((PdfDocumentEvent)event).getDocument();
            PdfPage currentPage = ((PdfDocumentEvent)event).getPage();
            PdfCanvas pdfCanvas = new PdfCanvas(currentPage.newContentStreamBefore(), currentPage.getResources(), pdfDoc);
            pdfCanvas.addXObjectAt((PdfXObject)this.background, 0.0f, 0.0f);
        }
    }
}

