/*
 * Decompiled with CFR 0.152.
 */
package com.janeluo.easypdf;

import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.janeluo.easypdf.TextChunk;
import com.janeluo.easypdf.TextTable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.xml.sax.Attributes;

public abstract class TextDoc {
    protected OutputStream outputStream;
    protected Rectangle pageSize = PageSize.A4;
    protected int pageMarginLeft = 50;
    protected int pageMarginRight = 50;
    protected int pageMarginTop = 50;
    protected int pageMarginBottom = 56;
    protected String encoding = "UTF-8";

    public TextDoc(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void setPageSize(PageSize pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageMargin(int left, int right, int top, int bottom) {
        this.pageMarginLeft = left;
        this.pageMarginRight = right;
        this.pageMarginTop = top;
        this.pageMarginBottom = bottom;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public abstract boolean open();

    public abstract void close();

    public abstract boolean isOpen();

    public abstract void writeBlock(String var1, List<TextChunk> var2) throws IOException;

    public abstract void newPage();

    public abstract void addHrule(Attributes var1);

    public abstract void addImage(Attributes var1);

    public abstract void writeTable(TextTable var1) throws IOException;
}

