/*
 * Decompiled with CFR 0.152.
 */
package com.janeluo.easypdf;

import com.janeluo.easypdf.DocReader;
import com.janeluo.easypdf.TextParser;
import com.janeluo.easypdf.Version;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class TextPDF {
    public static void gen(File xmlfile, File jsonfile, File pdffile) throws Exception {
        if (xmlfile == null || jsonfile == null || pdffile == null) {
            throw new IllegalArgumentException();
        }
        TextParser parser = new TextParser(new FileInputStream(xmlfile), new FileInputStream(jsonfile), new FileOutputStream(pdffile));
        parser.genPdf();
    }

    public static void gen(String xmlstr, String jsonstr, File pdffile) throws FileNotFoundException, Exception {
        if (xmlstr == null || jsonstr == null || pdffile == null) {
            throw new IllegalArgumentException();
        }
        byte[] xmlBytes = xmlstr.getBytes(StandardCharsets.UTF_8);
        byte[] jsonBytes = jsonstr.getBytes(StandardCharsets.UTF_8);
        TextParser parser = new TextParser(new ByteArrayInputStream(xmlBytes), new ByteArrayInputStream(jsonBytes), new FileOutputStream(pdffile));
        parser.genPdf();
    }

    public static void main(String[] args) throws IOException {
        File outfile;
        ArrayList<String> args2 = new ArrayList<String>();
        String out_fname = null;
        String out_format = "pdf";
        String out_encoding = null;
        String css_paths = null;
        String js_paths = null;
        boolean print_help = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-o")) {
                if (i >= args.length - 1) {
                    System.err.println("'-o' option require a argument");
                    return;
                }
                out_fname = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-f")) {
                if (i >= args.length - 1) {
                    System.err.println("'-f' option require a argument");
                    return;
                }
                out_format = args[i + 1];
                if (!out_format.equalsIgnoreCase("pdf") && !out_format.equalsIgnoreCase("html")) {
                    System.err.println("'-f' option require 'pdf' or 'html'");
                    return;
                }
                ++i;
                continue;
            }
            if (args[i].equals("-e")) {
                if (i >= args.length - 1) {
                    System.err.println("'-e' option require a argument");
                    return;
                }
                out_encoding = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-css")) {
                if (i >= args.length - 1) {
                    System.err.println("'-css' option require a argument");
                    return;
                }
                css_paths = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-js")) {
                if (i >= args.length - 1) {
                    System.err.println("'-js' option require a argument");
                    return;
                }
                js_paths = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-h")) {
                print_help = true;
                continue;
            }
            if (args[i].equals("-v")) {
                System.out.println("TextPDF version " + Version.VERSION);
                System.out.println("\nCopyright (c) 2015 Lucky Byte, Inc.\n");
                return;
            }
            args2.add(args[i]);
        }
        if (print_help || args2.size() < 1) {
            if (!print_help) {
                System.err.println("Argument missing...");
                System.err.println();
            }
            System.err.println("Usage:");
            System.err.println("  java -jar textpdf.jar [OPTION] <xmlfile|docfile> [jsonfile]");
            System.err.println("\nOptions:");
            System.err.println("  -o filename    : Output file name");
            System.err.println("  -f [pdf|html]  : Output file format");
            System.err.println("  -e encoding    : Output file encoding");
            System.err.println("  -css path1,... : Add CSS link to output file");
            System.err.println("  -js path1,...  : Add JS link to output file");
            System.err.println("  -v             : Print version");
            System.err.println("  -h             : Print this information");
            System.err.println();
            return;
        }
        File xmlfile = new File((String)args2.get(0));
        if (!xmlfile.exists()) {
            System.err.println(xmlfile.getAbsolutePath() + " not found.");
            return;
        }
        File jsonfile = null;
        if (args2.size() > 1 && !(jsonfile = new File((String)args2.get(1))).exists()) {
            System.err.println(jsonfile.getAbsolutePath() + " not found.");
            return;
        }
        if (out_fname == null) {
            out_fname = (String)args2.get(0) + "." + out_format;
        }
        if ((outfile = new File(out_fname)).exists()) {
            System.err.println(outfile.getAbsolutePath() + " already exists.");
            return;
        }
        try {
            if (((String)args2.get(0)).endsWith(".doc")) {
                File tmpfile = File.createTempFile("textpdf-", ".xml");
                DocReader reader = new DocReader();
                reader.setAutoTitle(true);
                reader.ignoreBlankPara(true);
                FileInputStream doc_stream = new FileInputStream(xmlfile);
                FileOutputStream xml_stream = new FileOutputStream(tmpfile);
                reader.read(doc_stream, xml_stream, null);
                xmlfile = tmpfile;
            }
            FileInputStream json_stream = null;
            if (jsonfile != null) {
                json_stream = new FileInputStream(jsonfile);
            }
            TextParser parser = new TextParser(new FileInputStream(xmlfile), json_stream, new FileOutputStream(outfile));
            if (out_encoding != null) {
                parser.setOutputEncoding(out_encoding);
            }
            if (css_paths != null) {
                parser.setCssLinks(css_paths.split(","));
            }
            if (js_paths != null) {
                parser.setJsLinks(js_paths.split(","));
            }
            if ("pdf".equalsIgnoreCase(out_format)) {
                parser.genPdf();
            } else {
                parser.genHtml();
            }
            if (((String)args2.get(0)).endsWith(".doc")) {
                xmlfile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

