/*
 * Decompiled with CFR 0.152.
 */
package com.janeluo.easypdf;

import com.janeluo.easypdf.TextParserDocHandler;
import com.janeluo.easypdf.enums.DocType;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class TextParser {
    protected InputStream templateStream;
    protected InputStream xmlStream;
    protected InputStream jsonStream;
    protected OutputStream outStream;
    protected List<String> cssPaths;
    protected List<String> jsPaths;
    protected String outputEncoding = null;
    protected String htmlDeclare = null;
    protected String htmlExtra = null;
    protected int typeInput = 1;

    public TextParser(InputStream xmlStream, InputStream inputStream, OutputStream outputStream) {
        this.xmlStream = xmlStream;
        this.jsonStream = inputStream;
        this.outStream = outputStream;
        this.cssPaths = new ArrayList<String>();
        this.jsPaths = new ArrayList<String>();
    }

    public void setCssLinks(List<String> cssPaths) {
        this.cssPaths.addAll(cssPaths);
    }

    public void setCssLinks(String[] cssPaths) {
        if (cssPaths != null) {
            Collections.addAll(this.cssPaths, cssPaths);
        }
    }

    public void setJsLinks(List<String> jsPaths) {
        this.jsPaths.addAll(jsPaths);
    }

    public void setJsLinks(String[] jsLinks) {
        if (jsLinks != null) {
            Collections.addAll(this.jsPaths, jsLinks);
        }
    }

    public void gen(DocType docType) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        SAXParser parser = factory.newSAXParser();
        parser.parse(this.xmlStream, (DefaultHandler)new TextParserDocHandler(this, docType));
    }

    public void genPdf() throws Exception {
        this.gen(DocType.DPF);
    }

    public void genHtml() throws Exception {
        this.gen(DocType.HTML);
    }

    public InputStream getTemplateStream() {
        return this.templateStream;
    }

    public InputStream getXmlStream() {
        return this.xmlStream;
    }

    public InputStream getJsonStream() {
        return this.jsonStream;
    }

    public OutputStream getOutStream() {
        return this.outStream;
    }

    public List<String> getCssPaths() {
        return this.cssPaths;
    }

    public List<String> getJsPaths() {
        return this.jsPaths;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public String getHtmlDeclare() {
        return this.htmlDeclare;
    }

    public String getHtmlExtra() {
        return this.htmlExtra;
    }

    public int getTypeInput() {
        return this.typeInput;
    }

    public void setTemplateStream(InputStream templateStream) {
        this.templateStream = templateStream;
    }

    public void setXmlStream(InputStream xmlStream) {
        this.xmlStream = xmlStream;
    }

    public void setJsonStream(InputStream jsonStream) {
        this.jsonStream = jsonStream;
    }

    public void setOutStream(OutputStream outStream) {
        this.outStream = outStream;
    }

    public void setCssPaths(List<String> cssPaths) {
        this.cssPaths = cssPaths;
    }

    public void setJsPaths(List<String> jsPaths) {
        this.jsPaths = jsPaths;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setHtmlDeclare(String htmlDeclare) {
        this.htmlDeclare = htmlDeclare;
    }

    public void setHtmlExtra(String htmlExtra) {
        this.htmlExtra = htmlExtra;
    }

    public void setTypeInput(int typeInput) {
        this.typeInput = typeInput;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextParser)) {
            return false;
        }
        TextParser other = (TextParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InputStream this$templateStream = this.getTemplateStream();
        InputStream other$templateStream = other.getTemplateStream();
        if (this$templateStream == null ? other$templateStream != null : !this$templateStream.equals(other$templateStream)) {
            return false;
        }
        InputStream this$xmlStream = this.getXmlStream();
        InputStream other$xmlStream = other.getXmlStream();
        if (this$xmlStream == null ? other$xmlStream != null : !this$xmlStream.equals(other$xmlStream)) {
            return false;
        }
        InputStream this$jsonStream = this.getJsonStream();
        InputStream other$jsonStream = other.getJsonStream();
        if (this$jsonStream == null ? other$jsonStream != null : !this$jsonStream.equals(other$jsonStream)) {
            return false;
        }
        OutputStream this$outStream = this.getOutStream();
        OutputStream other$outStream = other.getOutStream();
        if (this$outStream == null ? other$outStream != null : !this$outStream.equals(other$outStream)) {
            return false;
        }
        List<String> this$cssPaths = this.getCssPaths();
        List<String> other$cssPaths = other.getCssPaths();
        if (this$cssPaths == null ? other$cssPaths != null : !((Object)this$cssPaths).equals(other$cssPaths)) {
            return false;
        }
        List<String> this$jsPaths = this.getJsPaths();
        List<String> other$jsPaths = other.getJsPaths();
        if (this$jsPaths == null ? other$jsPaths != null : !((Object)this$jsPaths).equals(other$jsPaths)) {
            return false;
        }
        String this$outputEncoding = this.getOutputEncoding();
        String other$outputEncoding = other.getOutputEncoding();
        if (this$outputEncoding == null ? other$outputEncoding != null : !this$outputEncoding.equals(other$outputEncoding)) {
            return false;
        }
        String this$htmlDeclare = this.getHtmlDeclare();
        String other$htmlDeclare = other.getHtmlDeclare();
        if (this$htmlDeclare == null ? other$htmlDeclare != null : !this$htmlDeclare.equals(other$htmlDeclare)) {
            return false;
        }
        String this$htmlExtra = this.getHtmlExtra();
        String other$htmlExtra = other.getHtmlExtra();
        if (this$htmlExtra == null ? other$htmlExtra != null : !this$htmlExtra.equals(other$htmlExtra)) {
            return false;
        }
        return this.getTypeInput() == other.getTypeInput();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InputStream $templateStream = this.getTemplateStream();
        result = result * 59 + ($templateStream == null ? 43 : $templateStream.hashCode());
        InputStream $xmlStream = this.getXmlStream();
        result = result * 59 + ($xmlStream == null ? 43 : $xmlStream.hashCode());
        InputStream $jsonStream = this.getJsonStream();
        result = result * 59 + ($jsonStream == null ? 43 : $jsonStream.hashCode());
        OutputStream $outStream = this.getOutStream();
        result = result * 59 + ($outStream == null ? 43 : $outStream.hashCode());
        List<String> $cssPaths = this.getCssPaths();
        result = result * 59 + ($cssPaths == null ? 43 : ((Object)$cssPaths).hashCode());
        List<String> $jsPaths = this.getJsPaths();
        result = result * 59 + ($jsPaths == null ? 43 : ((Object)$jsPaths).hashCode());
        String $outputEncoding = this.getOutputEncoding();
        result = result * 59 + ($outputEncoding == null ? 43 : $outputEncoding.hashCode());
        String $htmlDeclare = this.getHtmlDeclare();
        result = result * 59 + ($htmlDeclare == null ? 43 : $htmlDeclare.hashCode());
        String $htmlExtra = this.getHtmlExtra();
        result = result * 59 + ($htmlExtra == null ? 43 : $htmlExtra.hashCode());
        result = result * 59 + this.getTypeInput();
        return result;
    }

    public String toString() {
        return "TextParser(templateStream=" + this.getTemplateStream() + ", xmlStream=" + this.getXmlStream() + ", jsonStream=" + this.getJsonStream() + ", outStream=" + this.getOutStream() + ", cssPaths=" + this.getCssPaths() + ", jsPaths=" + this.getJsPaths() + ", outputEncoding=" + this.getOutputEncoding() + ", htmlDeclare=" + this.getHtmlDeclare() + ", htmlExtra=" + this.getHtmlExtra() + ", typeInput=" + this.getTypeInput() + ")";
    }
}

