/*
 * Decompiled with CFR 0.152.
 */
package com.janeluo.easypdf;

import com.alibaba.fastjson.JSONObject;
import com.itextpdf.kernel.geom.PageSize;
import com.janeluo.easypdf.HTMLDoc;
import com.janeluo.easypdf.PDFDoc;
import com.janeluo.easypdf.TextChunk;
import com.janeluo.easypdf.TextDoc;
import com.janeluo.easypdf.TextParser;
import com.janeluo.easypdf.TextTable;
import com.janeluo.easypdf.enums.DocType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TextParserDocHandler
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(TextParserDocHandler.class);
    public static final String[] BLOCK_ELEMENTS = new String[]{"title", "chapter", "section", "para", "pagebreak", "table"};
    private final Object[][] pageSizeMap = new Object[][]{{"a0", PageSize.A0}, {"a1", PageSize.A1}, {"a2", PageSize.A2}, {"a3", PageSize.A3}, {"a4", PageSize.A4}, {"a5", PageSize.A5}, {"a6", PageSize.A6}, {"a7", PageSize.A7}, {"a8", PageSize.A8}, {"a9", PageSize.A9}, {"a10", PageSize.A10}, {"b0", PageSize.B0}, {"b1", PageSize.B1}, {"b2", PageSize.B2}, {"b3", PageSize.B3}, {"b4", PageSize.B4}, {"b5", PageSize.B5}, {"b6", PageSize.B6}, {"b7", PageSize.B7}, {"b8", PageSize.B8}, {"b9", PageSize.B9}, {"b10", PageSize.B10}};
    private final TextParser parser;
    private final TextDoc textDoc;
    private final List<TextChunk> chunkList = new ArrayList<TextChunk>();
    private final Stack<TextChunk> chunkStack = new Stack();
    private final StringBuilder contentsBuilder = new StringBuilder();
    private JSONObject jsonData;
    private TextTable table = null;

    public TextParserDocHandler(TextParser parser, DocType docType) throws IOException {
        this.parser = parser;
        switch (docType) {
            case DPF: {
                this.textDoc = new PDFDoc(parser.templateStream, parser.outStream);
                break;
            }
            case HTML: {
                this.textDoc = new HTMLDoc(parser.outStream);
                HTMLDoc textDoc = (HTMLDoc)this.textDoc;
                textDoc.setLinkPaths(parser.cssPaths, parser.jsPaths);
                if (parser.htmlDeclare != null) {
                    textDoc.setDeclare(parser.htmlDeclare);
                }
                if (parser.htmlExtra == null) break;
                textDoc.setExtra(parser.htmlExtra);
                break;
            }
            default: {
                log.error("Document type unsupported.");
                throw new IOException("Document type unsupported.");
            }
        }
        if (parser.outputEncoding != null) {
            this.textDoc.setEncoding(parser.outputEncoding);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("\u89e3\u6790\u6587\u4ef6\u5f00\u59cb");
        }
        try {
            if (this.parser.jsonStream != null) {
                String jsonStr = IOUtils.toString((InputStream)this.parser.jsonStream, (Charset)StandardCharsets.UTF_8);
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                if (this.textDoc instanceof PDFDoc) {
                    if (!jsonObject.containsKey((Object)"data")) {
                        if (log.isErrorEnabled()) {
                            log.error("JSON source missing 'data' key, please check!");
                        } else {
                            System.err.println("JSON source missing 'data' key, please check!");
                        }
                    } else {
                        Object value = jsonObject.get((Object)"data");
                        if (!(value instanceof JSONObject)) {
                            if (log.isErrorEnabled()) {
                                log.error("JSON 'data' must be a object.");
                            } else {
                                System.err.println("JSON 'data' must be a object.");
                            }
                        } else {
                            this.jsonData = (JSONObject)value;
                        }
                    }
                } else if (this.textDoc instanceof HTMLDoc) {
                    ((HTMLDoc)this.textDoc).setJSONObject(jsonObject);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SAXException("Failed to parse JSON stream");
        }
    }

    @Override
    public void endDocument() {
    }

    private void setupPage(Attributes attrs) {
        String value = attrs.getValue("size");
        if (value != null) {
            for (Object[] item : this.pageSizeMap) {
                if (!value.equalsIgnoreCase((String)item[0])) continue;
                this.textDoc.setPageSize((PageSize)item[1]);
                break;
            }
        }
        if ((value = attrs.getValue("margin")) != null) {
            String[] array = value.split(",");
            if (array.length < 4) {
                if (log.isErrorEnabled()) {
                    log.error("Page margin format error.");
                } else {
                    System.err.println("Page margin format error.");
                }
            } else {
                try {
                    this.textDoc.setPageMargin(Integer.parseInt(array[0].trim()), Integer.parseInt(array[1].trim()), Integer.parseInt(array[2].trim()), Integer.parseInt(array[3].trim()));
                }
                catch (Exception ex) {
                    if (log.isErrorEnabled()) {
                        log.error("Page margin format error.");
                    }
                    System.err.println("Page margin format error.");
                }
            }
        }
    }

    @Override
    public void startElement(String namespaceUri, String localName, String qName, Attributes attrs) throws SAXException {
        TextChunk chunk;
        if (log.isTraceEnabled()) {
            log.trace(">>>>>> start qName:[{}]", (Object)qName);
        }
        TextChunk prevChunk = null;
        if ("easy-pdf".equalsIgnoreCase(qName)) {
            if (this.textDoc.isOpen()) {
                throw new SAXException("'textpdf' must be root element.");
            }
            if (!this.textDoc.open()) {
                throw new SAXException("Open document failed.");
            }
            return;
        }
        if (!this.textDoc.isOpen()) {
            throw new SAXException("Document unopen yet. check your xml root element is 'textpdf'");
        }
        for (String label : BLOCK_ELEMENTS) {
            if (!label.equalsIgnoreCase(qName)) continue;
            this.chunkList.clear();
            break;
        }
        if ("table".equalsIgnoreCase(qName)) {
            this.table = new TextTable();
            this.table.addAttrs(attrs);
            return;
        }
        if (this.table != null) {
            if (!"cell".equalsIgnoreCase(qName)) {
                throw new SAXException(qName + " is not child of table");
            }
            chunk = new TextChunk();
            chunk.addAttrs(attrs);
            this.table.addCell(chunk);
            this.contentsBuilder.setLength(0);
            return;
        }
        if ("page".equalsIgnoreCase(qName)) {
            this.setupPage(attrs);
            this.textDoc.newPage();
            return;
        }
        if ("hrule".equalsIgnoreCase(qName)) {
            this.textDoc.addHrule(attrs);
            return;
        }
        if ("img".equalsIgnoreCase(qName)) {
            this.textDoc.addImage(attrs);
            return;
        }
        try {
            prevChunk = this.chunkStack.peek();
            String contents = this.contentsBuilder.toString();
            if (contents.length() > 0) {
                prevChunk.setContents(contents);
                this.contentsBuilder.setLength(0);
                this.chunkList.add(prevChunk.clone());
            }
        }
        catch (EmptyStackException contents) {
            // empty catch block
        }
        chunk = new TextChunk();
        if (prevChunk != null) {
            chunk.addAttrs(prevChunk.getAttrs());
        }
        chunk.addAttrs(attrs);
        if ("value".equalsIgnoreCase(qName)) {
            chunk.setIsValue(true);
            String id = attrs.getValue("id");
            if (id == null) {
                if (log.isErrorEnabled()) {
                    log.error("Value element missing 'id' attribute.");
                } else {
                    System.err.println("Value element missing 'id' attribute.");
                }
            } else if (this.textDoc instanceof PDFDoc && this.jsonData != null) {
                if (!this.jsonData.containsKey((Object)id)) {
                    if (log.isErrorEnabled()) {
                        log.error("JSON data key '" + id + "' not found!");
                    } else {
                        System.err.println("JSON data key '" + id + "' not found!");
                    }
                } else {
                    Object value = this.jsonData.get((Object)id);
                    if (!(value instanceof String)) {
                        if (log.isErrorEnabled()) {
                            log.error("JSON  data key '" + id + "' must has a string value.");
                        } else {
                            System.err.println("JSON  data key '" + id + "' must has a string value.");
                        }
                    } else {
                        this.contentsBuilder.append(value);
                        if (attrs.getValue("font-style") == null) {
                            chunk.addAttr("font-style", "bold,underline");
                        }
                    }
                }
            }
        } else if ("hspace".equalsIgnoreCase(qName)) {
            String value = attrs.getValue("size");
            if (value == null || value.length() == 0) {
                if (log.isErrorEnabled()) {
                    log.error("hspace need a size attribute.");
                } else {
                    System.err.println("hspace need a size attribute.");
                }
            } else {
                try {
                    int size = Integer.parseInt(value);
                    for (int i = 0; i < size; ++i) {
                        this.contentsBuilder.append(' ');
                    }
                }
                catch (Exception ex) {
                    if (log.isErrorEnabled()) {
                        log.error("size attribute need a integer value", (Throwable)ex);
                    }
                    System.err.println("size attribute need a integer value");
                }
            }
        }
        this.chunkStack.push(chunk);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String contents = new String(ch, start, length);
        this.contentsBuilder.append(contents.replaceAll("\\s*\n+\\s*", "").trim());
    }

    @Override
    public void endElement(String namespaceUri, String localName, String qName) throws SAXException {
        TextChunk chunk;
        if (log.isTraceEnabled()) {
            log.info(">>>>>> end qName:[{}]", (Object)qName);
        }
        if ("easy-pdf".equalsIgnoreCase(qName)) {
            this.textDoc.close();
            return;
        }
        if ("pagebreak".equalsIgnoreCase(qName)) {
            this.textDoc.newPage();
            return;
        }
        if ("break".equalsIgnoreCase(qName)) {
            this.contentsBuilder.append("\n");
            return;
        }
        if ("cell".equalsIgnoreCase(qName)) {
            chunk = this.table.lastCell();
            chunk.setContents(this.contentsBuilder.toString());
        }
        if ("table".equalsIgnoreCase(qName)) {
            if (this.table.getCells().size() > 0) {
                try {
                    this.textDoc.writeTable(this.table);
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
            this.contentsBuilder.setLength(0);
            this.table = null;
            return;
        }
        chunk = null;
        try {
            chunk = this.chunkStack.pop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (chunk == null) {
            return;
        }
        String contents = this.contentsBuilder.toString();
        if (contents.length() > 0 || "value".equalsIgnoreCase(qName) || "hspace".equalsIgnoreCase(qName)) {
            chunk.setContents(contents);
            this.contentsBuilder.setLength(0);
            this.chunkList.add(chunk.clone());
        }
        for (String label : BLOCK_ELEMENTS) {
            if (this.chunkList.size() == 0 && "para".equalsIgnoreCase(label)) {
                chunk.setContents(" ");
                this.chunkList.add(chunk.clone());
            }
            if (this.chunkList.size() <= 0 || !label.equalsIgnoreCase(qName)) continue;
            try {
                this.textDoc.writeBlock(qName, this.chunkList);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SAXException("Write to PDF failed.");
            }
            finally {
                this.chunkList.clear();
            }
        }
    }
}

