/*
 * Decompiled with CFR 0.152.
 */
package com.janeluo.easypdf.draw;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.canvas.draw.ILineDrawer;
import com.itextpdf.layout.property.HorizontalAlignment;

public class CustomLineSeparator
implements ILineDrawer {
    protected float lineWidth = 1.0f;
    protected float percentage = 100.0f;
    protected Color color;
    protected HorizontalAlignment alignment = null;

    public CustomLineSeparator() {
    }

    public CustomLineSeparator(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public CustomLineSeparator(float lineWidth, float percentage) {
        this.lineWidth = lineWidth;
        this.percentage = percentage;
    }

    public CustomLineSeparator(float lineWidth, float percentage, Color color) {
        this.lineWidth = lineWidth;
        this.percentage = percentage;
        this.color = color;
    }

    public CustomLineSeparator(float lineWidth, float percentage, Color color, HorizontalAlignment alignment) {
        this.lineWidth = lineWidth;
        this.percentage = percentage;
        this.color = color;
        this.alignment = alignment;
    }

    public void draw(PdfCanvas canvas, Rectangle drawArea) {
    }

    public void drawLine(PdfCanvas canvas, float leftX, float rightX, float y) {
        float s;
        float w = this.getPercentage() < 0.0f ? -this.getPercentage() : (rightX - leftX) * this.getPercentage() / 100.0f;
        switch (this.getAlignment()) {
            case LEFT: {
                s = 0.0f;
                break;
            }
            case RIGHT: {
                s = rightX - leftX - w;
                break;
            }
            default: {
                s = (rightX - leftX - w) / 2.0f;
            }
        }
        canvas.setLineWidth(this.getLineWidth());
        if (this.getColor() != null) {
            canvas.setStrokeColor(this.getColor());
        }
        canvas.moveTo((double)(s + leftX), (double)y);
        canvas.lineTo((double)(s + w + leftX), (double)y);
        canvas.stroke();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float getPercentage() {
        return this.percentage;
    }

    public void setPercentage(float percentage) {
        this.percentage = percentage;
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
    }
}

