/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.android.device;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.jaredrummler.android.device.DeviceName;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DeviceDatabase
extends SQLiteOpenHelper {
    private static final String TABLE_DEVICES = "devices";
    private static final String COLUMN_NAME = "name";
    private static final String COLUMN_CODENAME = "codename";
    private static final String COLUMN_MODEL = "model";
    private static final String NAME = "android-devices.db";
    private static final int VERSION = 1;
    private final File file;
    private final Context context;

    public DeviceDatabase(Context context) {
        super(context, NAME, null, 1);
        this.context = context.getApplicationContext();
        this.file = context.getDatabasePath(NAME);
        if (!this.file.exists()) {
            this.create();
        }
    }

    public String query(@Nullable String codename, @Nullable String model) {
        String[] selectionArgs;
        String selection;
        SQLiteDatabase database = this.getReadableDatabase();
        String[] columns = new String[]{COLUMN_NAME};
        if (codename != null && model != null) {
            selection = "codename LIKE ? OR model LIKE ?";
            selectionArgs = new String[]{codename, model};
        } else if (codename != null) {
            selection = "codename LIKE ?";
            selectionArgs = new String[]{codename};
        } else if (model != null) {
            selection = "model LIKE ?";
            selectionArgs = new String[]{model};
        } else {
            return null;
        }
        Cursor cursor = database.query(TABLE_DEVICES, columns, selection, selectionArgs, null, null, null);
        String name = null;
        if (cursor.moveToFirst()) {
            name = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_NAME));
        }
        this.close((Closeable)cursor);
        this.close((Closeable)database);
        return name;
    }

    public DeviceName.DeviceInfo queryToDevice(@Nullable String codename, @Nullable String model) {
        String[] selectionArgs;
        String selection;
        SQLiteDatabase database = this.getReadableDatabase();
        String[] columns = new String[]{COLUMN_NAME, COLUMN_CODENAME, COLUMN_MODEL};
        if (!TextUtils.isEmpty((CharSequence)codename) && !TextUtils.isEmpty((CharSequence)model)) {
            selection = "codename LIKE ? OR model LIKE ?";
            selectionArgs = new String[]{codename, model};
        } else if (!TextUtils.isEmpty((CharSequence)codename)) {
            selection = "codename LIKE ?";
            selectionArgs = new String[]{codename};
        } else if (TextUtils.isEmpty((CharSequence)model)) {
            selection = "model LIKE ?";
            selectionArgs = new String[]{model};
        } else {
            return null;
        }
        Cursor cursor = database.query(TABLE_DEVICES, columns, selection, selectionArgs, null, null, null);
        DeviceName.DeviceInfo deviceInfo = null;
        if (cursor.moveToFirst()) {
            String name = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_NAME));
            codename = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_CODENAME));
            model = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_MODEL));
            deviceInfo = new DeviceName.DeviceInfo(name, codename, model);
        }
        this.close((Closeable)cursor);
        this.close((Closeable)database);
        return deviceInfo;
    }

    public void onCreate(SQLiteDatabase db) {
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (newVersion > oldVersion && (this.context.deleteDatabase(NAME) || this.file.delete() || !this.file.exists())) {
            this.create();
        }
    }

    private void create() throws SQLException {
        try {
            this.getReadableDatabase();
            this.close();
            this.transferDatabaseAsset();
        }
        catch (IOException e) {
            throw new SQLException("Error creating android-devices.db database", (Throwable)e);
        }
    }

    private void transferDatabaseAsset() throws IOException {
        int length;
        InputStream input = this.context.getAssets().open(NAME);
        FileOutputStream output = new FileOutputStream(this.file);
        byte[] buffer = new byte[2048];
        while ((length = input.read(buffer)) > 0) {
            ((OutputStream)output).write(buffer, 0, length);
        }
        output.flush();
        this.close(output);
        this.close(input);
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

