/*
 * Copyright (c) 2015, Jared Rummler
 * Copyright (c) 2015, Liu Dong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the <organization> nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.jaredrummler.apkparser.utils;

import java.util.HashMap;
import java.util.Map;

public class ResourceLoader {

  public static Map<Integer, String> loadSystemAttrIds() {
    Map<Integer, String> map = new HashMap<>();
    map.put(16842752, "theme");
    map.put(16842753, "label");
    map.put(16842754, "icon");
    map.put(16842755, "name");
    map.put(16842756, "manageSpaceActivity");
    map.put(16842757, "allowClearUserData");
    map.put(16842758, "permission");
    map.put(16842759, "readPermission");
    map.put(16842760, "writePermission");
    map.put(16842761, "protectionLevel");
    map.put(16842762, "permissionGroup");
    map.put(16842763, "sharedUserId");
    map.put(16842764, "hasCode");
    map.put(16842765, "persistent");
    map.put(16842766, "enabled");
    map.put(16842767, "debuggable");
    map.put(16842768, "exported");
    map.put(16842769, "process");
    map.put(16842770, "taskAffinity");
    map.put(16842771, "multiprocess");
    map.put(16842772, "finishOnTaskLaunch");
    map.put(16842773, "clearTaskOnLaunch");
    map.put(16842774, "stateNotNeeded");
    map.put(16842775, "excludeFromRecents");
    map.put(16842776, "authorities");
    map.put(16842777, "syncable");
    map.put(16842778, "initOrder");
    map.put(16842779, "grantUriPermissions");
    map.put(16842780, "priority");
    map.put(16842781, "launchMode");
    map.put(16842782, "screenOrientation");
    map.put(16842783, "configChanges");
    map.put(16842784, "description");
    map.put(16842785, "targetPackage");
    map.put(16842786, "handleProfiling");
    map.put(16842787, "functionalTest");
    map.put(16842788, "value");
    map.put(16842789, "resource");
    map.put(16842790, "mimeType");
    map.put(16842791, "scheme");
    map.put(16842792, "host");
    map.put(16842793, "port");
    map.put(16842794, "path");
    map.put(16842795, "pathPrefix");
    map.put(16842796, "pathPattern");
    map.put(16842797, "action");
    map.put(16842798, "data");
    map.put(16842799, "targetClass");
    map.put(16842800, "colorForeground");
    map.put(16842801, "colorBackground");
    map.put(16842802, "backgroundDimAmount");
    map.put(16842803, "disabledAlpha");
    map.put(16842804, "textAppearance");
    map.put(16842805, "textAppearanceInverse");
    map.put(16842806, "textColorPrimary");
    map.put(16842807, "textColorPrimaryDisableOnly");
    map.put(16842808, "textColorSecondary");
    map.put(16842809, "textColorPrimaryInverse");
    map.put(16842810, "textColorSecondaryInverse");
    map.put(16842811, "textColorPrimaryNoDisable");
    map.put(16842812, "textColorSecondaryNoDisable");
    map.put(16842813, "textColorPrimaryInverseNoDisable");
    map.put(16842814, "textColorSecondaryInverseNoDisable");
    map.put(16842815, "textColorHintInverse");
    map.put(16842816, "textAppearanceLarge");
    map.put(16842817, "textAppearanceMedium");
    map.put(16842818, "textAppearanceSmall");
    map.put(16842819, "textAppearanceLargeInverse");
    map.put(16842820, "textAppearanceMediumInverse");
    map.put(16842821, "textAppearanceSmallInverse");
    map.put(16842822, "textCheckMark");
    map.put(16842823, "textCheckMarkInverse");
    map.put(16842824, "buttonStyle");
    map.put(16842825, "buttonStyleSmall");
    map.put(16842826, "buttonStyleInset");
    map.put(16842827, "buttonStyleToggle");
    map.put(16842828, "galleryItemBackground");
    map.put(16842829, "listPreferredItemHeight");
    map.put(16842830, "expandableListPreferredItemPaddingLeft");
    map.put(16842831, "expandableListPreferredChildPaddingLeft");
    map.put(16842832, "expandableListPreferredItemIndicatorLeft");
    map.put(16842833, "expandableListPreferredItemIndicatorRight");
    map.put(16842834, "expandableListPreferredChildIndicatorLeft");
    map.put(16842835, "expandableListPreferredChildIndicatorRight");
    map.put(16842836, "windowBackground");
    map.put(16842837, "windowFrame");
    map.put(16842838, "windowNoTitle");
    map.put(16842839, "windowIsFloating");
    map.put(16842840, "windowIsTranslucent");
    map.put(16842841, "windowContentOverlay");
    map.put(16842842, "windowTitleSize");
    map.put(16842843, "windowTitleStyle");
    map.put(16842844, "windowTitleBackgroundStyle");
    map.put(16842845, "alertDialogStyle");
    map.put(16842846, "panelBackground");
    map.put(16842847, "panelFullBackground");
    map.put(16842848, "panelColorForeground");
    map.put(16842849, "panelColorBackground");
    map.put(16842850, "panelTextAppearance");
    map.put(16842851, "scrollbarSize");
    map.put(16842852, "scrollbarThumbHorizontal");
    map.put(16842853, "scrollbarThumbVertical");
    map.put(16842854, "scrollbarTrackHorizontal");
    map.put(16842855, "scrollbarTrackVertical");
    map.put(16842856, "scrollbarAlwaysDrawHorizontalTrack");
    map.put(16842857, "scrollbarAlwaysDrawVerticalTrack");
    map.put(16842858, "absListViewStyle");
    map.put(16842859, "autoCompleteTextViewStyle");
    map.put(16842860, "checkboxStyle");
    map.put(16842861, "dropDownListViewStyle");
    map.put(16842862, "editTextStyle");
    map.put(16842863, "expandableListViewStyle");
    map.put(16842864, "galleryStyle");
    map.put(16842865, "gridViewStyle");
    map.put(16842866, "imageButtonStyle");
    map.put(16842867, "imageWellStyle");
    map.put(16842868, "listViewStyle");
    map.put(16842869, "listViewWhiteStyle");
    map.put(16842870, "popupWindowStyle");
    map.put(16842871, "progressBarStyle");
    map.put(16842872, "progressBarStyleHorizontal");
    map.put(16842873, "progressBarStyleSmall");
    map.put(16842874, "progressBarStyleLarge");
    map.put(16842875, "seekBarStyle");
    map.put(16842876, "ratingBarStyle");
    map.put(16842877, "ratingBarStyleSmall");
    map.put(16842878, "radioButtonStyle");
    map.put(16842879, "scrollbarStyle");
    map.put(16842880, "scrollViewStyle");
    map.put(16842881, "spinnerStyle");
    map.put(16842882, "starStyle");
    map.put(16842883, "tabWidgetStyle");
    map.put(16842884, "textViewStyle");
    map.put(16842885, "webViewStyle");
    map.put(16842886, "dropDownItemStyle");
    map.put(16842887, "spinnerDropDownItemStyle");
    map.put(16842888, "dropDownHintAppearance");
    map.put(16842889, "spinnerItemStyle");
    map.put(16842890, "mapViewStyle");
    map.put(16842891, "preferenceScreenStyle");
    map.put(16842892, "preferenceCategoryStyle");
    map.put(16842893, "preferenceInformationStyle");
    map.put(16842894, "preferenceStyle");
    map.put(16842895, "checkBoxPreferenceStyle");
    map.put(16842896, "yesNoPreferenceStyle");
    map.put(16842897, "dialogPreferenceStyle");
    map.put(16842898, "editTextPreferenceStyle");
    map.put(16842899, "ringtonePreferenceStyle");
    map.put(16842900, "preferenceLayoutChild");
    map.put(16842901, "textSize");
    map.put(16842902, "typeface");
    map.put(16842903, "textStyle");
    map.put(16842904, "textColor");
    map.put(16842905, "textColorHighlight");
    map.put(16842906, "textColorHint");
    map.put(16842907, "textColorLink");
    map.put(16842908, "state_focused");
    map.put(16842909, "state_window_focused");
    map.put(16842910, "state_enabled");
    map.put(16842911, "state_checkable");
    map.put(16842912, "state_checked");
    map.put(16842913, "state_selected");
    map.put(16842914, "state_active");
    map.put(16842915, "state_single");
    map.put(16842916, "state_first");
    map.put(16842917, "state_middle");
    map.put(16842918, "state_last");
    map.put(16842919, "state_pressed");
    map.put(16842920, "state_expanded");
    map.put(16842921, "state_empty");
    map.put(16842922, "state_above_anchor");
    map.put(16842923, "ellipsize");
    map.put(16842924, "x");
    map.put(16842925, "y");
    map.put(16842926, "windowAnimationStyle");
    map.put(16842927, "gravity");
    map.put(16842928, "autoLink");
    map.put(16842929, "linksClickable");
    map.put(16842930, "entries");
    map.put(16842931, "layout_gravity");
    map.put(16842932, "windowEnterAnimation");
    map.put(16842933, "windowExitAnimation");
    map.put(16842934, "windowShowAnimation");
    map.put(16842935, "windowHideAnimation");
    map.put(16842936, "activityOpenEnterAnimation");
    map.put(16842937, "activityOpenExitAnimation");
    map.put(16842938, "activityCloseEnterAnimation");
    map.put(16842939, "activityCloseExitAnimation");
    map.put(16842940, "taskOpenEnterAnimation");
    map.put(16842941, "taskOpenExitAnimation");
    map.put(16842942, "taskCloseEnterAnimation");
    map.put(16842943, "taskCloseExitAnimation");
    map.put(16842944, "taskToFrontEnterAnimation");
    map.put(16842945, "taskToFrontExitAnimation");
    map.put(16842946, "taskToBackEnterAnimation");
    map.put(16842947, "taskToBackExitAnimation");
    map.put(16842948, "orientation");
    map.put(16842949, "keycode");
    map.put(16842950, "fullDark");
    map.put(16842951, "topDark");
    map.put(16842952, "centerDark");
    map.put(16842953, "bottomDark");
    map.put(16842954, "fullBright");
    map.put(16842955, "topBright");
    map.put(16842956, "centerBright");
    map.put(16842957, "bottomBright");
    map.put(16842958, "bottomMedium");
    map.put(16842959, "centerMedium");
    map.put(16842960, "id");
    map.put(16842961, "tag");
    map.put(16842962, "scrollX");
    map.put(16842963, "scrollY");
    map.put(16842964, "background");
    map.put(16842965, "padding");
    map.put(16842966, "paddingLeft");
    map.put(16842967, "paddingTop");
    map.put(16842968, "paddingRight");
    map.put(16842969, "paddingBottom");
    map.put(16842970, "focusable");
    map.put(16842971, "focusableInTouchMode");
    map.put(16842972, "visibility");
    map.put(16842973, "fitsSystemWindows");
    map.put(16842974, "scrollbars");
    map.put(16842975, "fadingEdge");
    map.put(16842976, "fadingEdgeLength");
    map.put(16842977, "nextFocusLeft");
    map.put(16842978, "nextFocusRight");
    map.put(16842979, "nextFocusUp");
    map.put(16842980, "nextFocusDown");
    map.put(16842981, "clickable");
    map.put(16842982, "longClickable");
    map.put(16842983, "saveEnabled");
    map.put(16842984, "drawingCacheQuality");
    map.put(16842985, "duplicateParentState");
    map.put(16842986, "clipChildren");
    map.put(16842987, "clipToPadding");
    map.put(16842988, "layoutAnimation");
    map.put(16842989, "animationCache");
    map.put(16842990, "persistentDrawingCache");
    map.put(16842991, "alwaysDrawnWithCache");
    map.put(16842992, "addStatesFromChildren");
    map.put(16842993, "descendantFocusability");
    map.put(16842994, "layout");
    map.put(16842995, "inflatedId");
    map.put(16842996, "layout_width");
    map.put(16842997, "layout_height");
    map.put(16842998, "layout_margin");
    map.put(16842999, "layout_marginLeft");
    map.put(16843000, "layout_marginTop");
    map.put(16843001, "layout_marginRight");
    map.put(16843002, "layout_marginBottom");
    map.put(16843003, "listSelector");
    map.put(16843004, "drawSelectorOnTop");
    map.put(16843005, "stackFromBottom");
    map.put(16843006, "scrollingCache");
    map.put(16843007, "textFilterEnabled");
    map.put(16843008, "transcriptMode");
    map.put(16843009, "cacheColorHint");
    map.put(16843010, "dial");
    map.put(16843011, "hand_hour");
    map.put(16843012, "hand_minute");
    map.put(16843013, "format");
    map.put(16843014, "checked");
    map.put(16843015, "button");
    map.put(16843016, "checkMark");
    map.put(16843017, "foreground");
    map.put(16843018, "measureAllChildren");
    map.put(16843019, "groupIndicator");
    map.put(16843020, "childIndicator");
    map.put(16843021, "indicatorLeft");
    map.put(16843022, "indicatorRight");
    map.put(16843023, "childIndicatorLeft");
    map.put(16843024, "childIndicatorRight");
    map.put(16843025, "childDivider");
    map.put(16843026, "animationDuration");
    map.put(16843027, "spacing");
    map.put(16843028, "horizontalSpacing");
    map.put(16843029, "verticalSpacing");
    map.put(16843030, "stretchMode");
    map.put(16843031, "columnWidth");
    map.put(16843032, "numColumns");
    map.put(16843033, "src");
    map.put(16843034, "antialias");
    map.put(16843035, "filter");
    map.put(16843036, "dither");
    map.put(16843037, "scaleType");
    map.put(16843038, "adjustViewBounds");
    map.put(16843039, "maxWidth");
    map.put(16843040, "maxHeight");
    map.put(16843041, "tint");
    map.put(16843042, "baselineAlignBottom");
    map.put(16843043, "cropToPadding");
    map.put(16843044, "textOn");
    map.put(16843045, "textOff");
    map.put(16843046, "baselineAligned");
    map.put(16843047, "baselineAlignedChildIndex");
    map.put(16843048, "weightSum");
    map.put(16843049, "divider");
    map.put(16843050, "dividerHeight");
    map.put(16843051, "choiceMode");
    map.put(16843052, "itemTextAppearance");
    map.put(16843053, "horizontalDivider");
    map.put(16843054, "verticalDivider");
    map.put(16843055, "headerBackground");
    map.put(16843056, "itemBackground");
    map.put(16843057, "itemIconDisabledAlpha");
    map.put(16843058, "rowHeight");
    map.put(16843059, "maxRows");
    map.put(16843060, "maxItemsPerRow");
    map.put(16843061, "moreIcon");
    map.put(16843062, "max");
    map.put(16843063, "progress");
    map.put(16843064, "secondaryProgress");
    map.put(16843065, "indeterminate");
    map.put(16843066, "indeterminateOnly");
    map.put(16843067, "indeterminateDrawable");
    map.put(16843068, "progressDrawable");
    map.put(16843069, "indeterminateDuration");
    map.put(16843070, "indeterminateBehavior");
    map.put(16843071, "minWidth");
    map.put(16843072, "minHeight");
    map.put(16843073, "interpolator");
    map.put(16843074, "thumb");
    map.put(16843075, "thumbOffset");
    map.put(16843076, "numStars");
    map.put(16843077, "rating");
    map.put(16843078, "stepSize");
    map.put(16843079, "isIndicator");
    map.put(16843080, "checkedButton");
    map.put(16843081, "stretchColumns");
    map.put(16843082, "shrinkColumns");
    map.put(16843083, "collapseColumns");
    map.put(16843084, "layout_column");
    map.put(16843085, "layout_span");
    map.put(16843086, "bufferType");
    map.put(16843087, "text");
    map.put(16843088, "hint");
    map.put(16843089, "textScaleX");
    map.put(16843090, "cursorVisible");
    map.put(16843091, "maxLines");
    map.put(16843092, "lines");
    map.put(16843093, "height");
    map.put(16843094, "minLines");
    map.put(16843095, "maxEms");
    map.put(16843096, "ems");
    map.put(16843097, "width");
    map.put(16843098, "minEms");
    map.put(16843099, "scrollHorizontally");
    map.put(16843100, "password");
    map.put(16843101, "singleLine");
    map.put(16843102, "selectAllOnFocus");
    map.put(16843103, "includeFontPadding");
    map.put(16843104, "maxLength");
    map.put(16843105, "shadowColor");
    map.put(16843106, "shadowDx");
    map.put(16843107, "shadowDy");
    map.put(16843108, "shadowRadius");
    map.put(16843109, "numeric");
    map.put(16843110, "digits");
    map.put(16843111, "phoneNumber");
    map.put(16843112, "inputMethod");
    map.put(16843113, "capitalize");
    map.put(16843114, "autoText");
    map.put(16843115, "editable");
    map.put(16843116, "freezesText");
    map.put(16843117, "drawableTop");
    map.put(16843118, "drawableBottom");
    map.put(16843119, "drawableLeft");
    map.put(16843120, "drawableRight");
    map.put(16843121, "drawablePadding");
    map.put(16843122, "completionHint");
    map.put(16843123, "completionHintView");
    map.put(16843124, "completionThreshold");
    map.put(16843125, "dropDownSelector");
    map.put(16843126, "popupBackground");
    map.put(16843127, "inAnimation");
    map.put(16843128, "outAnimation");
    map.put(16843129, "flipInterval");
    map.put(16843130, "fillViewport");
    map.put(16843131, "prompt");
    map.put(16843132, "startYear");
    map.put(16843133, "endYear");
    map.put(16843134, "mode");
    map.put(16843135, "layout_x");
    map.put(16843136, "layout_y");
    map.put(16843137, "layout_weight");
    map.put(16843138, "layout_toLeftOf");
    map.put(16843139, "layout_toRightOf");
    map.put(16843140, "layout_above");
    map.put(16843141, "layout_below");
    map.put(16843142, "layout_alignBaseline");
    map.put(16843143, "layout_alignLeft");
    map.put(16843144, "layout_alignTop");
    map.put(16843145, "layout_alignRight");
    map.put(16843146, "layout_alignBottom");
    map.put(16843147, "layout_alignParentLeft");
    map.put(16843148, "layout_alignParentTop");
    map.put(16843149, "layout_alignParentRight");
    map.put(16843150, "layout_alignParentBottom");
    map.put(16843151, "layout_centerInParent");
    map.put(16843152, "layout_centerHorizontal");
    map.put(16843153, "layout_centerVertical");
    map.put(16843154, "layout_alignWithParentIfMissing");
    map.put(16843155, "layout_scale");
    map.put(16843156, "visible");
    map.put(16843157, "variablePadding");
    map.put(16843158, "constantSize");
    map.put(16843159, "oneshot");
    map.put(16843160, "duration");
    map.put(16843161, "drawable");
    map.put(16843162, "shape");
    map.put(16843163, "innerRadiusRatio");
    map.put(16843164, "thicknessRatio");
    map.put(16843165, "startColor");
    map.put(16843166, "endColor");
    map.put(16843167, "useLevel");
    map.put(16843168, "angle");
    map.put(16843169, "type");
    map.put(16843170, "centerX");
    map.put(16843171, "centerY");
    map.put(16843172, "gradientRadius");
    map.put(16843173, "color");
    map.put(16843174, "dashWidth");
    map.put(16843175, "dashGap");
    map.put(16843176, "radius");
    map.put(16843177, "topLeftRadius");
    map.put(16843178, "topRightRadius");
    map.put(16843179, "bottomLeftRadius");
    map.put(16843180, "bottomRightRadius");
    map.put(16843181, "left");
    map.put(16843182, "top");
    map.put(16843183, "right");
    map.put(16843184, "bottom");
    map.put(16843185, "minLevel");
    map.put(16843186, "maxLevel");
    map.put(16843187, "fromDegrees");
    map.put(16843188, "toDegrees");
    map.put(16843189, "pivotX");
    map.put(16843190, "pivotY");
    map.put(16843191, "insetLeft");
    map.put(16843192, "insetRight");
    map.put(16843193, "insetTop");
    map.put(16843194, "insetBottom");
    map.put(16843195, "shareInterpolator");
    map.put(16843196, "fillBefore");
    map.put(16843197, "fillAfter");
    map.put(16843198, "startOffset");
    map.put(16843199, "repeatCount");
    map.put(16843200, "repeatMode");
    map.put(16843201, "zAdjustment");
    map.put(16843202, "fromXScale");
    map.put(16843203, "toXScale");
    map.put(16843204, "fromYScale");
    map.put(16843205, "toYScale");
    map.put(16843206, "fromXDelta");
    map.put(16843207, "toXDelta");
    map.put(16843208, "fromYDelta");
    map.put(16843209, "toYDelta");
    map.put(16843210, "fromAlpha");
    map.put(16843211, "toAlpha");
    map.put(16843212, "delay");
    map.put(16843213, "animation");
    map.put(16843214, "animationOrder");
    map.put(16843215, "columnDelay");
    map.put(16843216, "rowDelay");
    map.put(16843217, "direction");
    map.put(16843218, "directionPriority");
    map.put(16843219, "factor");
    map.put(16843220, "cycles");
    map.put(16843221, "searchMode");
    map.put(16843222, "searchSuggestAuthority");
    map.put(16843223, "searchSuggestPath");
    map.put(16843224, "searchSuggestSelection");
    map.put(16843225, "searchSuggestIntentAction");
    map.put(16843226, "searchSuggestIntentData");
    map.put(16843227, "queryActionMsg");
    map.put(16843228, "suggestActionMsg");
    map.put(16843229, "suggestActionMsgColumn");
    map.put(16843230, "menuCategory");
    map.put(16843231, "orderInCategory");
    map.put(16843232, "checkableBehavior");
    map.put(16843233, "title");
    map.put(16843234, "titleCondensed");
    map.put(16843235, "alphabeticShortcut");
    map.put(16843236, "numericShortcut");
    map.put(16843237, "checkable");
    map.put(16843238, "selectable");
    map.put(16843239, "orderingFromXml");
    map.put(16843240, "key");
    map.put(16843241, "summary");
    map.put(16843242, "order");
    map.put(16843243, "widgetLayout");
    map.put(16843244, "dependency");
    map.put(16843245, "defaultValue");
    map.put(16843246, "shouldDisableView");
    map.put(16843247, "summaryOn");
    map.put(16843248, "summaryOff");
    map.put(16843249, "disableDependentsState");
    map.put(16843250, "dialogTitle");
    map.put(16843251, "dialogMessage");
    map.put(16843252, "dialogIcon");
    map.put(16843253, "positiveButtonText");
    map.put(16843254, "negativeButtonText");
    map.put(16843255, "dialogLayout");
    map.put(16843256, "entryValues");
    map.put(16843257, "ringtoneType");
    map.put(16843258, "showDefault");
    map.put(16843259, "showSilent");
    map.put(16843260, "scaleWidth");
    map.put(16843261, "scaleHeight");
    map.put(16843262, "scaleGravity");
    map.put(16843263, "ignoreGravity");
    map.put(16843264, "foregroundGravity");
    map.put(16843265, "tileMode");
    map.put(16843266, "targetActivity");
    map.put(16843267, "alwaysRetainTaskState");
    map.put(16843268, "allowTaskReparenting");
    map.put(16843269, "searchButtonText");
    map.put(16843270, "colorForegroundInverse");
    map.put(16843271, "textAppearanceButton");
    map.put(16843272, "listSeparatorTextViewStyle");
    map.put(16843273, "streamType");
    map.put(16843274, "clipOrientation");
    map.put(16843275, "centerColor");
    map.put(16843276, "minSdkVersion");
    map.put(16843277, "windowFullscreen");
    map.put(16843278, "unselectedAlpha");
    map.put(16843279, "progressBarStyleSmallTitle");
    map.put(16843280, "ratingBarStyleIndicator");
    map.put(16843281, "apiKey");
    map.put(16843282, "textColorTertiary");
    map.put(16843283, "textColorTertiaryInverse");
    map.put(16843284, "listDivider");
    map.put(16843285, "soundEffectsEnabled");
    map.put(16843286, "keepScreenOn");
    map.put(16843287, "lineSpacingExtra");
    map.put(16843288, "lineSpacingMultiplier");
    map.put(16843289, "listChoiceIndicatorSingle");
    map.put(16843290, "listChoiceIndicatorMultiple");
    map.put(16843291, "versionCode");
    map.put(16843292, "versionName");
    map.put(16843293, "marqueeRepeatLimit");
    map.put(16843294, "windowNoDisplay");
    map.put(16843295, "backgroundDimEnabled");
    map.put(16843296, "inputType");
    map.put(16843297, "isDefault");
    map.put(16843298, "windowDisablePreview");
    map.put(16843299, "privateImeOptions");
    map.put(16843300, "editorExtras");
    map.put(16843301, "settingsActivity");
    map.put(16843302, "fastScrollEnabled");
    map.put(16843303, "reqTouchScreen");
    map.put(16843304, "reqKeyboardType");
    map.put(16843305, "reqHardKeyboard");
    map.put(16843306, "reqNavigation");
    map.put(16843307, "windowSoftInputMode");
    map.put(16843308, "imeFullscreenBackground");
    map.put(16843309, "noHistory");
    map.put(16843310, "headerDividersEnabled");
    map.put(16843311, "footerDividersEnabled");
    map.put(16843312, "candidatesTextStyleSpans");
    map.put(16843313, "smoothScrollbar");
    map.put(16843314, "reqFiveWayNav");
    map.put(16843315, "keyBackground");
    map.put(16843316, "keyTextSize");
    map.put(16843317, "labelTextSize");
    map.put(16843318, "keyTextColor");
    map.put(16843319, "keyPreviewLayout");
    map.put(16843320, "keyPreviewOffset");
    map.put(16843321, "keyPreviewHeight");
    map.put(16843322, "verticalCorrection");
    map.put(16843323, "popupLayout");
    map.put(16843324, "state_long_pressable");
    map.put(16843325, "keyWidth");
    map.put(16843326, "keyHeight");
    map.put(16843327, "horizontalGap");
    map.put(16843328, "verticalGap");
    map.put(16843329, "rowEdgeFlags");
    map.put(16843330, "codes");
    map.put(16843331, "popupKeyboard");
    map.put(16843332, "popupCharacters");
    map.put(16843333, "keyEdgeFlags");
    map.put(16843334, "isModifier");
    map.put(16843335, "isSticky");
    map.put(16843336, "isRepeatable");
    map.put(16843337, "iconPreview");
    map.put(16843338, "keyOutputText");
    map.put(16843339, "keyLabel");
    map.put(16843340, "keyIcon");
    map.put(16843341, "keyboardMode");
    map.put(16843342, "isScrollContainer");
    map.put(16843343, "fillEnabled");
    map.put(16843344, "updatePeriodMillis");
    map.put(16843345, "initialLayout");
    map.put(16843346, "voiceSearchMode");
    map.put(16843347, "voiceLanguageModel");
    map.put(16843348, "voicePromptText");
    map.put(16843349, "voiceLanguage");
    map.put(16843350, "voiceMaxResults");
    map.put(16843351, "bottomOffset");
    map.put(16843352, "topOffset");
    map.put(16843353, "allowSingleTap");
    map.put(16843354, "handle");
    map.put(16843355, "content");
    map.put(16843356, "animateOnClick");
    map.put(16843357, "configure");
    map.put(16843358, "hapticFeedbackEnabled");
    map.put(16843359, "innerRadius");
    map.put(16843360, "thickness");
    map.put(16843361, "sharedUserLabel");
    map.put(16843362, "dropDownWidth");
    map.put(16843363, "dropDownAnchor");
    map.put(16843364, "imeOptions");
    map.put(16843365, "imeActionLabel");
    map.put(16843366, "imeActionId");
    map.put(16843368, "imeExtractEnterAnimation");
    map.put(16843369, "imeExtractExitAnimation");
    map.put(16843370, "tension");
    map.put(16843371, "extraTension");
    map.put(16843372, "anyDensity");
    map.put(16843373, "searchSuggestThreshold");
    map.put(16843374, "includeInGlobalSearch");
    map.put(16843375, "onClick");
    map.put(16843376, "targetSdkVersion");
    map.put(16843377, "maxSdkVersion");
    map.put(16843378, "testOnly");
    map.put(16843379, "contentDescription");
    map.put(16843380, "gestureStrokeWidth");
    map.put(16843381, "gestureColor");
    map.put(16843382, "uncertainGestureColor");
    map.put(16843383, "fadeOffset");
    map.put(16843384, "fadeDuration");
    map.put(16843385, "gestureStrokeType");
    map.put(16843386, "gestureStrokeLengthThreshold");
    map.put(16843387, "gestureStrokeSquarenessThreshold");
    map.put(16843388, "gestureStrokeAngleThreshold");
    map.put(16843389, "eventsInterceptionEnabled");
    map.put(16843390, "fadeEnabled");
    map.put(16843391, "backupAgent");
    map.put(16843392, "allowBackup");
    map.put(16843393, "glEsVersion");
    map.put(16843394, "queryAfterZeroResults");
    map.put(16843395, "dropDownHeight");
    map.put(16843396, "smallScreens");
    map.put(16843397, "normalScreens");
    map.put(16843398, "largeScreens");
    map.put(16843399, "progressBarStyleInverse");
    map.put(16843400, "progressBarStyleSmallInverse");
    map.put(16843401, "progressBarStyleLargeInverse");
    map.put(16843402, "searchSettingsDescription");
    map.put(16843403, "textColorPrimaryInverseDisableOnly");
    map.put(16843404, "autoUrlDetect");
    map.put(16843405, "resizeable");
    map.put(16843406, "required");
    map.put(16843407, "accountType");
    map.put(16843408, "contentAuthority");
    map.put(16843409, "userVisible");
    map.put(16843410, "windowShowWallpaper");
    map.put(16843411, "wallpaperOpenEnterAnimation");
    map.put(16843412, "wallpaperOpenExitAnimation");
    map.put(16843413, "wallpaperCloseEnterAnimation");
    map.put(16843414, "wallpaperCloseExitAnimation");
    map.put(16843415, "wallpaperIntraOpenEnterAnimation");
    map.put(16843416, "wallpaperIntraOpenExitAnimation");
    map.put(16843417, "wallpaperIntraCloseEnterAnimation");
    map.put(16843418, "wallpaperIntraCloseExitAnimation");
    map.put(16843419, "supportsUploading");
    map.put(16843420, "killAfterRestore");
    map.put(16843421, "restoreNeedsApplication");
    map.put(16843422, "smallIcon");
    map.put(16843423, "accountPreferences");
    map.put(16843424, "textAppearanceSearchResultSubtitle");
    map.put(16843425, "textAppearanceSearchResultTitle");
    map.put(16843426, "summaryColumn");
    map.put(16843427, "detailColumn");
    map.put(16843428, "detailSocialSummary");
    map.put(16843429, "thumbnail");
    map.put(16843430, "detachWallpaper");
    map.put(16843431, "finishOnCloseSystemDialogs");
    map.put(16843432, "scrollbarFadeDuration");
    map.put(16843433, "scrollbarDefaultDelayBeforeFade");
    map.put(16843434, "fadeScrollbars");
    map.put(16843435, "colorBackgroundCacheHint");
    map.put(16843436, "dropDownHorizontalOffset");
    map.put(16843437, "dropDownVerticalOffset");
    map.put(16843438, "quickContactBadgeStyleWindowSmall");
    map.put(16843439, "quickContactBadgeStyleWindowMedium");
    map.put(16843440, "quickContactBadgeStyleWindowLarge");
    map.put(16843441, "quickContactBadgeStyleSmallWindowSmall");
    map.put(16843442, "quickContactBadgeStyleSmallWindowMedium");
    map.put(16843443, "quickContactBadgeStyleSmallWindowLarge");
    map.put(16843444, "author");
    map.put(16843445, "autoStart");
    map.put(16843446, "expandableListViewWhiteStyle");
    map.put(16843447, "installLocation");
    map.put(16843448, "vmSafeMode");
    map.put(16843449, "webTextViewStyle");
    map.put(16843450, "restoreAnyVersion");
    map.put(16843451, "tabStripLeft");
    map.put(16843452, "tabStripRight");
    map.put(16843453, "tabStripEnabled");
    map.put(16843454, "logo");
    map.put(16843455, "xlargeScreens");
    map.put(16843456, "immersive");
    map.put(16843457, "overScrollMode");
    map.put(16843458, "overScrollHeader");
    map.put(16843459, "overScrollFooter");
    map.put(16843460, "filterTouchesWhenObscured");
    map.put(16843461, "textSelectHandleLeft");
    map.put(16843462, "textSelectHandleRight");
    map.put(16843463, "textSelectHandle");
    map.put(16843464, "textSelectHandleWindowStyle");
    map.put(16843465, "popupAnimationStyle");
    map.put(16843466, "screenSize");
    map.put(16843467, "screenDensity");
    map.put(16843468, "allContactsName");
    map.put(16843469, "windowActionBar");
    map.put(16843470, "actionBarStyle");
    map.put(16843471, "navigationMode");
    map.put(16843472, "displayOptions");
    map.put(16843473, "subtitle");
    map.put(16843474, "customNavigationLayout");
    map.put(16843475, "hardwareAccelerated");
    map.put(16843476, "measureWithLargestChild");
    map.put(16843477, "animateFirstView");
    map.put(16843478, "dropDownSpinnerStyle");
    map.put(16843479, "actionDropDownStyle");
    map.put(16843480, "actionButtonStyle");
    map.put(16843481, "showAsAction");
    map.put(16843482, "previewImage");
    map.put(16843483, "actionModeBackground");
    map.put(16843484, "actionModeCloseDrawable");
    map.put(16843485, "windowActionModeOverlay");
    map.put(16843486, "valueFrom");
    map.put(16843487, "valueTo");
    map.put(16843488, "valueType");
    map.put(16843489, "propertyName");
    map.put(16843490, "ordering");
    map.put(16843491, "fragment");
    map.put(16843492, "windowActionBarOverlay");
    map.put(16843493, "fragmentOpenEnterAnimation");
    map.put(16843494, "fragmentOpenExitAnimation");
    map.put(16843495, "fragmentCloseEnterAnimation");
    map.put(16843496, "fragmentCloseExitAnimation");
    map.put(16843497, "fragmentFadeEnterAnimation");
    map.put(16843498, "fragmentFadeExitAnimation");
    map.put(16843499, "actionBarSize");
    map.put(16843500, "imeSubtypeLocale");
    map.put(16843501, "imeSubtypeMode");
    map.put(16843502, "imeSubtypeExtraValue");
    map.put(16843503, "splitMotionEvents");
    map.put(16843504, "listChoiceBackgroundIndicator");
    map.put(16843505, "spinnerMode");
    map.put(16843506, "animateLayoutChanges");
    map.put(16843507, "actionBarTabStyle");
    map.put(16843508, "actionBarTabBarStyle");
    map.put(16843509, "actionBarTabTextStyle");
    map.put(16843510, "actionOverflowButtonStyle");
    map.put(16843511, "actionModeCloseButtonStyle");
    map.put(16843512, "titleTextStyle");
    map.put(16843513, "subtitleTextStyle");
    map.put(16843514, "iconifiedByDefault");
    map.put(16843515, "actionLayout");
    map.put(16843516, "actionViewClass");
    map.put(16843517, "activatedBackgroundIndicator");
    map.put(16843518, "state_activated");
    map.put(16843519, "listPopupWindowStyle");
    map.put(16843520, "popupMenuStyle");
    map.put(16843521, "textAppearanceLargePopupMenu");
    map.put(16843522, "textAppearanceSmallPopupMenu");
    map.put(16843523, "breadCrumbTitle");
    map.put(16843524, "breadCrumbShortTitle");
    map.put(16843525, "listDividerAlertDialog");
    map.put(16843526, "textColorAlertDialogListItem");
    map.put(16843527, "loopViews");
    map.put(16843528, "dialogTheme");
    map.put(16843529, "alertDialogTheme");
    map.put(16843530, "dividerVertical");
    map.put(16843531, "homeAsUpIndicator");
    map.put(16843532, "enterFadeDuration");
    map.put(16843533, "exitFadeDuration");
    map.put(16843534, "selectableItemBackground");
    map.put(16843535, "autoAdvanceViewId");
    map.put(16843536, "useIntrinsicSizeAsMinimum");
    map.put(16843537, "actionModeCutDrawable");
    map.put(16843538, "actionModeCopyDrawable");
    map.put(16843539, "actionModePasteDrawable");
    map.put(16843540, "textEditPasteWindowLayout");
    map.put(16843541, "textEditNoPasteWindowLayout");
    map.put(16843542, "textIsSelectable");
    map.put(16843543, "windowEnableSplitTouch");
    map.put(16843544, "indeterminateProgressStyle");
    map.put(16843545, "progressBarPadding");
    map.put(16843546, "animationResolution");
    map.put(16843547, "state_accelerated");
    map.put(16843548, "baseline");
    map.put(16843549, "homeLayout");
    map.put(16843550, "opacity");
    map.put(16843551, "alpha");
    map.put(16843552, "transformPivotX");
    map.put(16843553, "transformPivotY");
    map.put(16843554, "translationX");
    map.put(16843555, "translationY");
    map.put(16843556, "scaleX");
    map.put(16843557, "scaleY");
    map.put(16843558, "rotation");
    map.put(16843559, "rotationX");
    map.put(16843560, "rotationY");
    map.put(16843561, "showDividers");
    map.put(16843562, "dividerPadding");
    map.put(16843563, "borderlessButtonStyle");
    map.put(16843564, "dividerHorizontal");
    map.put(16843565, "itemPadding");
    map.put(16843566, "buttonBarStyle");
    map.put(16843567, "buttonBarButtonStyle");
    map.put(16843568, "segmentedButtonStyle");
    map.put(16843569, "staticWallpaperPreview");
    map.put(16843570, "allowParallelSyncs");
    map.put(16843571, "isAlwaysSyncable");
    map.put(16843572, "verticalScrollbarPosition");
    map.put(16843573, "fastScrollAlwaysVisible");
    map.put(16843574, "fastScrollThumbDrawable");
    map.put(16843575, "fastScrollPreviewBackgroundLeft");
    map.put(16843576, "fastScrollPreviewBackgroundRight");
    map.put(16843577, "fastScrollTrackDrawable");
    map.put(16843578, "fastScrollOverlayPosition");
    map.put(16843579, "customTokens");
    map.put(16843580, "nextFocusForward");
    map.put(16843581, "firstDayOfWeek");
    map.put(16843582, "showWeekNumber");
    map.put(16843583, "minDate");
    map.put(16843584, "maxDate");
    map.put(16843585, "shownWeekCount");
    map.put(16843586, "selectedWeekBackgroundColor");
    map.put(16843587, "focusedMonthDateColor");
    map.put(16843588, "unfocusedMonthDateColor");
    map.put(16843589, "weekNumberColor");
    map.put(16843590, "weekSeparatorLineColor");
    map.put(16843591, "selectedDateVerticalBar");
    map.put(16843592, "weekDayTextAppearance");
    map.put(16843593, "dateTextAppearance");
    map.put(16843594, "solidColor");
    map.put(16843595, "spinnersShown");
    map.put(16843596, "calendarViewShown");
    map.put(16843597, "state_multiline");
    map.put(16843598, "detailsElementBackground");
    map.put(16843599, "textColorHighlightInverse");
    map.put(16843600, "textColorLinkInverse");
    map.put(16843601, "editTextColor");
    map.put(16843602, "editTextBackground");
    map.put(16843603, "horizontalScrollViewStyle");
    map.put(16843604, "layerType");
    map.put(16843605, "alertDialogIcon");
    map.put(16843606, "windowMinWidthMajor");
    map.put(16843607, "windowMinWidthMinor");
    map.put(16843608, "queryHint");
    map.put(16843609, "fastScrollTextColor");
    map.put(16843610, "largeHeap");
    map.put(16843611, "windowCloseOnTouchOutside");
    map.put(16843612, "datePickerStyle");
    map.put(16843613, "calendarViewStyle");
    map.put(16843614, "textEditSidePasteWindowLayout");
    map.put(16843615, "textEditSideNoPasteWindowLayout");
    map.put(16843616, "actionMenuTextAppearance");
    map.put(16843617, "actionMenuTextColor");
    map.put(16843618, "textCursorDrawable");
    map.put(16843619, "resizeMode");
    map.put(16843620, "requiresSmallestWidthDp");
    map.put(16843621, "compatibleWidthLimitDp");
    map.put(16843622, "largestWidthLimitDp");
    map.put(16843623, "state_hovered");
    map.put(16843624, "state_drag_can_accept");
    map.put(16843625, "state_drag_hovered");
    map.put(16843626, "stopWithTask");
    map.put(16843627, "switchTextOn");
    map.put(16843628, "switchTextOff");
    map.put(16843629, "switchPreferenceStyle");
    map.put(16843630, "switchTextAppearance");
    map.put(16843631, "track");
    map.put(16843632, "switchMinWidth");
    map.put(16843633, "switchPadding");
    map.put(16843634, "thumbTextPadding");
    map.put(16843635, "textSuggestionsWindowStyle");
    map.put(16843636, "textEditSuggestionItemLayout");
    map.put(16843637, "rowCount");
    map.put(16843638, "rowOrderPreserved");
    map.put(16843639, "columnCount");
    map.put(16843640, "columnOrderPreserved");
    map.put(16843641, "useDefaultMargins");
    map.put(16843642, "alignmentMode");
    map.put(16843643, "layout_row");
    map.put(16843644, "layout_rowSpan");
    map.put(16843645, "layout_columnSpan");
    map.put(16843646, "actionModeSelectAllDrawable");
    map.put(16843647, "isAuxiliary");
    map.put(16843648, "accessibilityEventTypes");
    map.put(16843649, "packageNames");
    map.put(16843650, "accessibilityFeedbackType");
    map.put(16843651, "notificationTimeout");
    map.put(16843652, "accessibilityFlags");
    map.put(16843653, "canRetrieveWindowContent");
    map.put(16843654, "listPreferredItemHeightLarge");
    map.put(16843655, "listPreferredItemHeightSmall");
    map.put(16843656, "actionBarSplitStyle");
    map.put(16843657, "actionProviderClass");
    map.put(16843658, "backgroundStacked");
    map.put(16843659, "backgroundSplit");
    map.put(16843660, "textAllCaps");
    map.put(16843661, "colorPressedHighlight");
    map.put(16843662, "colorLongPressedHighlight");
    map.put(16843663, "colorFocusedHighlight");
    map.put(16843664, "colorActivatedHighlight");
    map.put(16843665, "colorMultiSelectHighlight");
    map.put(16843666, "drawableStart");
    map.put(16843667, "drawableEnd");
    map.put(16843668, "actionModeStyle");
    map.put(16843669, "minResizeWidth");
    map.put(16843670, "minResizeHeight");
    map.put(16843671, "actionBarWidgetTheme");
    map.put(16843672, "uiOptions");
    map.put(16843673, "subtypeLocale");
    map.put(16843674, "subtypeExtraValue");
    map.put(16843675, "actionBarDivider");
    map.put(16843676, "actionBarItemBackground");
    map.put(16843677, "actionModeSplitBackground");
    map.put(16843678, "textAppearanceListItem");
    map.put(16843679, "textAppearanceListItemSmall");
    map.put(16843680, "targetDescriptions");
    map.put(16843681, "directionDescriptions");
    map.put(16843682, "overridesImplicitlyEnabledSubtype");
    map.put(16843683, "listPreferredItemPaddingLeft");
    map.put(16843684, "listPreferredItemPaddingRight");
    map.put(16843685, "requiresFadingEdge");
    map.put(16843686, "publicKey");
    map.put(16843687, "parentActivityName");
    map.put(16843689, "isolatedProcess");
    map.put(16843690, "importantForAccessibility");
    map.put(16843691, "keyboardLayout");
    map.put(16843692, "fontFamily");
    map.put(16843693, "mediaRouteButtonStyle");
    map.put(16843694, "mediaRouteTypes");
    map.put(16843695, "supportsRtl");
    map.put(16843696, "textDirection");
    map.put(16843697, "textAlignment");
    map.put(16843698, "layoutDirection");
    map.put(16843699, "paddingStart");
    map.put(16843700, "paddingEnd");
    map.put(16843701, "layout_marginStart");
    map.put(16843702, "layout_marginEnd");
    map.put(16843703, "layout_toStartOf");
    map.put(16843704, "layout_toEndOf");
    map.put(16843705, "layout_alignStart");
    map.put(16843706, "layout_alignEnd");
    map.put(16843707, "layout_alignParentStart");
    map.put(16843708, "layout_alignParentEnd");
    map.put(16843709, "listPreferredItemPaddingStart");
    map.put(16843710, "listPreferredItemPaddingEnd");
    map.put(16843711, "singleUser");
    map.put(16843712, "presentationTheme");
    map.put(16843713, "subtypeId");
    map.put(16843714, "initialKeyguardLayout");
    map.put(16843716, "widgetCategory");
    map.put(16843717, "permissionGroupFlags");
    map.put(16843718, "labelFor");
    map.put(16843719, "permissionFlags");
    map.put(16843720, "checkedTextViewStyle");
    map.put(16843721, "showOnLockScreen");
    map.put(16843722, "format12Hour");
    map.put(16843723, "format24Hour");
    map.put(16843724, "timeZone");
    map.put(16843725, "mipMap");
    map.put(16843726, "mirrorForRtl");
    map.put(16843727, "windowOverscan");
    map.put(16843728, "requiredForAllUsers");
    map.put(16843729, "indicatorStart");
    map.put(16843730, "indicatorEnd");
    map.put(16843731, "childIndicatorStart");
    map.put(16843732, "childIndicatorEnd");
    map.put(16843733, "restrictedAccountType");
    map.put(16843734, "requiredAccountType");
    map.put(16843735, "canRequestTouchExplorationMode");
    map.put(16843736, "canRequestEnhancedWebAccessibility");
    map.put(16843737, "canRequestFilterKeyEvents");
    map.put(16843738, "layoutMode");
    map.put(16843739, "keySet");
    map.put(16843740, "targetId");
    map.put(16843741, "fromScene");
    map.put(16843742, "toScene");
    map.put(16843743, "transition");
    map.put(16843744, "transitionOrdering");
    map.put(16843745, "fadingMode");
    map.put(16843746, "startDelay");
    map.put(16843747, "ssp");
    map.put(16843748, "sspPrefix");
    map.put(16843749, "sspPattern");
    map.put(16843750, "addPrintersActivity");
    map.put(16843751, "vendor");
    map.put(16843752, "category");
    map.put(16843753, "isAsciiCapable");
    map.put(16843754, "autoMirrored");
    map.put(16843755, "supportsSwitchingToNextInputMethod");
    map.put(16843756, "requireDeviceUnlock");
    map.put(16843757, "apduServiceBanner");
    map.put(16843758, "accessibilityLiveRegion");
    map.put(16843759, "windowTranslucentStatus");
    map.put(16843760, "windowTranslucentNavigation");
    map.put(16843761, "advancedPrintOptionsActivity");
    map.put(16843762, "banner");
    map.put(16843763, "windowSwipeToDismiss");
    map.put(16843764, "isGame");
    map.put(16843765, "allowEmbedded");
    map.put(16843766, "setupActivity");
    map.put(16843767, "fastScrollStyle");
    map.put(16843768, "windowContentTransitions");
    map.put(16843769, "windowContentTransitionManager");
    map.put(16843770, "translationZ");
    map.put(16843771, "tintMode");
    map.put(16843772, "controlX1");
    map.put(16843773, "controlY1");
    map.put(16843774, "controlX2");
    map.put(16843775, "controlY2");
    map.put(16843776, "transitionName");
    map.put(16843777, "transitionGroup");
    map.put(16843778, "viewportWidth");
    map.put(16843779, "viewportHeight");
    map.put(16843780, "fillColor");
    map.put(16843781, "pathData");
    map.put(16843782, "strokeColor");
    map.put(16843783, "strokeWidth");
    map.put(16843784, "trimPathStart");
    map.put(16843785, "trimPathEnd");
    map.put(16843786, "trimPathOffset");
    map.put(16843787, "strokeLineCap");
    map.put(16843788, "strokeLineJoin");
    map.put(16843789, "strokeMiterLimit");
    map.put(16843817, "colorControlNormal");
    map.put(16843818, "colorControlActivated");
    map.put(16843819, "colorButtonNormal");
    map.put(16843820, "colorControlHighlight");
    map.put(16843821, "persistableMode");
    map.put(16843822, "titleTextAppearance");
    map.put(16843823, "subtitleTextAppearance");
    map.put(16843824, "slideEdge");
    map.put(16843825, "actionBarTheme");
    map.put(16843826, "textAppearanceListItemSecondary");
    map.put(16843827, "colorPrimary");
    map.put(16843828, "colorPrimaryDark");
    map.put(16843829, "colorAccent");
    map.put(16843830, "nestedScrollingEnabled");
    map.put(16843831, "windowEnterTransition");
    map.put(16843832, "windowExitTransition");
    map.put(16843833, "windowSharedElementEnterTransition");
    map.put(16843834, "windowSharedElementExitTransition");
    map.put(16843835, "windowAllowReturnTransitionOverlap");
    map.put(16843836, "windowAllowEnterTransitionOverlap");
    map.put(16843837, "sessionService");
    map.put(16843838, "stackViewStyle");
    map.put(16843839, "switchStyle");
    map.put(16843840, "elevation");
    map.put(16843841, "excludeId");
    map.put(16843842, "excludeClass");
    map.put(16843843, "hideOnContentScroll");
    map.put(16843844, "actionOverflowMenuStyle");
    map.put(16843845, "documentLaunchMode");
    map.put(16843846, "maxRecents");
    map.put(16843847, "autoRemoveFromRecents");
    map.put(16843848, "stateListAnimator");
    map.put(16843849, "toId");
    map.put(16843850, "fromId");
    map.put(16843851, "reversible");
    map.put(16843852, "splitTrack");
    map.put(16843853, "targetName");
    map.put(16843854, "excludeName");
    map.put(16843855, "matchOrder");
    map.put(16843856, "windowDrawsSystemBarBackgrounds");
    map.put(16843857, "statusBarColor");
    map.put(16843858, "navigationBarColor");
    map.put(16843859, "contentInsetStart");
    map.put(16843860, "contentInsetEnd");
    map.put(16843861, "contentInsetLeft");
    map.put(16843862, "contentInsetRight");
    map.put(16843863, "paddingMode");
    map.put(16843864, "layout_rowWeight");
    map.put(16843865, "layout_columnWeight");
    map.put(16843866, "translateX");
    map.put(16843867, "translateY");
    map.put(16843868, "selectableItemBackgroundBorderless");
    map.put(16843869, "elegantTextHeight");
    map.put(16843870, "searchKeyphraseId");
    map.put(16843871, "searchKeyphrase");
    map.put(16843872, "searchKeyphraseSupportedLocales");
    map.put(16843873, "windowTransitionBackgroundFadeDuration");
    map.put(16843874, "overlapAnchor");
    map.put(16843875, "progressTint");
    map.put(16843876, "progressTintMode");
    map.put(16843877, "progressBackgroundTint");
    map.put(16843878, "progressBackgroundTintMode");
    map.put(16843879, "secondaryProgressTint");
    map.put(16843880, "secondaryProgressTintMode");
    map.put(16843881, "indeterminateTint");
    map.put(16843882, "indeterminateTintMode");
    map.put(16843883, "backgroundTint");
    map.put(16843884, "backgroundTintMode");
    map.put(16843885, "foregroundTint");
    map.put(16843886, "foregroundTintMode");
    map.put(16843887, "buttonTint");
    map.put(16843888, "buttonTintMode");
    map.put(16843889, "thumbTint");
    map.put(16843890, "thumbTintMode");
    map.put(16843891, "fullBackupOnly");
    map.put(16843892, "propertyXName");
    map.put(16843893, "propertyYName");
    map.put(16843894, "relinquishTaskIdentity");
    map.put(16843895, "tileModeX");
    map.put(16843896, "tileModeY");
    map.put(16843897, "actionModeShareDrawable");
    map.put(16843898, "actionModeFindDrawable");
    map.put(16843899, "actionModeWebSearchDrawable");
    map.put(16843900, "transitionVisibilityMode");
    map.put(16843901, "minimumHorizontalAngle");
    map.put(16843902, "minimumVerticalAngle");
    map.put(16843903, "maximumAngle");
    map.put(16843904, "searchViewStyle");
    map.put(16843905, "closeIcon");
    map.put(16843906, "goIcon");
    map.put(16843907, "searchIcon");
    map.put(16843908, "voiceIcon");
    map.put(16843909, "commitIcon");
    map.put(16843910, "suggestionRowLayout");
    map.put(16843911, "queryBackground");
    map.put(16843912, "submitBackground");
    map.put(16843913, "buttonBarPositiveButtonStyle");
    map.put(16843914, "buttonBarNeutralButtonStyle");
    map.put(16843915, "buttonBarNegativeButtonStyle");
    map.put(16843916, "popupElevation");
    map.put(16843917, "actionBarPopupTheme");
    map.put(16843918, "multiArch");
    map.put(16843919, "touchscreenBlocksFocus");
    map.put(16843920, "windowElevation");
    map.put(16843921, "launchTaskBehindTargetAnimation");
    map.put(16843922, "launchTaskBehindSourceAnimation");
    map.put(16843923, "restrictionType");
    map.put(16843924, "dayOfWeekBackground");
    map.put(16843925, "dayOfWeekTextAppearance");
    map.put(16843926, "headerMonthTextAppearance");
    map.put(16843927, "headerDayOfMonthTextAppearance");
    map.put(16843928, "headerYearTextAppearance");
    map.put(16843929, "yearListItemTextAppearance");
    map.put(16843930, "yearListSelectorColor");
    map.put(16843931, "calendarTextColor");
    map.put(16843932, "recognitionService");
    map.put(16843933, "timePickerStyle");
    map.put(16843934, "timePickerDialogTheme");
    map.put(16843935, "headerTimeTextAppearance");
    map.put(16843936, "headerAmPmTextAppearance");
    map.put(16843937, "numbersTextColor");
    map.put(16843938, "numbersBackgroundColor");
    map.put(16843939, "numbersSelectorColor");
    map.put(16843940, "amPmTextColor");
    map.put(16843941, "amPmBackgroundColor");
    map.put(16843942, "searchKeyphraseRecognitionFlags");
    map.put(16843943, "checkMarkTint");
    map.put(16843944, "checkMarkTintMode");
    map.put(16843945, "popupTheme");
    map.put(16843946, "toolbarStyle");
    map.put(16843947, "windowClipToOutline");
    map.put(16843948, "datePickerDialogTheme");
    map.put(16843949, "showText");
    map.put(16843950, "windowReturnTransition");
    map.put(16843951, "windowReenterTransition");
    map.put(16843952, "windowSharedElementReturnTransition");
    map.put(16843953, "windowSharedElementReenterTransition");
    map.put(16843954, "resumeWhilePausing");
    map.put(16843955, "datePickerMode");
    map.put(16843956, "timePickerMode");
    map.put(16843957, "inset");
    map.put(16843958, "letterSpacing");
    map.put(16843959, "fontFeatureSettings");
    map.put(16843960, "outlineProvider");
    map.put(16843961, "contentAgeHint");
    map.put(16843962, "country");
    map.put(16843963, "windowSharedElementsUseOverlay");
    map.put(16843964, "reparent");
    map.put(16843965, "reparentWithOverlay");
    map.put(16843966, "ambientShadowAlpha");
    map.put(16843967, "spotShadowAlpha");
    map.put(16843968, "navigationIcon");
    map.put(16843969, "navigationContentDescription");
    map.put(16843970, "fragmentExitTransition");
    map.put(16843971, "fragmentEnterTransition");
    map.put(16843972, "fragmentSharedElementEnterTransition");
    map.put(16843973, "fragmentReturnTransition");
    map.put(16843974, "fragmentSharedElementReturnTransition");
    map.put(16843975, "fragmentReenterTransition");
    map.put(16843976, "fragmentAllowEnterTransitionOverlap");
    map.put(16843977, "fragmentAllowReturnTransitionOverlap");
    map.put(16843978, "patternPathData");
    map.put(16843979, "strokeAlpha");
    map.put(16843980, "fillAlpha");
    map.put(16843981, "windowActivityTransitions");
    map.put(16843982, "colorEdgeEffect");
    map.put(16843983, "resizeClip");
    map.put(16843984, "collapseContentDescription");
    map.put(16843985, "accessibilityTraversalBefore");
    map.put(16843986, "accessibilityTraversalAfter");
    map.put(16843987, "dialogPreferredPadding");
    map.put(16843988, "searchHintIcon");
    return map;
  }

  public static Map<Integer, String> loadSystemStyles() {
    Map<Integer, String> map = new HashMap<>();
    map.put(16973824, "Animation");
    map.put(16973825, "Animation.Activity");
    map.put(16973826, "Animation.Dialog");
    map.put(16973910, "Animation.InputMethod");
    map.put(16973828, "Animation.Toast");
    map.put(16973827, "Animation.Translucent");
    map.put(16974287, "DeviceDefault.ButtonBar");
    map.put(16974288, "DeviceDefault.ButtonBar.AlertDialog");
    map.put(16974290, "DeviceDefault.Light.ButtonBar");
    map.put(16974291, "DeviceDefault.Light.ButtonBar.AlertDialog");
    map.put(16974292, "DeviceDefault.Light.SegmentedButton");
    map.put(16974289, "DeviceDefault.SegmentedButton");
    map.put(16974053, "Holo.ButtonBar");
    map.put(16974055, "Holo.ButtonBar.AlertDialog");
    map.put(16974054, "Holo.Light.ButtonBar");
    map.put(16974056, "Holo.Light.ButtonBar.AlertDialog");
    map.put(16974058, "Holo.Light.SegmentedButton");
    map.put(16974057, "Holo.SegmentedButton");
    map.put(16973879, "MediaButton");
    map.put(16973883, "MediaButton.Ffwd");
    map.put(16973881, "MediaButton.Next");
    map.put(16973885, "MediaButton.Pause");
    map.put(16973882, "MediaButton.Play");
    map.put(16973880, "MediaButton.Previous");
    map.put(16973884, "MediaButton.Rew");
    map.put(16973886, "TextAppearance");
    map.put(16974253, "TextAppearance.DeviceDefault");
    map.put(16974264, "TextAppearance.DeviceDefault.DialogWindowTitle");
    map.put(16974254, "TextAppearance.DeviceDefault.Inverse");
    map.put(16974255, "TextAppearance.DeviceDefault.Large");
    map.put(16974256, "TextAppearance.DeviceDefault.Large.Inverse");
    map.put(16974257, "TextAppearance.DeviceDefault.Medium");
    map.put(16974258, "TextAppearance.DeviceDefault.Medium.Inverse");
    map.put(16974262, "TextAppearance.DeviceDefault.SearchResult.Subtitle");
    map.put(16974261, "TextAppearance.DeviceDefault.SearchResult.Title");
    map.put(16974259, "TextAppearance.DeviceDefault.Small");
    map.put(16974260, "TextAppearance.DeviceDefault.Small.Inverse");
    map.put(16974265, "TextAppearance.DeviceDefault.Widget");
    map.put(16974286, "TextAppearance.DeviceDefault.Widget.ActionBar.Menu");
    map.put(16974279, "TextAppearance.DeviceDefault.Widget.ActionBar.Subtitle");
    map.put(16974283, "TextAppearance.DeviceDefault.Widget.ActionBar.Subtitle.Inverse");
    map.put(16974278, "TextAppearance.DeviceDefault.Widget.ActionBar.Title");
    map.put(16974282, "TextAppearance.DeviceDefault.Widget.ActionBar.Title.Inverse");
    map.put(16974281, "TextAppearance.DeviceDefault.Widget.ActionMode.Subtitle");
    map.put(16974285, "TextAppearance.DeviceDefault.Widget.ActionMode.Subtitle.Inverse");
    map.put(16974280, "TextAppearance.DeviceDefault.Widget.ActionMode.Title");
    map.put(16974284, "TextAppearance.DeviceDefault.Widget.ActionMode.Title.Inverse");
    map.put(16974266, "TextAppearance.DeviceDefault.Widget.Button");
    map.put(16974271, "TextAppearance.DeviceDefault.Widget.DropDownHint");
    map.put(16974272, "TextAppearance.DeviceDefault.Widget.DropDownItem");
    map.put(16974274, "TextAppearance.DeviceDefault.Widget.EditText");
    map.put(16974267, "TextAppearance.DeviceDefault.Widget.IconMenu.Item");
    map.put(16974275, "TextAppearance.DeviceDefault.Widget.PopupMenu");
    map.put(16974276, "TextAppearance.DeviceDefault.Widget.PopupMenu.Large");
    map.put(16974277, "TextAppearance.DeviceDefault.Widget.PopupMenu.Small");
    map.put(16974268, "TextAppearance.DeviceDefault.Widget.TabWidget");
    map.put(16974269, "TextAppearance.DeviceDefault.Widget.TextView");
    map.put(16974270, "TextAppearance.DeviceDefault.Widget.TextView.PopupMenu");
    map.put(16974273, "TextAppearance.DeviceDefault.Widget.TextView.SpinnerItem");
    map.put(16974263, "TextAppearance.DeviceDefault.WindowTitle");
    map.put(16973889, "TextAppearance.DialogWindowTitle");
    map.put(16974075, "TextAppearance.Holo");
    map.put(16974103, "TextAppearance.Holo.DialogWindowTitle");
    map.put(16974076, "TextAppearance.Holo.Inverse");
    map.put(16974077, "TextAppearance.Holo.Large");
    map.put(16974078, "TextAppearance.Holo.Large.Inverse");
    map.put(16974079, "TextAppearance.Holo.Medium");
    map.put(16974080, "TextAppearance.Holo.Medium.Inverse");
    map.put(16974084, "TextAppearance.Holo.SearchResult.Subtitle");
    map.put(16974083, "TextAppearance.Holo.SearchResult.Title");
    map.put(16974081, "TextAppearance.Holo.Small");
    map.put(16974082, "TextAppearance.Holo.Small.Inverse");
    map.put(16974085, "TextAppearance.Holo.Widget");
    map.put(16974112, "TextAppearance.Holo.Widget.ActionBar.Menu");
    map.put(16974099, "TextAppearance.Holo.Widget.ActionBar.Subtitle");
    map.put(16974109, "TextAppearance.Holo.Widget.ActionBar.Subtitle.Inverse");
    map.put(16974098, "TextAppearance.Holo.Widget.ActionBar.Title");
    map.put(16974108, "TextAppearance.Holo.Widget.ActionBar.Title.Inverse");
    map.put(16974101, "TextAppearance.Holo.Widget.ActionMode.Subtitle");
    map.put(16974111, "TextAppearance.Holo.Widget.ActionMode.Subtitle.Inverse");
    map.put(16974100, "TextAppearance.Holo.Widget.ActionMode.Title");
    map.put(16974110, "TextAppearance.Holo.Widget.ActionMode.Title.Inverse");
    map.put(16974086, "TextAppearance.Holo.Widget.Button");
    map.put(16974091, "TextAppearance.Holo.Widget.DropDownHint");
    map.put(16974092, "TextAppearance.Holo.Widget.DropDownItem");
    map.put(16974094, "TextAppearance.Holo.Widget.EditText");
    map.put(16974087, "TextAppearance.Holo.Widget.IconMenu.Item");
    map.put(16974095, "TextAppearance.Holo.Widget.PopupMenu");
    map.put(16974096, "TextAppearance.Holo.Widget.PopupMenu.Large");
    map.put(16974097, "TextAppearance.Holo.Widget.PopupMenu.Small");
    map.put(16974088, "TextAppearance.Holo.Widget.TabWidget");
    map.put(16974089, "TextAppearance.Holo.Widget.TextView");
    map.put(16974090, "TextAppearance.Holo.Widget.TextView.PopupMenu");
    map.put(16974093, "TextAppearance.Holo.Widget.TextView.SpinnerItem");
    map.put(16974102, "TextAppearance.Holo.WindowTitle");
    map.put(16973887, "TextAppearance.Inverse");
    map.put(16973890, "TextAppearance.Large");
    map.put(16973891, "TextAppearance.Large.Inverse");
    map.put(16974317, "TextAppearance.Material");
    map.put(16974320, "TextAppearance.Material.Body1");
    map.put(16974319, "TextAppearance.Material.Body2");
    map.put(16974318, "TextAppearance.Material.Button");
    map.put(16974321, "TextAppearance.Material.Caption");
    map.put(16974322, "TextAppearance.Material.DialogWindowTitle");
    map.put(16974326, "TextAppearance.Material.Display1");
    map.put(16974325, "TextAppearance.Material.Display2");
    map.put(16974324, "TextAppearance.Material.Display3");
    map.put(16974323, "TextAppearance.Material.Display4");
    map.put(16974327, "TextAppearance.Material.Headline");
    map.put(16974328, "TextAppearance.Material.Inverse");
    map.put(16974329, "TextAppearance.Material.Large");
    map.put(16974330, "TextAppearance.Material.Large.Inverse");
    map.put(16974331, "TextAppearance.Material.Medium");
    map.put(16974332, "TextAppearance.Material.Medium.Inverse");
    map.put(16974333, "TextAppearance.Material.Menu");
    map.put(16974334, "TextAppearance.Material.Notification");
    map.put(16974335, "TextAppearance.Material.Notification.Emphasis");
    map.put(16974336, "TextAppearance.Material.Notification.Info");
    map.put(16974337, "TextAppearance.Material.Notification.Line2");
    map.put(16974338, "TextAppearance.Material.Notification.Time");
    map.put(16974339, "TextAppearance.Material.Notification.Title");
    map.put(16974340, "TextAppearance.Material.SearchResult.Subtitle");
    map.put(16974341, "TextAppearance.Material.SearchResult.Title");
    map.put(16974342, "TextAppearance.Material.Small");
    map.put(16974343, "TextAppearance.Material.Small.Inverse");
    map.put(16974344, "TextAppearance.Material.Subhead");
    map.put(16974345, "TextAppearance.Material.Title");
    map.put(16974347, "TextAppearance.Material.Widget");
    map.put(16974348, "TextAppearance.Material.Widget.ActionBar.Menu");
    map.put(16974349, "TextAppearance.Material.Widget.ActionBar.Subtitle");
    map.put(16974350, "TextAppearance.Material.Widget.ActionBar.Subtitle.Inverse");
    map.put(16974351, "TextAppearance.Material.Widget.ActionBar.Title");
    map.put(16974352, "TextAppearance.Material.Widget.ActionBar.Title.Inverse");
    map.put(16974353, "TextAppearance.Material.Widget.ActionMode.Subtitle");
    map.put(16974354, "TextAppearance.Material.Widget.ActionMode.Subtitle.Inverse");
    map.put(16974355, "TextAppearance.Material.Widget.ActionMode.Title");
    map.put(16974356, "TextAppearance.Material.Widget.ActionMode.Title.Inverse");
    map.put(16974357, "TextAppearance.Material.Widget.Button");
    map.put(16974358, "TextAppearance.Material.Widget.DropDownHint");
    map.put(16974359, "TextAppearance.Material.Widget.DropDownItem");
    map.put(16974360, "TextAppearance.Material.Widget.EditText");
    map.put(16974361, "TextAppearance.Material.Widget.IconMenu.Item");
    map.put(16974362, "TextAppearance.Material.Widget.PopupMenu");
    map.put(16974363, "TextAppearance.Material.Widget.PopupMenu.Large");
    map.put(16974364, "TextAppearance.Material.Widget.PopupMenu.Small");
    map.put(16974365, "TextAppearance.Material.Widget.TabWidget");
    map.put(16974366, "TextAppearance.Material.Widget.TextView");
    map.put(16974367, "TextAppearance.Material.Widget.TextView.PopupMenu");
    map.put(16974368, "TextAppearance.Material.Widget.TextView.SpinnerItem");
    map.put(16974369, "TextAppearance.Material.Widget.Toolbar.Subtitle");
    map.put(16974370, "TextAppearance.Material.Widget.Toolbar.Title");
    map.put(16974346, "TextAppearance.Material.WindowTitle");
    map.put(16973892, "TextAppearance.Medium");
    map.put(16973893, "TextAppearance.Medium.Inverse");
    map.put(16973894, "TextAppearance.Small");
    map.put(16973895, "TextAppearance.Small.Inverse");
    map.put(16973927, "TextAppearance.StatusBar.EventContent");
    map.put(16973928, "TextAppearance.StatusBar.EventContent.Title");
    map.put(16973926, "TextAppearance.StatusBar.Icon");
    map.put(16973925, "TextAppearance.StatusBar.Title");
    map.put(16974104, "TextAppearance.SuggestionHighlight");
    map.put(16973888, "TextAppearance.Theme");
    map.put(16973896, "TextAppearance.Theme.Dialog");
    map.put(16973897, "TextAppearance.Widget");
    map.put(16973898, "TextAppearance.Widget.Button");
    map.put(16973904, "TextAppearance.Widget.DropDownHint");
    map.put(16973905, "TextAppearance.Widget.DropDownItem");
    map.put(16973900, "TextAppearance.Widget.EditText");
    map.put(16973899, "TextAppearance.Widget.IconMenu.Item");
    map.put(16973952, "TextAppearance.Widget.PopupMenu.Large");
    map.put(16973953, "TextAppearance.Widget.PopupMenu.Small");
    map.put(16973901, "TextAppearance.Widget.TabWidget");
    map.put(16973902, "TextAppearance.Widget.TextView");
    map.put(16973903, "TextAppearance.Widget.TextView.PopupMenu");
    map.put(16973906, "TextAppearance.Widget.TextView.SpinnerItem");
    map.put(16973907, "TextAppearance.WindowTitle");
    map.put(16973829, "Theme");
    map.put(16974407, "ThemeOverlay");
    map.put(16974408, "ThemeOverlay.Material");
    map.put(16974409, "ThemeOverlay.Material.ActionBar");
    map.put(16974411, "ThemeOverlay.Material.Dark");
    map.put(16974412, "ThemeOverlay.Material.Dark.ActionBar");
    map.put(16974410, "ThemeOverlay.Material.Light");
    map.put(16973832, "Theme.Black");
    map.put(16973833, "Theme.Black.NoTitleBar");
    map.put(16973834, "Theme.Black.NoTitleBar.Fullscreen");
    map.put(16974120, "Theme.DeviceDefault");
    map.put(16974126, "Theme.DeviceDefault.Dialog");
    map.put(16974134, "Theme.DeviceDefault.DialogWhenLarge");
    map.put(16974135, "Theme.DeviceDefault.DialogWhenLarge.NoActionBar");
    map.put(16974545, "Theme.DeviceDefault.Dialog.Alert");
    map.put(16974127, "Theme.DeviceDefault.Dialog.MinWidth");
    map.put(16974128, "Theme.DeviceDefault.Dialog.NoActionBar");
    map.put(16974129, "Theme.DeviceDefault.Dialog.NoActionBar.MinWidth");
    map.put(16974142, "Theme.DeviceDefault.InputMethod");
    map.put(16974123, "Theme.DeviceDefault.Light");
    map.put(16974143, "Theme.DeviceDefault.Light.DarkActionBar");
    map.put(16974130, "Theme.DeviceDefault.Light.Dialog");
    map.put(16974136, "Theme.DeviceDefault.Light.DialogWhenLarge");
    map.put(16974137, "Theme.DeviceDefault.Light.DialogWhenLarge.NoActionBar");
    map.put(16974546, "Theme.DeviceDefault.Light.Dialog.Alert");
    map.put(16974131, "Theme.DeviceDefault.Light.Dialog.MinWidth");
    map.put(16974132, "Theme.DeviceDefault.Light.Dialog.NoActionBar");
    map.put(16974133, "Theme.DeviceDefault.Light.Dialog.NoActionBar.MinWidth");
    map.put(16974124, "Theme.DeviceDefault.Light.NoActionBar");
    map.put(16974125, "Theme.DeviceDefault.Light.NoActionBar.Fullscreen");
    map.put(16974304, "Theme.DeviceDefault.Light.NoActionBar.Overscan");
    map.put(16974308, "Theme.DeviceDefault.Light.NoActionBar.TranslucentDecor");
    map.put(16974139, "Theme.DeviceDefault.Light.Panel");
    map.put(16974121, "Theme.DeviceDefault.NoActionBar");
    map.put(16974122, "Theme.DeviceDefault.NoActionBar.Fullscreen");
    map.put(16974303, "Theme.DeviceDefault.NoActionBar.Overscan");
    map.put(16974307, "Theme.DeviceDefault.NoActionBar.TranslucentDecor");
    map.put(16974138, "Theme.DeviceDefault.Panel");
    map.put(16974371, "Theme.DeviceDefault.Settings");
    map.put(16974140, "Theme.DeviceDefault.Wallpaper");
    map.put(16974141, "Theme.DeviceDefault.Wallpaper.NoTitleBar");
    map.put(16973835, "Theme.Dialog");
    map.put(16973931, "Theme.Holo");
    map.put(16973935, "Theme.Holo.Dialog");
    map.put(16973943, "Theme.Holo.DialogWhenLarge");
    map.put(16973944, "Theme.Holo.DialogWhenLarge.NoActionBar");
    map.put(16973936, "Theme.Holo.Dialog.MinWidth");
    map.put(16973937, "Theme.Holo.Dialog.NoActionBar");
    map.put(16973938, "Theme.Holo.Dialog.NoActionBar.MinWidth");
    map.put(16973951, "Theme.Holo.InputMethod");
    map.put(16973934, "Theme.Holo.Light");
    map.put(16974105, "Theme.Holo.Light.DarkActionBar");
    map.put(16973939, "Theme.Holo.Light.Dialog");
    map.put(16973945, "Theme.Holo.Light.DialogWhenLarge");
    map.put(16973946, "Theme.Holo.Light.DialogWhenLarge.NoActionBar");
    map.put(16973940, "Theme.Holo.Light.Dialog.MinWidth");
    map.put(16973941, "Theme.Holo.Light.Dialog.NoActionBar");
    map.put(16973942, "Theme.Holo.Light.Dialog.NoActionBar.MinWidth");
    map.put(16974064, "Theme.Holo.Light.NoActionBar");
    map.put(16974065, "Theme.Holo.Light.NoActionBar.Fullscreen");
    map.put(16974302, "Theme.Holo.Light.NoActionBar.Overscan");
    map.put(16974306, "Theme.Holo.Light.NoActionBar.TranslucentDecor");
    map.put(16973948, "Theme.Holo.Light.Panel");
    map.put(16973932, "Theme.Holo.NoActionBar");
    map.put(16973933, "Theme.Holo.NoActionBar.Fullscreen");
    map.put(16974301, "Theme.Holo.NoActionBar.Overscan");
    map.put(16974305, "Theme.Holo.NoActionBar.TranslucentDecor");
    map.put(16973947, "Theme.Holo.Panel");
    map.put(16973949, "Theme.Holo.Wallpaper");
    map.put(16973950, "Theme.Holo.Wallpaper.NoTitleBar");
    map.put(16973908, "Theme.InputMethod");
    map.put(16973836, "Theme.Light");
    map.put(16973837, "Theme.Light.NoTitleBar");
    map.put(16973838, "Theme.Light.NoTitleBar.Fullscreen");
    map.put(16973914, "Theme.Light.Panel");
    map.put(16973922, "Theme.Light.WallpaperSettings");
    map.put(16974372, "Theme.Material");
    map.put(16974373, "Theme.Material.Dialog");
    map.put(16974379, "Theme.Material.DialogWhenLarge");
    map.put(16974380, "Theme.Material.DialogWhenLarge.NoActionBar");
    map.put(16974374, "Theme.Material.Dialog.Alert");
    map.put(16974375, "Theme.Material.Dialog.MinWidth");
    map.put(16974376, "Theme.Material.Dialog.NoActionBar");
    map.put(16974377, "Theme.Material.Dialog.NoActionBar.MinWidth");
    map.put(16974378, "Theme.Material.Dialog.Presentation");
    map.put(16974381, "Theme.Material.InputMethod");
    map.put(16974391, "Theme.Material.Light");
    map.put(16974392, "Theme.Material.Light.DarkActionBar");
    map.put(16974393, "Theme.Material.Light.Dialog");
    map.put(16974399, "Theme.Material.Light.DialogWhenLarge");
    map.put(16974400, "Theme.Material.Light.DialogWhenLarge.NoActionBar");
    map.put(16974394, "Theme.Material.Light.Dialog.Alert");
    map.put(16974395, "Theme.Material.Light.Dialog.MinWidth");
    map.put(16974396, "Theme.Material.Light.Dialog.NoActionBar");
    map.put(16974397, "Theme.Material.Light.Dialog.NoActionBar.MinWidth");
    map.put(16974398, "Theme.Material.Light.Dialog.Presentation");
    map.put(16974401, "Theme.Material.Light.NoActionBar");
    map.put(16974402, "Theme.Material.Light.NoActionBar.Fullscreen");
    map.put(16974403, "Theme.Material.Light.NoActionBar.Overscan");
    map.put(16974404, "Theme.Material.Light.NoActionBar.TranslucentDecor");
    map.put(16974405, "Theme.Material.Light.Panel");
    map.put(16974406, "Theme.Material.Light.Voice");
    map.put(16974382, "Theme.Material.NoActionBar");
    map.put(16974383, "Theme.Material.NoActionBar.Fullscreen");
    map.put(16974384, "Theme.Material.NoActionBar.Overscan");
    map.put(16974385, "Theme.Material.NoActionBar.TranslucentDecor");
    map.put(16974386, "Theme.Material.Panel");
    map.put(16974387, "Theme.Material.Settings");
    map.put(16974388, "Theme.Material.Voice");
    map.put(16974389, "Theme.Material.Wallpaper");
    map.put(16974390, "Theme.Material.Wallpaper.NoTitleBar");
    map.put(16973909, "Theme.NoDisplay");
    map.put(16973830, "Theme.NoTitleBar");
    map.put(16973831, "Theme.NoTitleBar.Fullscreen");
    map.put(16973930, "Theme.NoTitleBar.OverlayActionModes");
    map.put(16973913, "Theme.Panel");
    map.put(16973839, "Theme.Translucent");
    map.put(16973840, "Theme.Translucent.NoTitleBar");
    map.put(16973841, "Theme.Translucent.NoTitleBar.Fullscreen");
    map.put(16973918, "Theme.Wallpaper");
    map.put(16973921, "Theme.WallpaperSettings");
    map.put(16973919, "Theme.Wallpaper.NoTitleBar");
    map.put(16973920, "Theme.Wallpaper.NoTitleBar.Fullscreen");
    map.put(16973929, "Theme.WithActionBar");
    map.put(16973842, "Widget");
    map.put(16973843, "Widget.AbsListView");
    map.put(16973954, "Widget.ActionBar");
    map.put(16974068, "Widget.ActionBar.TabBar");
    map.put(16974067, "Widget.ActionBar.TabText");
    map.put(16974066, "Widget.ActionBar.TabView");
    map.put(16973956, "Widget.ActionButton");
    map.put(16973960, "Widget.ActionButton.CloseMode");
    map.put(16973959, "Widget.ActionButton.Overflow");
    map.put(16973863, "Widget.AutoCompleteTextView");
    map.put(16973844, "Widget.Button");
    map.put(16973845, "Widget.Button.Inset");
    map.put(16973846, "Widget.Button.Small");
    map.put(16973847, "Widget.Button.Toggle");
    map.put(16974059, "Widget.CalendarView");
    map.put(16973848, "Widget.CompoundButton");
    map.put(16973849, "Widget.CompoundButton.CheckBox");
    map.put(16973850, "Widget.CompoundButton.RadioButton");
    map.put(16973851, "Widget.CompoundButton.Star");
    map.put(16974062, "Widget.DatePicker");
    map.put(16974144, "Widget.DeviceDefault");
    map.put(16974187, "Widget.DeviceDefault.ActionBar");
    map.put(16974195, "Widget.DeviceDefault.ActionBar.Solid");
    map.put(16974194, "Widget.DeviceDefault.ActionBar.TabBar");
    map.put(16974193, "Widget.DeviceDefault.ActionBar.TabText");
    map.put(16974192, "Widget.DeviceDefault.ActionBar.TabView");
    map.put(16974182, "Widget.DeviceDefault.ActionButton");
    map.put(16974186, "Widget.DeviceDefault.ActionButton.CloseMode");
    map.put(16974183, "Widget.DeviceDefault.ActionButton.Overflow");
    map.put(16974184, "Widget.DeviceDefault.ActionButton.TextButton");
    map.put(16974185, "Widget.DeviceDefault.ActionMode");
    map.put(16974151, "Widget.DeviceDefault.AutoCompleteTextView");
    map.put(16974145, "Widget.DeviceDefault.Button");
    map.put(16974188, "Widget.DeviceDefault.Button.Borderless");
    map.put(16974149, "Widget.DeviceDefault.Button.Borderless.Small");
    map.put(16974147, "Widget.DeviceDefault.Button.Inset");
    map.put(16974146, "Widget.DeviceDefault.Button.Small");
    map.put(16974148, "Widget.DeviceDefault.Button.Toggle");
    map.put(16974190, "Widget.DeviceDefault.CalendarView");
    map.put(16974299, "Widget.DeviceDefault.CheckedTextView");
    map.put(16974152, "Widget.DeviceDefault.CompoundButton.CheckBox");
    map.put(16974169, "Widget.DeviceDefault.CompoundButton.RadioButton");
    map.put(16974173, "Widget.DeviceDefault.CompoundButton.Star");
    map.put(16974191, "Widget.DeviceDefault.DatePicker");
    map.put(16974177, "Widget.DeviceDefault.DropDownItem");
    map.put(16974178, "Widget.DeviceDefault.DropDownItem.Spinner");
    map.put(16974154, "Widget.DeviceDefault.EditText");
    map.put(16974155, "Widget.DeviceDefault.ExpandableListView");
    map.put(16974313, "Widget.DeviceDefault.FastScroll");
    map.put(16974156, "Widget.DeviceDefault.GridView");
    map.put(16974171, "Widget.DeviceDefault.HorizontalScrollView");
    map.put(16974157, "Widget.DeviceDefault.ImageButton");
    map.put(16974196, "Widget.DeviceDefault.Light");
    map.put(16974243, "Widget.DeviceDefault.Light.ActionBar");
    map.put(16974247, "Widget.DeviceDefault.Light.ActionBar.Solid");
    map.put(16974248, "Widget.DeviceDefault.Light.ActionBar.Solid.Inverse");
    map.put(16974246, "Widget.DeviceDefault.Light.ActionBar.TabBar");
    map.put(16974249, "Widget.DeviceDefault.Light.ActionBar.TabBar.Inverse");
    map.put(16974245, "Widget.DeviceDefault.Light.ActionBar.TabText");
    map.put(16974251, "Widget.DeviceDefault.Light.ActionBar.TabText.Inverse");
    map.put(16974244, "Widget.DeviceDefault.Light.ActionBar.TabView");
    map.put(16974250, "Widget.DeviceDefault.Light.ActionBar.TabView.Inverse");
    map.put(16974239, "Widget.DeviceDefault.Light.ActionButton");
    map.put(16974242, "Widget.DeviceDefault.Light.ActionButton.CloseMode");
    map.put(16974240, "Widget.DeviceDefault.Light.ActionButton.Overflow");
    map.put(16974241, "Widget.DeviceDefault.Light.ActionMode");
    map.put(16974252, "Widget.DeviceDefault.Light.ActionMode.Inverse");
    map.put(16974203, "Widget.DeviceDefault.Light.AutoCompleteTextView");
    map.put(16974197, "Widget.DeviceDefault.Light.Button");
    map.put(16974201, "Widget.DeviceDefault.Light.Button.Borderless.Small");
    map.put(16974199, "Widget.DeviceDefault.Light.Button.Inset");
    map.put(16974198, "Widget.DeviceDefault.Light.Button.Small");
    map.put(16974200, "Widget.DeviceDefault.Light.Button.Toggle");
    map.put(16974238, "Widget.DeviceDefault.Light.CalendarView");
    map.put(16974300, "Widget.DeviceDefault.Light.CheckedTextView");
    map.put(16974204, "Widget.DeviceDefault.Light.CompoundButton.CheckBox");
    map.put(16974224, "Widget.DeviceDefault.Light.CompoundButton.RadioButton");
    map.put(16974228, "Widget.DeviceDefault.Light.CompoundButton.Star");
    map.put(16974232, "Widget.DeviceDefault.Light.DropDownItem");
    map.put(16974233, "Widget.DeviceDefault.Light.DropDownItem.Spinner");
    map.put(16974206, "Widget.DeviceDefault.Light.EditText");
    map.put(16974207, "Widget.DeviceDefault.Light.ExpandableListView");
    map.put(16974315, "Widget.DeviceDefault.Light.FastScroll");
    map.put(16974208, "Widget.DeviceDefault.Light.GridView");
    map.put(16974226, "Widget.DeviceDefault.Light.HorizontalScrollView");
    map.put(16974209, "Widget.DeviceDefault.Light.ImageButton");
    map.put(16974235, "Widget.DeviceDefault.Light.ListPopupWindow");
    map.put(16974210, "Widget.DeviceDefault.Light.ListView");
    map.put(16974205, "Widget.DeviceDefault.Light.ListView.DropDown");
    map.put(16974296, "Widget.DeviceDefault.Light.MediaRouteButton");
    map.put(16974236, "Widget.DeviceDefault.Light.PopupMenu");
    map.put(16974211, "Widget.DeviceDefault.Light.PopupWindow");
    map.put(16974212, "Widget.DeviceDefault.Light.ProgressBar");
    map.put(16974213, "Widget.DeviceDefault.Light.ProgressBar.Horizontal");
    map.put(16974217, "Widget.DeviceDefault.Light.ProgressBar.Inverse");
    map.put(16974216, "Widget.DeviceDefault.Light.ProgressBar.Large");
    map.put(16974219, "Widget.DeviceDefault.Light.ProgressBar.Large.Inverse");
    map.put(16974214, "Widget.DeviceDefault.Light.ProgressBar.Small");
    map.put(16974218, "Widget.DeviceDefault.Light.ProgressBar.Small.Inverse");
    map.put(16974215, "Widget.DeviceDefault.Light.ProgressBar.Small.Title");
    map.put(16974221, "Widget.DeviceDefault.Light.RatingBar");
    map.put(16974222, "Widget.DeviceDefault.Light.RatingBar.Indicator");
    map.put(16974223, "Widget.DeviceDefault.Light.RatingBar.Small");
    map.put(16974225, "Widget.DeviceDefault.Light.ScrollView");
    map.put(16974220, "Widget.DeviceDefault.Light.SeekBar");
    map.put(16974227, "Widget.DeviceDefault.Light.Spinner");
    map.put(16974316, "Widget.DeviceDefault.Light.StackView");
    map.put(16974237, "Widget.DeviceDefault.Light.Tab");
    map.put(16974229, "Widget.DeviceDefault.Light.TabWidget");
    map.put(16974202, "Widget.DeviceDefault.Light.TextView");
    map.put(16974234, "Widget.DeviceDefault.Light.TextView.SpinnerItem");
    map.put(16974230, "Widget.DeviceDefault.Light.WebTextView");
    map.put(16974231, "Widget.DeviceDefault.Light.WebView");
    map.put(16974180, "Widget.DeviceDefault.ListPopupWindow");
    map.put(16974158, "Widget.DeviceDefault.ListView");
    map.put(16974153, "Widget.DeviceDefault.ListView.DropDown");
    map.put(16974295, "Widget.DeviceDefault.MediaRouteButton");
    map.put(16974181, "Widget.DeviceDefault.PopupMenu");
    map.put(16974159, "Widget.DeviceDefault.PopupWindow");
    map.put(16974160, "Widget.DeviceDefault.ProgressBar");
    map.put(16974161, "Widget.DeviceDefault.ProgressBar.Horizontal");
    map.put(16974164, "Widget.DeviceDefault.ProgressBar.Large");
    map.put(16974162, "Widget.DeviceDefault.ProgressBar.Small");
    map.put(16974163, "Widget.DeviceDefault.ProgressBar.Small.Title");
    map.put(16974166, "Widget.DeviceDefault.RatingBar");
    map.put(16974167, "Widget.DeviceDefault.RatingBar.Indicator");
    map.put(16974168, "Widget.DeviceDefault.RatingBar.Small");
    map.put(16974170, "Widget.DeviceDefault.ScrollView");
    map.put(16974165, "Widget.DeviceDefault.SeekBar");
    map.put(16974172, "Widget.DeviceDefault.Spinner");
    map.put(16974314, "Widget.DeviceDefault.StackView");
    map.put(16974189, "Widget.DeviceDefault.Tab");
    map.put(16974174, "Widget.DeviceDefault.TabWidget");
    map.put(16974150, "Widget.DeviceDefault.TextView");
    map.put(16974179, "Widget.DeviceDefault.TextView.SpinnerItem");
    map.put(16974175, "Widget.DeviceDefault.WebTextView");
    map.put(16974176, "Widget.DeviceDefault.WebView");
    map.put(16973867, "Widget.DropDownItem");
    map.put(16973868, "Widget.DropDownItem.Spinner");
    map.put(16973859, "Widget.EditText");
    map.put(16973860, "Widget.ExpandableListView");
    map.put(16974309, "Widget.FastScroll");
    map.put(16973961, "Widget.FragmentBreadCrumbs");
    map.put(16973877, "Widget.Gallery");
    map.put(16973874, "Widget.GridView");
    map.put(16973962, "Widget.Holo");
    map.put(16974004, "Widget.Holo.ActionBar");
    map.put(16974113, "Widget.Holo.ActionBar.Solid");
    map.put(16974071, "Widget.Holo.ActionBar.TabBar");
    map.put(16974070, "Widget.Holo.ActionBar.TabText");
    map.put(16974069, "Widget.Holo.ActionBar.TabView");
    map.put(16973999, "Widget.Holo.ActionButton");
    map.put(16974003, "Widget.Holo.ActionButton.CloseMode");
    map.put(16974000, "Widget.Holo.ActionButton.Overflow");
    map.put(16974001, "Widget.Holo.ActionButton.TextButton");
    map.put(16974002, "Widget.Holo.ActionMode");
    map.put(16973968, "Widget.Holo.AutoCompleteTextView");
    map.put(16973963, "Widget.Holo.Button");
    map.put(16974050, "Widget.Holo.Button.Borderless");
    map.put(16974106, "Widget.Holo.Button.Borderless.Small");
    map.put(16973965, "Widget.Holo.Button.Inset");
    map.put(16973964, "Widget.Holo.Button.Small");
    map.put(16973966, "Widget.Holo.Button.Toggle");
    map.put(16974060, "Widget.Holo.CalendarView");
    map.put(16974297, "Widget.Holo.CheckedTextView");
    map.put(16973969, "Widget.Holo.CompoundButton.CheckBox");
    map.put(16973986, "Widget.Holo.CompoundButton.RadioButton");
    map.put(16973990, "Widget.Holo.CompoundButton.Star");
    map.put(16974063, "Widget.Holo.DatePicker");
    map.put(16973994, "Widget.Holo.DropDownItem");
    map.put(16973995, "Widget.Holo.DropDownItem.Spinner");
    map.put(16973971, "Widget.Holo.EditText");
    map.put(16973972, "Widget.Holo.ExpandableListView");
    map.put(16973973, "Widget.Holo.GridView");
    map.put(16973988, "Widget.Holo.HorizontalScrollView");
    map.put(16973974, "Widget.Holo.ImageButton");
    map.put(16974005, "Widget.Holo.Light");
    map.put(16974049, "Widget.Holo.Light.ActionBar");
    map.put(16974114, "Widget.Holo.Light.ActionBar.Solid");
    map.put(16974115, "Widget.Holo.Light.ActionBar.Solid.Inverse");
    map.put(16974074, "Widget.Holo.Light.ActionBar.TabBar");
    map.put(16974116, "Widget.Holo.Light.ActionBar.TabBar.Inverse");
    map.put(16974073, "Widget.Holo.Light.ActionBar.TabText");
    map.put(16974118, "Widget.Holo.Light.ActionBar.TabText.Inverse");
    map.put(16974072, "Widget.Holo.Light.ActionBar.TabView");
    map.put(16974117, "Widget.Holo.Light.ActionBar.TabView.Inverse");
    map.put(16974045, "Widget.Holo.Light.ActionButton");
    map.put(16974048, "Widget.Holo.Light.ActionButton.CloseMode");
    map.put(16974046, "Widget.Holo.Light.ActionButton.Overflow");
    map.put(16974047, "Widget.Holo.Light.ActionMode");
    map.put(16974119, "Widget.Holo.Light.ActionMode.Inverse");
    map.put(16974011, "Widget.Holo.Light.AutoCompleteTextView");
    map.put(16974006, "Widget.Holo.Light.Button");
    map.put(16974107, "Widget.Holo.Light.Button.Borderless.Small");
    map.put(16974008, "Widget.Holo.Light.Button.Inset");
    map.put(16974007, "Widget.Holo.Light.Button.Small");
    map.put(16974009, "Widget.Holo.Light.Button.Toggle");
    map.put(16974061, "Widget.Holo.Light.CalendarView");
    map.put(16974298, "Widget.Holo.Light.CheckedTextView");
    map.put(16974012, "Widget.Holo.Light.CompoundButton.CheckBox");
    map.put(16974032, "Widget.Holo.Light.CompoundButton.RadioButton");
    map.put(16974036, "Widget.Holo.Light.CompoundButton.Star");
    map.put(16974040, "Widget.Holo.Light.DropDownItem");
    map.put(16974041, "Widget.Holo.Light.DropDownItem.Spinner");
    map.put(16974014, "Widget.Holo.Light.EditText");
    map.put(16974015, "Widget.Holo.Light.ExpandableListView");
    map.put(16974016, "Widget.Holo.Light.GridView");
    map.put(16974034, "Widget.Holo.Light.HorizontalScrollView");
    map.put(16974017, "Widget.Holo.Light.ImageButton");
    map.put(16974043, "Widget.Holo.Light.ListPopupWindow");
    map.put(16974018, "Widget.Holo.Light.ListView");
    map.put(16974013, "Widget.Holo.Light.ListView.DropDown");
    map.put(16974294, "Widget.Holo.Light.MediaRouteButton");
    map.put(16974044, "Widget.Holo.Light.PopupMenu");
    map.put(16974019, "Widget.Holo.Light.PopupWindow");
    map.put(16974020, "Widget.Holo.Light.ProgressBar");
    map.put(16974021, "Widget.Holo.Light.ProgressBar.Horizontal");
    map.put(16974025, "Widget.Holo.Light.ProgressBar.Inverse");
    map.put(16974024, "Widget.Holo.Light.ProgressBar.Large");
    map.put(16974027, "Widget.Holo.Light.ProgressBar.Large.Inverse");
    map.put(16974022, "Widget.Holo.Light.ProgressBar.Small");
    map.put(16974026, "Widget.Holo.Light.ProgressBar.Small.Inverse");
    map.put(16974023, "Widget.Holo.Light.ProgressBar.Small.Title");
    map.put(16974029, "Widget.Holo.Light.RatingBar");
    map.put(16974030, "Widget.Holo.Light.RatingBar.Indicator");
    map.put(16974031, "Widget.Holo.Light.RatingBar.Small");
    map.put(16974033, "Widget.Holo.Light.ScrollView");
    map.put(16974028, "Widget.Holo.Light.SeekBar");
    map.put(16974035, "Widget.Holo.Light.Spinner");
    map.put(16974052, "Widget.Holo.Light.Tab");
    map.put(16974037, "Widget.Holo.Light.TabWidget");
    map.put(16974010, "Widget.Holo.Light.TextView");
    map.put(16974042, "Widget.Holo.Light.TextView.SpinnerItem");
    map.put(16974038, "Widget.Holo.Light.WebTextView");
    map.put(16974039, "Widget.Holo.Light.WebView");
    map.put(16973997, "Widget.Holo.ListPopupWindow");
    map.put(16973975, "Widget.Holo.ListView");
    map.put(16973970, "Widget.Holo.ListView.DropDown");
    map.put(16974293, "Widget.Holo.MediaRouteButton");
    map.put(16973998, "Widget.Holo.PopupMenu");
    map.put(16973976, "Widget.Holo.PopupWindow");
    map.put(16973977, "Widget.Holo.ProgressBar");
    map.put(16973978, "Widget.Holo.ProgressBar.Horizontal");
    map.put(16973981, "Widget.Holo.ProgressBar.Large");
    map.put(16973979, "Widget.Holo.ProgressBar.Small");
    map.put(16973980, "Widget.Holo.ProgressBar.Small.Title");
    map.put(16973983, "Widget.Holo.RatingBar");
    map.put(16973984, "Widget.Holo.RatingBar.Indicator");
    map.put(16973985, "Widget.Holo.RatingBar.Small");
    map.put(16973987, "Widget.Holo.ScrollView");
    map.put(16973982, "Widget.Holo.SeekBar");
    map.put(16973989, "Widget.Holo.Spinner");
    map.put(16974051, "Widget.Holo.Tab");
    map.put(16973991, "Widget.Holo.TabWidget");
    map.put(16973967, "Widget.Holo.TextView");
    map.put(16973996, "Widget.Holo.TextView.SpinnerItem");
    map.put(16973992, "Widget.Holo.WebTextView");
    map.put(16973993, "Widget.Holo.WebView");
    map.put(16973862, "Widget.ImageButton");
    map.put(16973861, "Widget.ImageWell");
    map.put(16973911, "Widget.KeyboardView");
    map.put(16973957, "Widget.ListPopupWindow");
    map.put(16973870, "Widget.ListView");
    map.put(16973872, "Widget.ListView.DropDown");
    map.put(16973873, "Widget.ListView.Menu");
    map.put(16973871, "Widget.ListView.White");
    map.put(16974413, "Widget.Material");
    map.put(16974414, "Widget.Material.ActionBar");
    map.put(16974415, "Widget.Material.ActionBar.Solid");
    map.put(16974416, "Widget.Material.ActionBar.TabBar");
    map.put(16974417, "Widget.Material.ActionBar.TabText");
    map.put(16974418, "Widget.Material.ActionBar.TabView");
    map.put(16974419, "Widget.Material.ActionButton");
    map.put(16974420, "Widget.Material.ActionButton.CloseMode");
    map.put(16974421, "Widget.Material.ActionButton.Overflow");
    map.put(16974422, "Widget.Material.ActionMode");
    map.put(16974423, "Widget.Material.AutoCompleteTextView");
    map.put(16974424, "Widget.Material.Button");
    map.put(16974431, "Widget.Material.ButtonBar");
    map.put(16974432, "Widget.Material.ButtonBar.AlertDialog");
    map.put(16974425, "Widget.Material.Button.Borderless");
    map.put(16974426, "Widget.Material.Button.Borderless.Colored");
    map.put(16974427, "Widget.Material.Button.Borderless.Small");
    map.put(16974428, "Widget.Material.Button.Inset");
    map.put(16974429, "Widget.Material.Button.Small");
    map.put(16974430, "Widget.Material.Button.Toggle");
    map.put(16974433, "Widget.Material.CalendarView");
    map.put(16974434, "Widget.Material.CheckedTextView");
    map.put(16974435, "Widget.Material.CompoundButton.CheckBox");
    map.put(16974436, "Widget.Material.CompoundButton.RadioButton");
    map.put(16974437, "Widget.Material.CompoundButton.Star");
    map.put(16974438, "Widget.Material.DatePicker");
    map.put(16974439, "Widget.Material.DropDownItem");
    map.put(16974440, "Widget.Material.DropDownItem.Spinner");
    map.put(16974441, "Widget.Material.EditText");
    map.put(16974442, "Widget.Material.ExpandableListView");
    map.put(16974443, "Widget.Material.FastScroll");
    map.put(16974444, "Widget.Material.GridView");
    map.put(16974445, "Widget.Material.HorizontalScrollView");
    map.put(16974446, "Widget.Material.ImageButton");
    map.put(16974478, "Widget.Material.Light");
    map.put(16974479, "Widget.Material.Light.ActionBar");
    map.put(16974480, "Widget.Material.Light.ActionBar.Solid");
    map.put(16974481, "Widget.Material.Light.ActionBar.TabBar");
    map.put(16974482, "Widget.Material.Light.ActionBar.TabText");
    map.put(16974483, "Widget.Material.Light.ActionBar.TabView");
    map.put(16974484, "Widget.Material.Light.ActionButton");
    map.put(16974485, "Widget.Material.Light.ActionButton.CloseMode");
    map.put(16974486, "Widget.Material.Light.ActionButton.Overflow");
    map.put(16974487, "Widget.Material.Light.ActionMode");
    map.put(16974488, "Widget.Material.Light.AutoCompleteTextView");
    map.put(16974489, "Widget.Material.Light.Button");
    map.put(16974496, "Widget.Material.Light.ButtonBar");
    map.put(16974497, "Widget.Material.Light.ButtonBar.AlertDialog");
    map.put(16974490, "Widget.Material.Light.Button.Borderless");
    map.put(16974491, "Widget.Material.Light.Button.Borderless.Colored");
    map.put(16974492, "Widget.Material.Light.Button.Borderless.Small");
    map.put(16974493, "Widget.Material.Light.Button.Inset");
    map.put(16974494, "Widget.Material.Light.Button.Small");
    map.put(16974495, "Widget.Material.Light.Button.Toggle");
    map.put(16974498, "Widget.Material.Light.CalendarView");
    map.put(16974499, "Widget.Material.Light.CheckedTextView");
    map.put(16974500, "Widget.Material.Light.CompoundButton.CheckBox");
    map.put(16974501, "Widget.Material.Light.CompoundButton.RadioButton");
    map.put(16974502, "Widget.Material.Light.CompoundButton.Star");
    map.put(16974503, "Widget.Material.Light.DatePicker");
    map.put(16974504, "Widget.Material.Light.DropDownItem");
    map.put(16974505, "Widget.Material.Light.DropDownItem.Spinner");
    map.put(16974506, "Widget.Material.Light.EditText");
    map.put(16974507, "Widget.Material.Light.ExpandableListView");
    map.put(16974508, "Widget.Material.Light.FastScroll");
    map.put(16974509, "Widget.Material.Light.GridView");
    map.put(16974510, "Widget.Material.Light.HorizontalScrollView");
    map.put(16974511, "Widget.Material.Light.ImageButton");
    map.put(16974512, "Widget.Material.Light.ListPopupWindow");
    map.put(16974513, "Widget.Material.Light.ListView");
    map.put(16974514, "Widget.Material.Light.ListView.DropDown");
    map.put(16974515, "Widget.Material.Light.MediaRouteButton");
    map.put(16974516, "Widget.Material.Light.PopupMenu");
    map.put(16974517, "Widget.Material.Light.PopupMenu.Overflow");
    map.put(16974518, "Widget.Material.Light.PopupWindow");
    map.put(16974519, "Widget.Material.Light.ProgressBar");
    map.put(16974520, "Widget.Material.Light.ProgressBar.Horizontal");
    map.put(16974521, "Widget.Material.Light.ProgressBar.Inverse");
    map.put(16974522, "Widget.Material.Light.ProgressBar.Large");
    map.put(16974523, "Widget.Material.Light.ProgressBar.Large.Inverse");
    map.put(16974524, "Widget.Material.Light.ProgressBar.Small");
    map.put(16974525, "Widget.Material.Light.ProgressBar.Small.Inverse");
    map.put(16974526, "Widget.Material.Light.ProgressBar.Small.Title");
    map.put(16974527, "Widget.Material.Light.RatingBar");
    map.put(16974528, "Widget.Material.Light.RatingBar.Indicator");
    map.put(16974529, "Widget.Material.Light.RatingBar.Small");
    map.put(16974530, "Widget.Material.Light.ScrollView");
    map.put(16974531, "Widget.Material.Light.SearchView");
    map.put(16974532, "Widget.Material.Light.SeekBar");
    map.put(16974533, "Widget.Material.Light.SegmentedButton");
    map.put(16974535, "Widget.Material.Light.Spinner");
    map.put(16974536, "Widget.Material.Light.Spinner.Underlined");
    map.put(16974534, "Widget.Material.Light.StackView");
    map.put(16974537, "Widget.Material.Light.Tab");
    map.put(16974538, "Widget.Material.Light.TabWidget");
    map.put(16974539, "Widget.Material.Light.TextView");
    map.put(16974540, "Widget.Material.Light.TextView.SpinnerItem");
    map.put(16974541, "Widget.Material.Light.TimePicker");
    map.put(16974542, "Widget.Material.Light.WebTextView");
    map.put(16974543, "Widget.Material.Light.WebView");
    map.put(16974447, "Widget.Material.ListPopupWindow");
    map.put(16974448, "Widget.Material.ListView");
    map.put(16974449, "Widget.Material.ListView.DropDown");
    map.put(16974450, "Widget.Material.MediaRouteButton");
    map.put(16974451, "Widget.Material.PopupMenu");
    map.put(16974452, "Widget.Material.PopupMenu.Overflow");
    map.put(16974453, "Widget.Material.PopupWindow");
    map.put(16974454, "Widget.Material.ProgressBar");
    map.put(16974455, "Widget.Material.ProgressBar.Horizontal");
    map.put(16974456, "Widget.Material.ProgressBar.Large");
    map.put(16974457, "Widget.Material.ProgressBar.Small");
    map.put(16974458, "Widget.Material.ProgressBar.Small.Title");
    map.put(16974459, "Widget.Material.RatingBar");
    map.put(16974460, "Widget.Material.RatingBar.Indicator");
    map.put(16974461, "Widget.Material.RatingBar.Small");
    map.put(16974462, "Widget.Material.ScrollView");
    map.put(16974463, "Widget.Material.SearchView");
    map.put(16974464, "Widget.Material.SeekBar");
    map.put(16974465, "Widget.Material.SegmentedButton");
    map.put(16974467, "Widget.Material.Spinner");
    map.put(16974468, "Widget.Material.Spinner.Underlined");
    map.put(16974466, "Widget.Material.StackView");
    map.put(16974469, "Widget.Material.Tab");
    map.put(16974470, "Widget.Material.TabWidget");
    map.put(16974471, "Widget.Material.TextView");
    map.put(16974472, "Widget.Material.TextView.SpinnerItem");
    map.put(16974473, "Widget.Material.TimePicker");
    map.put(16974474, "Widget.Material.Toolbar");
    map.put(16974475, "Widget.Material.Toolbar.Button.Navigation");
    map.put(16974476, "Widget.Material.WebTextView");
    map.put(16974477, "Widget.Material.WebView");
    map.put(16973958, "Widget.PopupMenu");
    map.put(16973878, "Widget.PopupWindow");
    map.put(16973852, "Widget.ProgressBar");
    map.put(16973855, "Widget.ProgressBar.Horizontal");
    map.put(16973915, "Widget.ProgressBar.Inverse");
    map.put(16973853, "Widget.ProgressBar.Large");
    map.put(16973916, "Widget.ProgressBar.Large.Inverse");
    map.put(16973854, "Widget.ProgressBar.Small");
    map.put(16973917, "Widget.ProgressBar.Small.Inverse");
    map.put(16973857, "Widget.RatingBar");
    map.put(16973869, "Widget.ScrollView");
    map.put(16973856, "Widget.SeekBar");
    map.put(16973864, "Widget.Spinner");
    map.put(16973955, "Widget.Spinner.DropDown");
    map.put(16974310, "Widget.StackView");
    map.put(16973876, "Widget.TabWidget");
    map.put(16973858, "Widget.TextView");
    map.put(16973865, "Widget.TextView.PopupMenu");
    map.put(16973866, "Widget.TextView.SpinnerItem");
    map.put(16974311, "Widget.Toolbar");
    map.put(16974312, "Widget.Toolbar.Button.Navigation");
    return map;
  }

}
