/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.apkparser;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.jaredrummler.apkparser.exception.ParserException;
import com.jaredrummler.apkparser.model.AndroidManifest;
import com.jaredrummler.apkparser.model.ApkMeta;
import com.jaredrummler.apkparser.model.CertificateMeta;
import com.jaredrummler.apkparser.model.DexClass;
import com.jaredrummler.apkparser.model.DexInfo;
import com.jaredrummler.apkparser.model.Icon;
import com.jaredrummler.apkparser.parser.ApkMetaTranslator;
import com.jaredrummler.apkparser.parser.BinaryXmlParser;
import com.jaredrummler.apkparser.parser.CertificateParser;
import com.jaredrummler.apkparser.parser.CompositeXmlStreamer;
import com.jaredrummler.apkparser.parser.DexParser;
import com.jaredrummler.apkparser.parser.ResourceTableParser;
import com.jaredrummler.apkparser.parser.XmlStreamer;
import com.jaredrummler.apkparser.parser.XmlTranslator;
import com.jaredrummler.apkparser.struct.dex.DexHeader;
import com.jaredrummler.apkparser.struct.resource.ResourceTable;
import com.jaredrummler.apkparser.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.security.cert.CertificateException;

public class ApkParser
implements Closeable {
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private List<DexInfo> dexInfos;
    private DexInfo dex;
    private ResourceTable resourceTable;
    private AndroidManifest androidManifest;
    private String manifestXml;
    private ApkMeta apkMeta;
    private Set<Locale> locales;
    private CertificateMeta certificate;
    private final ZipFile zipFile;
    private File apkFile;
    private Locale preferredLocale = DEFAULT_LOCALE;

    public static ApkParser create(PackageManager pm, String packageName) throws PackageManager.NameNotFoundException {
        return new ApkParser(new File(pm.getApplicationInfo((String)packageName, (int)0).sourceDir));
    }

    public static ApkParser create(PackageInfo packageInfo) {
        return new ApkParser(new File(packageInfo.applicationInfo.sourceDir));
    }

    public static ApkParser create(ApplicationInfo applicationInfo) {
        return new ApkParser(new File(applicationInfo.sourceDir));
    }

    public static ApkParser create(String path) {
        return new ApkParser(new File(path));
    }

    public static ApkParser create(File file) {
        return new ApkParser(file);
    }

    private ApkParser(File file) throws InvalidApkException {
        try {
            this.apkFile = file;
            this.zipFile = new ZipFile(file);
        }
        catch (IOException e) {
            throw new InvalidApkException(String.format("Invalid APK: %s", file.getAbsolutePath()), e);
        }
    }

    public String getManifestXml() throws IOException {
        if (this.manifestXml == null) {
            this.parseManifestXml();
        }
        return this.manifestXml;
    }

    public AndroidManifest getAndroidManifest() throws IOException, ParseException {
        if (this.androidManifest == null) {
            this.androidManifest = new AndroidManifest(this.getApkMeta(), this.manifestXml);
        }
        return this.androidManifest;
    }

    public ApkMeta getApkMeta() throws IOException {
        if (this.apkMeta == null) {
            this.parseApkMeta();
        }
        return this.apkMeta;
    }

    public Set<Locale> getLocales() throws IOException {
        if (this.locales == null) {
            this.parseResourceTable();
        }
        return this.locales;
    }

    public CertificateMeta getCertificateMeta() throws IOException, CertificateException {
        if (this.certificate == null) {
            this.parseCertificate();
        }
        return this.certificate;
    }

    private void parseCertificate() throws IOException, CertificateException {
        ZipEntry entry = null;
        Enumeration<? extends ZipEntry> enu = this.zipFile.entries();
        while (enu.hasMoreElements()) {
            ZipEntry ne = enu.nextElement();
            if (ne.isDirectory() || !ne.getName().toUpperCase().endsWith(".RSA") && !ne.getName().toUpperCase().endsWith(".DSA")) continue;
            entry = ne;
            break;
        }
        if (entry == null) {
            throw new ParserException("ApkParser certificate not found");
        }
        InputStream in = this.zipFile.getInputStream(entry);
        CertificateParser parser = new CertificateParser(in);
        this.certificate = parser.parse();
        in.close();
    }

    private void parseApkMeta() throws IOException {
        if (this.manifestXml == null) {
            this.parseManifestXml();
        }
    }

    private void parseManifestXml() throws IOException {
        XmlTranslator xmlTranslator = new XmlTranslator();
        ApkMetaTranslator translator = new ApkMetaTranslator();
        CompositeXmlStreamer xmlStreamer = new CompositeXmlStreamer(xmlTranslator, translator);
        this.transBinaryXml("AndroidManifest.xml", xmlStreamer);
        this.manifestXml = xmlTranslator.getXml();
        if (this.manifestXml == null) {
            throw new ParserException("manifest xml not exists");
        }
        this.apkMeta = translator.getApkMeta();
    }

    public String transBinaryXml(String path) throws IOException {
        ZipEntry entry = Utils.getEntry(this.zipFile, path);
        if (entry == null) {
            return null;
        }
        if (this.resourceTable == null) {
            this.parseResourceTable();
        }
        try {
            XmlTranslator xmlTranslator = new XmlTranslator();
            this.transBinaryXml(path, xmlTranslator);
            return xmlTranslator.getXml();
        }
        catch (ParserException e) {
            int length;
            InputStream in = this.zipFile.getInputStream(entry);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
            byte[] buffer = new byte[8192];
            while ((length = in.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            in.close();
            return baos.toString("UTF-8");
        }
    }

    public Icon getIconFile() throws IOException {
        ApkMeta apkMeta = this.getApkMeta();
        if (apkMeta.icon == null) {
            return null;
        }
        return new Icon(apkMeta.icon, this.getFileData(apkMeta.icon));
    }

    private void transBinaryXml(String path, XmlStreamer xmlStreamer) throws IOException {
        ZipEntry entry = Utils.getEntry(this.zipFile, path);
        if (entry == null) {
            return;
        }
        if (this.resourceTable == null) {
            this.parseResourceTable();
        }
        InputStream in = this.zipFile.getInputStream(entry);
        ByteBuffer buffer = ByteBuffer.wrap(Utils.toByteArray(in));
        BinaryXmlParser binaryXmlParser = new BinaryXmlParser(buffer, this.resourceTable);
        binaryXmlParser.setLocale(this.preferredLocale);
        binaryXmlParser.setXmlStreamer(xmlStreamer);
        binaryXmlParser.parse();
    }

    public List<DexInfo> getDexInfos() throws IOException {
        if (this.dexInfos == null) {
            this.parseDexFiles();
        }
        return this.dexInfos;
    }

    public DexInfo getDexInfo() throws IOException {
        if (this.dex == null) {
            this.dex = this.parseDexFile();
        }
        return this.dex;
    }

    @Deprecated
    public DexClass[] getDexClasses() throws IOException {
        if (this.dex == null) {
            this.dex = this.parseDexFile();
        }
        return this.dex.classes;
    }

    @Deprecated
    public DexHeader getDexHeader() throws IOException {
        if (this.dex == null) {
            this.dex = this.parseDexFile();
        }
        return this.dex.header;
    }

    private void parseDexFiles() throws IOException {
        String path;
        ZipEntry entry;
        this.dexInfos = new ArrayList<DexInfo>();
        this.dexInfos.add(this.getDexInfo());
        for (int i = 2; i < 1000 && (entry = Utils.getEntry(this.zipFile, path = String.format("classes%d.dex", i))) != null; ++i) {
            InputStream in = this.zipFile.getInputStream(entry);
            ByteBuffer buffer = ByteBuffer.wrap(Utils.toByteArray(in));
            DexParser dexParser = new DexParser(buffer);
            this.dexInfos.add(dexParser.parse());
        }
    }

    private DexInfo parseDexFile() throws IOException {
        ZipEntry entry = Utils.getEntry(this.zipFile, "classes.dex");
        if (entry == null) {
            throw new ParserException("classes.dex not found");
        }
        InputStream in = this.zipFile.getInputStream(entry);
        ByteBuffer buffer = ByteBuffer.wrap(Utils.toByteArray(in));
        DexParser dexParser = new DexParser(buffer);
        return dexParser.parse();
    }

    public byte[] getFileData(String path) throws IOException {
        ZipEntry entry = Utils.getEntry(this.zipFile, path);
        if (entry == null) {
            return null;
        }
        InputStream inputStream = this.zipFile.getInputStream(entry);
        return Utils.toByteArray(inputStream);
    }

    public int verifyApk() throws IOException {
        ZipEntry entry = Utils.getEntry(this.zipFile, "META-INF/MANIFEST.MF");
        if (entry == null) {
            return 0;
        }
        JarFile jarFile = new JarFile(this.apkFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        byte[] buffer = new byte[8192];
        while (entries.hasMoreElements()) {
            JarEntry e = entries.nextElement();
            if (e.isDirectory()) continue;
            try {
                int count;
                InputStream in = jarFile.getInputStream(e);
                while ((count = in.read(buffer, 0, buffer.length)) != -1) {
                }
                in.close();
            }
            catch (SecurityException se) {
                return 1;
            }
        }
        return 2;
    }

    private void parseResourceTable() throws IOException {
        ZipEntry entry = Utils.getEntry(this.zipFile, "resources.arsc");
        if (entry == null) {
            this.resourceTable = new ResourceTable();
            this.locales = Collections.emptySet();
            return;
        }
        this.resourceTable = new ResourceTable();
        this.locales = Collections.emptySet();
        InputStream in = this.zipFile.getInputStream(entry);
        ByteBuffer buffer = ByteBuffer.wrap(Utils.toByteArray(in));
        ResourceTableParser resourceTableParser = new ResourceTableParser(buffer);
        resourceTableParser.parse();
        this.resourceTable = resourceTableParser.getResourceTable();
        this.locales = resourceTableParser.getLocales();
    }

    @Override
    public void close() {
        this.resourceTable = null;
        this.certificate = null;
        try {
            this.zipFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Locale getPreferredLocale() {
        return this.preferredLocale;
    }

    public void setPreferredLocale(Locale locale) {
        if (!Utils.equals(this.preferredLocale, locale)) {
            this.preferredLocale = locale;
            this.manifestXml = null;
            this.apkMeta = null;
        }
    }

    public static class InvalidApkException
    extends RuntimeException {
        public InvalidApkException(String detailMessage, Throwable throwable) {
            super(detailMessage, throwable);
        }
    }

    public static final class ApkSignStatus {
        public static final int NOT_SIGNED = 0;
        public static final int INCORRECT = 1;
        public static final int SIGNED = 2;
    }
}

