/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.apkparser.model;

import com.jaredrummler.apkparser.exception.ParserException;
import com.jaredrummler.apkparser.model.AndroidComponent;
import com.jaredrummler.apkparser.model.ApkMeta;
import com.jaredrummler.apkparser.model.IntentFilter;
import com.jaredrummler.apkparser.utils.XmlUtils;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AndroidManifest {
    public final List<AndroidComponent> activities = new ArrayList<AndroidComponent>();
    public final List<AndroidComponent> receivers = new ArrayList<AndroidComponent>();
    public final List<AndroidComponent> services = new ArrayList<AndroidComponent>();
    public final List<AndroidComponent> providers = new ArrayList<AndroidComponent>();
    public final ApkMeta apkMeta;
    public final String xml;

    private static AndroidComponent getAndroidComponent(Node node, int type) {
        AndroidComponent.Builder builder = AndroidComponent.newAndroidComponent(type);
        NamedNodeMap attributes = node.getAttributes();
        builder.name(XmlUtils.getAttribute(attributes, "android:name"));
        builder.exported(XmlUtils.getBoolAttribute(attributes, "android:exported", false));
        builder.process(XmlUtils.getAttribute(attributes, "android:process"));
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (!childName.equals("intent-filter")) continue;
            IntentFilter intentFilter = AndroidManifest.getIntentFilter(child);
            builder.addIntentFilter(intentFilter);
        }
        return builder.build();
    }

    private static IntentFilter getIntentFilter(Node intentNode) {
        NodeList intentChildren = intentNode.getChildNodes();
        IntentFilter intentFilter = new IntentFilter();
        for (int j = 0; j < intentChildren.getLength(); ++j) {
            Node intentChild = intentChildren.item(j);
            String intentChildName = intentChild.getNodeName();
            NamedNodeMap intentChildAttributes = intentChild.getAttributes();
            if (intentChildName.equals("action")) {
                intentFilter.actions.add(XmlUtils.getAttribute(intentChildAttributes, "android:name"));
                continue;
            }
            if (intentChildName.equals("category")) {
                intentFilter.categories.add(XmlUtils.getAttribute(intentChildAttributes, "android:name"));
                continue;
            }
            if (!intentChildName.equals("data")) continue;
            String scheme = XmlUtils.getAttribute(intentChildAttributes, "android:scheme");
            String host = XmlUtils.getAttribute(intentChildAttributes, "android:host");
            String port = XmlUtils.getAttribute(intentChildAttributes, "android:port");
            String path = XmlUtils.getAttribute(intentChildAttributes, "android:path");
            String pathPattern = XmlUtils.getAttribute(intentChildAttributes, "android:pathPattern");
            String pathPrefix = XmlUtils.getAttribute(intentChildAttributes, "android:pathPrefix");
            String mimeType = XmlUtils.getAttribute(intentChildAttributes, "android:mimeType");
            String type = XmlUtils.getAttribute(intentChildAttributes, "android:type");
            intentFilter.dataList.add(new IntentFilter.IntentData(scheme, host, port, path, pathPattern, pathPrefix, mimeType, type));
        }
        return intentFilter;
    }

    public AndroidManifest(ApkMeta apkMeta, String xml) throws ParserException {
        this.apkMeta = apkMeta;
        this.xml = xml;
        this.parse();
    }

    public List<AndroidComponent> getComponents() {
        ArrayList<AndroidComponent> components = new ArrayList<AndroidComponent>();
        components.addAll(this.activities);
        components.addAll(this.services);
        components.addAll(this.receivers);
        components.addAll(this.providers);
        return components;
    }

    private void parse() throws ParserException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(this.xml.getBytes("UTF-8")));
            Node manifestNode = document.getElementsByTagName("manifest").item(0);
            NodeList nodes = manifestNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (!nodeName.equals("application")) continue;
                NodeList children = node.getChildNodes();
                block16: for (int j = 0; j < children.getLength(); ++j) {
                    String childName;
                    Node child = children.item(j);
                    switch (childName = child.getNodeName()) {
                        case "service": {
                            this.services.add(AndroidManifest.getAndroidComponent(child, 2));
                            continue block16;
                        }
                        case "activity": 
                        case "activity-alias": {
                            this.activities.add(AndroidManifest.getAndroidComponent(child, 1));
                            continue block16;
                        }
                        case "receiver": {
                            this.receivers.add(AndroidManifest.getAndroidComponent(child, 4));
                            continue block16;
                        }
                        case "provider": {
                            this.providers.add(AndroidManifest.getAndroidComponent(child, 3));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ParserException("Error parsing AndroidManifest.xml", e);
        }
    }
}

