/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.apkparser.model;

import com.jaredrummler.apkparser.model.GlEsVersion;
import com.jaredrummler.apkparser.model.Permission;
import com.jaredrummler.apkparser.model.UseFeature;
import java.util.ArrayList;
import java.util.List;

public class ApkMeta {
    public final String packageName;
    public final String label;
    public final String icon;
    public final String versionName;
    public final Long versionCode;
    public final String installLocation;
    public final String minSdkVersion;
    public final String targetSdkVersion;
    public final String maxSdkVersion;
    public final GlEsVersion glEsVersion;
    public final boolean anyDensity;
    public final boolean smallScreens;
    public final boolean normalScreens;
    public final boolean largeScreens;
    public final List<String> usesPermissions;
    public final List<UseFeature> usesFeatures;
    public final List<Permission> permissions;

    public static Builder newApkMeta() {
        return new Builder();
    }

    private ApkMeta(Builder builder) {
        this.packageName = builder.packageName;
        this.label = builder.label;
        this.icon = builder.icon;
        this.versionName = builder.versionName;
        this.versionCode = builder.versionCode;
        this.installLocation = builder.installLocation;
        this.minSdkVersion = builder.minSdkVersion;
        this.targetSdkVersion = builder.targetSdkVersion;
        this.maxSdkVersion = builder.maxSdkVersion;
        this.glEsVersion = builder.glEsVersion;
        this.anyDensity = builder.anyDensity;
        this.smallScreens = builder.smallScreens;
        this.normalScreens = builder.normalScreens;
        this.largeScreens = builder.largeScreens;
        this.usesPermissions = builder.usesPermissions;
        this.usesFeatures = builder.usesFeatures;
        this.permissions = builder.permissions;
    }

    public static final class Builder {
        private String packageName;
        private String label;
        private String icon;
        private String versionName;
        private Long versionCode;
        private String installLocation;
        private String minSdkVersion;
        private String targetSdkVersion;
        private String maxSdkVersion;
        private GlEsVersion glEsVersion;
        private boolean anyDensity;
        private boolean smallScreens;
        private boolean normalScreens;
        private boolean largeScreens;
        private List<String> usesPermissions = new ArrayList<String>();
        private List<UseFeature> usesFeatures = new ArrayList<UseFeature>();
        private List<Permission> permissions = new ArrayList<Permission>();

        private Builder() {
        }

        public ApkMeta build() {
            return new ApkMeta(this);
        }

        public Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder icon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public Builder versionCode(Long versionCode) {
            this.versionCode = versionCode;
            return this;
        }

        public Builder installLocation(String installLocation) {
            this.installLocation = installLocation;
            return this;
        }

        public Builder minSdkVersion(String minSdkVersion) {
            this.minSdkVersion = minSdkVersion;
            return this;
        }

        public Builder targetSdkVersion(String targetSdkVersion) {
            this.targetSdkVersion = targetSdkVersion;
            return this;
        }

        public Builder maxSdkVersion(String maxSdkVersion) {
            this.maxSdkVersion = maxSdkVersion;
            return this;
        }

        public Builder glEsVersion(GlEsVersion glEsVersion) {
            this.glEsVersion = glEsVersion;
            return this;
        }

        public Builder anyDensity(boolean anyDensity) {
            this.anyDensity = anyDensity;
            return this;
        }

        public Builder smallScreens(boolean smallScreens) {
            this.smallScreens = smallScreens;
            return this;
        }

        public Builder normalScreens(boolean normalScreens) {
            this.normalScreens = normalScreens;
            return this;
        }

        public Builder largeScreens(boolean largeScreens) {
            this.largeScreens = largeScreens;
            return this;
        }

        public Builder addUsesPermission(String permission) {
            this.usesPermissions.add(permission);
            return this;
        }

        public Builder addUseFeatures(UseFeature feature) {
            this.usesFeatures.add(feature);
            return this;
        }

        public Builder addPermission(Permission permissions) {
            this.permissions.add(permissions);
            return this;
        }
    }
}

