/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.apkparser.model;

import java.util.Date;

public class CertificateMeta {
    public final String signAlgorithm;
    public final String signAlgorithmOID;
    public final Date startDate;
    public final Date endDate;
    public final byte[] data;
    public final String certBase64Md5;
    public final String certMd5;

    public static Builder newCertificateMeta() {
        return new Builder();
    }

    private CertificateMeta(Builder builder) {
        this.signAlgorithm = builder.signAlgorithm;
        this.signAlgorithmOID = builder.signAlgorithmOID;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.data = builder.data;
        this.certBase64Md5 = builder.certBase64Md5;
        this.certMd5 = builder.certMd5;
    }

    public String toString() {
        return "signAlgorithm:\t" + this.signAlgorithm + '\n' + "certBase64Md5:\t" + this.certBase64Md5 + '\n' + "certMd5:\t" + this.certMd5;
    }

    public static final class Builder {
        private String signAlgorithm;
        private String signAlgorithmOID;
        private Date startDate;
        private Date endDate;
        private byte[] data;
        private String certBase64Md5;
        private String certMd5;

        private Builder() {
        }

        public CertificateMeta build() {
            return new CertificateMeta(this);
        }

        public Builder signAlgorithm(String signAlgorithm) {
            this.signAlgorithm = signAlgorithm;
            return this;
        }

        public Builder signAlgorithmOID(String signAlgorithmOID) {
            this.signAlgorithmOID = signAlgorithmOID;
            return this;
        }

        public Builder startDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(Date endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public Builder certBase64Md5(String certBase64Md5) {
            this.certBase64Md5 = certBase64Md5;
            return this;
        }

        public Builder certMd5(String certMd5) {
            this.certMd5 = certMd5;
            return this;
        }
    }
}

