/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.apkparser.model;

public class DexClass {
    public final String classType;
    public final String superClass;
    public final int accessFlags;

    public static Builder newDexClass() {
        return new Builder();
    }

    private DexClass(Builder builder) {
        this.classType = builder.classType;
        this.superClass = builder.superClass;
        this.accessFlags = builder.accessFlags;
    }

    public String getPackageName() {
        String packageName = this.classType;
        if (packageName.length() > 0 && packageName.charAt(0) == 'L') {
            packageName = packageName.substring(1);
        }
        if (packageName.length() > 0) {
            int idx = this.classType.lastIndexOf(47);
            if (idx > 0) {
                packageName = packageName.substring(0, this.classType.lastIndexOf(47) - 1);
            } else if (packageName.charAt(packageName.length() - 1) == ';') {
                packageName = packageName.substring(0, packageName.length() - 1);
            }
        }
        return packageName.replace('/', '.');
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isEnum() {
        return (this.accessFlags & 0x4000) != 0;
    }

    public boolean isAnnotation() {
        return (this.accessFlags & 0x2000) != 0;
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public boolean isProtected() {
        return (this.accessFlags & 4) != 0;
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public String toString() {
        return this.classType;
    }

    public static final class Builder {
        private String classType;
        private String superClass;
        private int accessFlags;

        private Builder() {
        }

        public DexClass build() {
            return new DexClass(this);
        }

        public Builder classType(String classType) {
            this.classType = classType;
            return this;
        }

        public Builder superClass(String superClass) {
            this.superClass = superClass;
            return this;
        }

        public Builder accessFlags(int accessFlags) {
            this.accessFlags = accessFlags;
            return this;
        }
    }
}

