/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.apkparser.parser;

import com.jaredrummler.apkparser.model.ApkMeta;
import com.jaredrummler.apkparser.model.GlEsVersion;
import com.jaredrummler.apkparser.model.Permission;
import com.jaredrummler.apkparser.model.UseFeature;
import com.jaredrummler.apkparser.parser.XmlStreamer;
import com.jaredrummler.apkparser.struct.xml.Attributes;
import com.jaredrummler.apkparser.struct.xml.XmlCData;
import com.jaredrummler.apkparser.struct.xml.XmlNamespaceEndTag;
import com.jaredrummler.apkparser.struct.xml.XmlNamespaceStartTag;
import com.jaredrummler.apkparser.struct.xml.XmlNodeEndTag;
import com.jaredrummler.apkparser.struct.xml.XmlNodeStartTag;

public class ApkMetaTranslator
implements XmlStreamer {
    private final ApkMeta.Builder builder = ApkMeta.newApkMeta();

    @Override
    public void onStartTag(XmlNodeStartTag xmlNodeStartTag) {
        Attributes attributes = xmlNodeStartTag.getAttributes();
        switch (xmlNodeStartTag.getName()) {
            case "application": {
                this.builder.label(attributes.get("label"));
                this.builder.icon(attributes.get("icon"));
                break;
            }
            case "manifest": {
                this.builder.packageName(attributes.get("package"));
                this.builder.versionName(attributes.get("versionName"));
                this.builder.versionCode(attributes.getLong("versionCode"));
                String installLocation = attributes.get("installLocation");
                if (installLocation == null) break;
                this.builder.installLocation(installLocation);
                break;
            }
            case "uses-sdk": {
                this.builder.minSdkVersion(attributes.get("minSdkVersion"));
                this.builder.targetSdkVersion(attributes.get("targetSdkVersion"));
                this.builder.maxSdkVersion(attributes.get("maxSdkVersion"));
                break;
            }
            case "supports-screens": {
                this.builder.anyDensity(attributes.getBoolean("anyDensity", false));
                this.builder.smallScreens(attributes.getBoolean("smallScreens", false));
                this.builder.normalScreens(attributes.getBoolean("normalScreens", false));
                this.builder.largeScreens(attributes.getBoolean("largeScreens", false));
                break;
            }
            case "uses-feature": {
                String name = attributes.get("name");
                boolean required = attributes.getBoolean("required", false);
                if (name != null) {
                    this.builder.addUseFeatures(new UseFeature(name, required));
                    break;
                }
                Integer gl = attributes.getInt("glEsVersion");
                if (gl == null) break;
                this.builder.glEsVersion(new GlEsVersion(gl >> 16, (int)(gl & 0xFFFF), required));
                break;
            }
            case "uses-permission": {
                this.builder.addUsesPermission(attributes.get("name"));
                break;
            }
            case "permission": {
                this.builder.addPermission(Permission.newPermission().name(attributes.get("name")).label(attributes.get("label")).icon(attributes.get("icon")).group(attributes.get("group")).description(attributes.get("description")).protectionLevel(attributes.get("android:protectionLevel")).build());
            }
        }
    }

    @Override
    public void onEndTag(XmlNodeEndTag xmlNodeEndTag) {
    }

    @Override
    public void onCData(XmlCData xmlCData) {
    }

    @Override
    public void onNamespaceStart(XmlNamespaceStartTag tag) {
    }

    @Override
    public void onNamespaceEnd(XmlNamespaceEndTag tag) {
    }

    public ApkMeta getApkMeta() {
        return this.builder.build();
    }
}

