/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.apkparser.parser;

import com.jaredrummler.apkparser.exception.ParserException;
import com.jaredrummler.apkparser.parser.XmlStreamer;
import com.jaredrummler.apkparser.struct.ChunkHeader;
import com.jaredrummler.apkparser.struct.ResourceEntity;
import com.jaredrummler.apkparser.struct.StringPool;
import com.jaredrummler.apkparser.struct.StringPoolHeader;
import com.jaredrummler.apkparser.struct.resource.ResourceTable;
import com.jaredrummler.apkparser.struct.xml.Attribute;
import com.jaredrummler.apkparser.struct.xml.Attributes;
import com.jaredrummler.apkparser.struct.xml.XmlCData;
import com.jaredrummler.apkparser.struct.xml.XmlHeader;
import com.jaredrummler.apkparser.struct.xml.XmlNamespaceEndTag;
import com.jaredrummler.apkparser.struct.xml.XmlNamespaceStartTag;
import com.jaredrummler.apkparser.struct.xml.XmlNodeEndTag;
import com.jaredrummler.apkparser.struct.xml.XmlNodeHeader;
import com.jaredrummler.apkparser.struct.xml.XmlNodeStartTag;
import com.jaredrummler.apkparser.struct.xml.XmlResourceMapHeader;
import com.jaredrummler.apkparser.utils.AttributeValues;
import com.jaredrummler.apkparser.utils.Buffers;
import com.jaredrummler.apkparser.utils.Locales;
import com.jaredrummler.apkparser.utils.ParseUtils;
import com.jaredrummler.apkparser.utils.Utils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class BinaryXmlParser {
    private static final Set<String> INT_ATTRIBUTES = new HashSet<String>(Arrays.asList("screenOrientation", "configChanges", "windowSoftInputMode", "launchMode", "installLocation", "protectionLevel"));
    private StringPool stringPool;
    private String[] resourceMap;
    private ByteBuffer buffer;
    private XmlStreamer xmlStreamer;
    private final ResourceTable resourceTable;
    private Locale locale = Locales.ANY_LOCALE;

    public BinaryXmlParser(ByteBuffer buffer, ResourceTable resourceTable) {
        this.buffer = buffer.duplicate();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.resourceTable = resourceTable;
    }

    public void parse() throws ParserException {
        ChunkHeader chunkHeader = this.readChunkHeader();
        if (chunkHeader == null) {
            return;
        }
        if (chunkHeader.getChunkType() != 3) {
            return;
        }
        chunkHeader = this.readChunkHeader();
        if (chunkHeader == null) {
            return;
        }
        ParseUtils.checkChunkType(1, chunkHeader.getChunkType());
        this.stringPool = ParseUtils.readStringPool(this.buffer, (StringPoolHeader)chunkHeader);
        chunkHeader = this.readChunkHeader();
        if (chunkHeader == null) {
            return;
        }
        if (chunkHeader.getChunkType() == 384) {
            long[] resourceIds = this.readXmlResourceMap((XmlResourceMapHeader)chunkHeader);
            this.resourceMap = new String[resourceIds.length];
            for (int i = 0; i < resourceIds.length; ++i) {
                this.resourceMap[i] = Attribute.AttrIds.getString(resourceIds[i]);
            }
            chunkHeader = this.readChunkHeader();
        }
        while (chunkHeader != null) {
            long beginPos = this.buffer.position();
            switch (chunkHeader.getChunkType()) {
                case 257: {
                    XmlNamespaceEndTag xmlNamespaceEndTag = this.readXmlNamespaceEndTag();
                    this.xmlStreamer.onNamespaceEnd(xmlNamespaceEndTag);
                    break;
                }
                case 256: {
                    XmlNamespaceStartTag namespaceStartTag = this.readXmlNamespaceStartTag();
                    this.xmlStreamer.onNamespaceStart(namespaceStartTag);
                    break;
                }
                case 258: {
                    this.readXmlNodeStartTag();
                    break;
                }
                case 259: {
                    this.readXmlNodeEndTag();
                    break;
                }
                case 260: {
                    this.readXmlCData();
                    break;
                }
                default: {
                    if (chunkHeader.getChunkType() >= 256 && chunkHeader.getChunkType() <= 383) {
                        Buffers.skip(this.buffer, chunkHeader.getBodySize());
                        break;
                    }
                    throw new ParserException("Unexpected chunk type:" + chunkHeader.getChunkType());
                }
            }
            this.buffer.position((int)(beginPos + (long)chunkHeader.getBodySize()));
            chunkHeader = this.readChunkHeader();
        }
    }

    private XmlCData readXmlCData() {
        XmlCData xmlCData = new XmlCData();
        int dataRef = this.buffer.getInt();
        if (dataRef > 0) {
            xmlCData.setData(this.stringPool.get(dataRef));
        }
        xmlCData.setTypedData(ParseUtils.readResValue(this.buffer, this.stringPool));
        if (this.xmlStreamer != null) {
            // empty if block
        }
        return xmlCData;
    }

    private XmlNodeEndTag readXmlNodeEndTag() {
        XmlNodeEndTag xmlNodeEndTag = new XmlNodeEndTag();
        int nsRef = this.buffer.getInt();
        int nameRef = this.buffer.getInt();
        if (nsRef > 0) {
            xmlNodeEndTag.setNamespace(this.stringPool.get(nsRef));
        }
        xmlNodeEndTag.setName(this.stringPool.get(nameRef));
        if (this.xmlStreamer != null) {
            this.xmlStreamer.onEndTag(xmlNodeEndTag);
        }
        return xmlNodeEndTag;
    }

    private XmlNodeStartTag readXmlNodeStartTag() {
        int nsRef = this.buffer.getInt();
        int nameRef = this.buffer.getInt();
        XmlNodeStartTag xmlNodeStartTag = new XmlNodeStartTag();
        if (nsRef > 0) {
            xmlNodeStartTag.setNamespace(this.stringPool.get(nsRef));
        }
        xmlNodeStartTag.setName(this.stringPool.get(nameRef));
        Buffers.readUShort(this.buffer);
        Buffers.readUShort(this.buffer);
        int attributeCount = Buffers.readUShort(this.buffer);
        Buffers.readUShort(this.buffer);
        Buffers.readUShort(this.buffer);
        Buffers.readUShort(this.buffer);
        Attributes attributes = new Attributes(attributeCount);
        for (int count = 0; count < attributeCount; ++count) {
            Attribute attribute = this.readAttribute();
            if (this.xmlStreamer == null) continue;
            String value = attribute.toStringValue(this.resourceTable, this.locale);
            if (INT_ATTRIBUTES.contains(attribute.getName()) && Utils.isNumeric(value)) {
                try {
                    value = this.getFinalValueAsString(attribute.getName(), value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            attribute.setValue(value);
            attributes.set(count, attribute);
        }
        xmlNodeStartTag.setAttributes(attributes);
        if (this.xmlStreamer != null) {
            this.xmlStreamer.onStartTag(xmlNodeStartTag);
        }
        return xmlNodeStartTag;
    }

    private String getFinalValueAsString(String attributeName, String str) {
        int value = Integer.parseInt(str);
        switch (attributeName) {
            case "screenOrientation": {
                return AttributeValues.getScreenOrientation(value);
            }
            case "configChanges": {
                return AttributeValues.getConfigChanges(value);
            }
            case "windowSoftInputMode": {
                return AttributeValues.getWindowSoftInputMode(value);
            }
            case "launchMode": {
                return AttributeValues.getLaunchMode(value);
            }
            case "installLocation": {
                return AttributeValues.getInstallLocation(value);
            }
            case "protectionLevel": {
                return AttributeValues.getProtectionLevel(value);
            }
        }
        return str;
    }

    private Attribute readAttribute() {
        int rawValueRef;
        int nsRef = this.buffer.getInt();
        int nameRef = this.buffer.getInt();
        Attribute attribute = new Attribute();
        if (nsRef > 0) {
            attribute.setNamespace(this.stringPool.get(nsRef));
        }
        attribute.setName(this.stringPool.get(nameRef));
        if (attribute.getName().isEmpty() && this.resourceMap != null && nameRef < this.resourceMap.length) {
            attribute.setName(this.resourceMap[nameRef]);
        }
        if ((rawValueRef = this.buffer.getInt()) > 0) {
            attribute.setRawValue(this.stringPool.get(rawValueRef));
        }
        ResourceEntity resValue = ParseUtils.readResValue(this.buffer, this.stringPool);
        attribute.setTypedValue(resValue);
        return attribute;
    }

    private XmlNamespaceStartTag readXmlNamespaceStartTag() {
        int prefixRef = this.buffer.getInt();
        int uriRef = this.buffer.getInt();
        XmlNamespaceStartTag nameSpace = new XmlNamespaceStartTag();
        if (prefixRef > 0) {
            nameSpace.setPrefix(this.stringPool.get(prefixRef));
        }
        if (uriRef > 0) {
            nameSpace.setUri(this.stringPool.get(uriRef));
        }
        return nameSpace;
    }

    private XmlNamespaceEndTag readXmlNamespaceEndTag() {
        int prefixRef = this.buffer.getInt();
        int uriRef = this.buffer.getInt();
        XmlNamespaceEndTag nameSpace = new XmlNamespaceEndTag();
        if (prefixRef > 0) {
            nameSpace.setPrefix(this.stringPool.get(prefixRef));
        }
        if (uriRef > 0) {
            nameSpace.setUri(this.stringPool.get(uriRef));
        }
        return nameSpace;
    }

    private long[] readXmlResourceMap(XmlResourceMapHeader chunkHeader) {
        int count = chunkHeader.getBodySize() / 4;
        long[] resourceIds = new long[count];
        for (int i = 0; i < count; ++i) {
            resourceIds[i] = Buffers.readUInt(this.buffer);
        }
        return resourceIds;
    }

    private ChunkHeader readChunkHeader() throws ParserException {
        if (!this.buffer.hasRemaining()) {
            return null;
        }
        long begin = this.buffer.position();
        int chunkType = Buffers.readUShort(this.buffer);
        int headerSize = Buffers.readUShort(this.buffer);
        long chunkSize = Buffers.readUInt(this.buffer);
        switch (chunkType) {
            case 3: {
                return new XmlHeader(chunkType, headerSize, chunkSize);
            }
            case 1: {
                StringPoolHeader stringPoolHeader = new StringPoolHeader(chunkType, headerSize, chunkSize);
                stringPoolHeader.setStringCount(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStyleCount(Buffers.readUInt(this.buffer));
                stringPoolHeader.setFlags(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStringsStart(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStylesStart(Buffers.readUInt(this.buffer));
                this.buffer.position((int)(begin + (long)headerSize));
                return stringPoolHeader;
            }
            case 384: {
                this.buffer.position((int)(begin + (long)headerSize));
                return new XmlResourceMapHeader(chunkType, headerSize, chunkSize);
            }
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: {
                XmlNodeHeader header = new XmlNodeHeader(chunkType, headerSize, chunkSize);
                header.setLineNum((int)Buffers.readUInt(this.buffer));
                header.setCommentRef((int)Buffers.readUInt(this.buffer));
                this.buffer.position((int)(begin + (long)headerSize));
                return header;
            }
        }
        throw new ParserException("Unexpected chunk type:" + chunkType);
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public XmlStreamer getXmlStreamer() {
        return this.xmlStreamer;
    }

    public void setXmlStreamer(XmlStreamer xmlStreamer) {
        this.xmlStreamer = xmlStreamer;
    }
}

