/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.apkparser.parser;

import com.jaredrummler.apkparser.model.CertificateMeta;
import com.jaredrummler.apkparser.utils.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public class CertificateParser {
    private final InputStream in;

    public CertificateParser(InputStream in) {
        this.in = new BufferedInputStream(in);
    }

    public CertificateMeta parse() throws IOException, CertificateException {
        X509Certificate certificate = X509Certificate.getInstance(Utils.toByteArray(this.in));
        CertificateMeta.Builder builder = CertificateMeta.newCertificateMeta();
        byte[] bytes = certificate.getEncoded();
        String certMd5 = this.md5Digest(bytes);
        String publicKeyString = this.byteToHexString(bytes);
        String certBase64Md5 = this.md5Digest(publicKeyString);
        builder.data(bytes);
        builder.certBase64Md5(certBase64Md5);
        builder.certMd5(certMd5);
        builder.startDate(certificate.getNotBefore());
        builder.endDate(certificate.getNotAfter());
        builder.signAlgorithm(certificate.getSigAlgName());
        builder.signAlgorithmOID(certificate.getSigAlgOID());
        return builder.build();
    }

    private String md5Digest(byte[] input) throws IOException {
        MessageDigest digest = this.getDigest("MD5");
        digest.update(input);
        return this.getHexString(digest.digest());
    }

    private String md5Digest(String input) throws IOException {
        MessageDigest digest = this.getDigest("MD5");
        digest.update(input.getBytes(Charset.forName("UTF-8")));
        return this.getHexString(digest.digest());
    }

    private String byteToHexString(byte[] bArray) {
        StringBuilder sb = new StringBuilder(bArray.length);
        for (byte aBArray : bArray) {
            String sTemp = Integer.toHexString(0xFF & (char)aBArray);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    private String getHexString(byte[] digest) {
        BigInteger bi = new BigInteger(1, digest);
        return String.format("%032x", bi);
    }

    private MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

