/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.apkparser.parser;

import com.jaredrummler.apkparser.exception.ParserException;
import com.jaredrummler.apkparser.model.DexClass;
import com.jaredrummler.apkparser.model.DexInfo;
import com.jaredrummler.apkparser.parser.StringPoolEntry;
import com.jaredrummler.apkparser.struct.StringPool;
import com.jaredrummler.apkparser.struct.dex.DexClassStruct;
import com.jaredrummler.apkparser.struct.dex.DexHeader;
import com.jaredrummler.apkparser.utils.Buffers;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DexParser {
    private static final int NO_INDEX = -1;
    private final ByteBuffer buffer;

    public DexParser(ByteBuffer buffer) {
        this.buffer = buffer.duplicate();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public DexInfo parse() throws ParserException {
        String magic = new String(Buffers.readBytes(this.buffer, 8));
        if (!magic.startsWith("dex\n")) {
            return null;
        }
        int version = Integer.parseInt(magic.substring(4, 7));
        if (version < 35) {
            throw new ParserException("Dex file version: " + version + " is not supported");
        }
        this.buffer.getInt();
        Buffers.readBytes(this.buffer, 20);
        DexHeader.Builder builder = DexHeader.newDexHeader();
        builder.fileSize(Buffers.readUInt(this.buffer));
        builder.headerSize(Buffers.readUInt(this.buffer));
        Buffers.readUInt(this.buffer);
        builder.linkSize(Buffers.readUInt(this.buffer));
        builder.linkOff(Buffers.readUInt(this.buffer));
        builder.mapOff(Buffers.readUInt(this.buffer));
        builder.stringIdsSize(this.buffer.getInt());
        builder.stringIdsOff(Buffers.readUInt(this.buffer));
        builder.typeIdsSize(this.buffer.getInt());
        builder.typeIdsOff(Buffers.readUInt(this.buffer));
        builder.protoIdsSize(this.buffer.getInt());
        builder.protoIdsOff(Buffers.readUInt(this.buffer));
        builder.fieldIdsSize(this.buffer.getInt());
        builder.fieldIdsOff(Buffers.readUInt(this.buffer));
        builder.methodIdsSize(this.buffer.getInt());
        builder.methodIdsOff(Buffers.readUInt(this.buffer));
        builder.classDefsSize(this.buffer.getInt());
        builder.classDefsOff(Buffers.readUInt(this.buffer));
        builder.dataSize(this.buffer.getInt());
        builder.dataOff(Buffers.readUInt(this.buffer));
        builder.version(version);
        DexHeader header = builder.build();
        this.buffer.position((int)header.headerSize);
        long[] stringOffsets = this.readStringPool(header.stringIdsOff, header.stringIdsSize);
        int[] typeIds = this.readTypes(header.typeIdsOff, header.typeIdsSize);
        DexClassStruct[] dexClassStructs = this.readClass(header.classDefsOff, header.classDefsSize);
        StringPool stringpool = this.readStrings(stringOffsets);
        String[] types = new String[typeIds.length];
        for (int i = 0; i < typeIds.length; ++i) {
            types[i] = stringpool.get(typeIds[i]);
        }
        int numClasses = dexClassStructs.length;
        DexClass[] dexClasses = new DexClass[numClasses];
        for (int i = 0; i < numClasses; ++i) {
            DexClass.Builder b = DexClass.newDexClass();
            DexClassStruct dexClassStruct = dexClassStructs[i];
            b.classType(types[dexClassStruct.classIdx]);
            if (dexClassStruct.superclassIdx != -1) {
                b.superClass(types[dexClassStruct.superclassIdx]);
            }
            b.accessFlags(dexClassStruct.accessFlags);
            dexClasses[i] = b.build();
        }
        return new DexInfo(dexClasses, header);
    }

    private DexClassStruct[] readClass(long classDefsOff, int classDefsSize) {
        this.buffer.position((int)classDefsOff);
        DexClassStruct[] dexClassStructs = new DexClassStruct[classDefsSize];
        for (int i = 0; i < classDefsSize; ++i) {
            dexClassStructs[i] = DexClassStruct.newDexClassStruct().classIdx(this.buffer.getInt()).accessFlags(this.buffer.getInt()).superclassIdx(this.buffer.getInt()).interfacesOff(Buffers.readUInt(this.buffer)).sourceFileIdx(this.buffer.getInt()).annotationsOff(Buffers.readUInt(this.buffer)).classDataOff(Buffers.readUInt(this.buffer)).staticValuesOff(Buffers.readUInt(this.buffer)).build();
        }
        return dexClassStructs;
    }

    private int[] readTypes(long typeIdsOff, int typeIdsSize) {
        this.buffer.position((int)typeIdsOff);
        int[] typeIds = new int[typeIdsSize];
        for (int i = 0; i < typeIdsSize; ++i) {
            typeIds[i] = (int)Buffers.readUInt(this.buffer);
        }
        return typeIds;
    }

    private StringPool readStrings(long[] offsets) throws ParserException {
        StringPoolEntry[] entries = new StringPoolEntry[offsets.length];
        for (int i = 0; i < offsets.length; ++i) {
            entries[i] = new StringPoolEntry(i, offsets[i]);
        }
        String lastStr = null;
        long lastOffset = -1L;
        StringPool stringpool = new StringPool(offsets.length);
        for (StringPoolEntry entry : entries) {
            String str;
            if (entry.offset == lastOffset) {
                stringpool.set(entry.index, lastStr);
                continue;
            }
            this.buffer.position((int)entry.offset);
            lastOffset = entry.offset;
            lastStr = str = this.readString();
            stringpool.set(entry.index, str);
        }
        return stringpool;
    }

    private long[] readStringPool(long stringIdsOff, int stringIdsSize) {
        this.buffer.position((int)stringIdsOff);
        long[] offsets = new long[stringIdsSize];
        for (int i = 0; i < stringIdsSize; ++i) {
            offsets[i] = Buffers.readUInt(this.buffer);
        }
        return offsets;
    }

    private String readString() throws ParserException {
        int strLen = this.readVarInts();
        return Buffers.readString(this.buffer, strLen);
    }

    private int readVarInts() throws ParserException {
        short s;
        int i = 0;
        int count = 0;
        do {
            if (count > 4) {
                throw new ParserException("read varints error.");
            }
            s = Buffers.readUByte(this.buffer);
            i |= (s & 0x7F) << count * 7;
            ++count;
        } while ((s & 0x80) != 0);
        return i;
    }
}

