/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.apkparser.parser;

import com.jaredrummler.apkparser.exception.ParserException;
import com.jaredrummler.apkparser.struct.ChunkHeader;
import com.jaredrummler.apkparser.struct.StringPool;
import com.jaredrummler.apkparser.struct.StringPoolHeader;
import com.jaredrummler.apkparser.struct.resource.PackageHeader;
import com.jaredrummler.apkparser.struct.resource.ResTableConfig;
import com.jaredrummler.apkparser.struct.resource.ResourcePackage;
import com.jaredrummler.apkparser.struct.resource.ResourceTable;
import com.jaredrummler.apkparser.struct.resource.ResourceTableHeader;
import com.jaredrummler.apkparser.struct.resource.Type;
import com.jaredrummler.apkparser.struct.resource.TypeHeader;
import com.jaredrummler.apkparser.struct.resource.TypeSpec;
import com.jaredrummler.apkparser.struct.resource.TypeSpecHeader;
import com.jaredrummler.apkparser.utils.Buffers;
import com.jaredrummler.apkparser.utils.Pair;
import com.jaredrummler.apkparser.utils.ParseUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class ResourceTableParser {
    private StringPool stringPool;
    private ByteBuffer buffer;
    private ResourceTable resourceTable;
    private Set<Locale> locales;

    public ResourceTableParser(ByteBuffer buffer) {
        this.buffer = buffer.duplicate();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.locales = new HashSet<Locale>();
    }

    public void parse() throws ParserException {
        ResourceTableHeader resourceTableHeader = (ResourceTableHeader)this.readChunkHeader();
        this.stringPool = ParseUtils.readStringPool(this.buffer, (StringPoolHeader)this.readChunkHeader());
        this.resourceTable = new ResourceTable();
        this.resourceTable.setStringPool(this.stringPool);
        PackageHeader packageHeader = (PackageHeader)this.readChunkHeader();
        int i = 0;
        while ((long)i < resourceTableHeader.getPackageCount()) {
            Pair<ResourcePackage, PackageHeader> pair = this.readPackage(packageHeader);
            this.resourceTable.addPackage(pair.getLeft());
            packageHeader = pair.getRight();
            ++i;
        }
    }

    private Pair<ResourcePackage, PackageHeader> readPackage(PackageHeader packageHeader) throws ParserException {
        Pair<ResourcePackage, PackageHeader> pair = new Pair<ResourcePackage, PackageHeader>();
        ResourcePackage resourcePackage = new ResourcePackage(packageHeader);
        pair.setLeft(resourcePackage);
        long beginPos = this.buffer.position();
        if (packageHeader.getTypeStrings() > 0L) {
            this.buffer.position((int)(beginPos + packageHeader.getTypeStrings() - (long)packageHeader.getHeaderSize()));
            resourcePackage.setTypeStringPool(ParseUtils.readStringPool(this.buffer, (StringPoolHeader)this.readChunkHeader()));
        }
        if (packageHeader.getKeyStrings() > 0L) {
            this.buffer.position((int)(beginPos + packageHeader.getKeyStrings() - (long)packageHeader.getHeaderSize()));
            resourcePackage.setKeyStringPool(ParseUtils.readStringPool(this.buffer, (StringPoolHeader)this.readChunkHeader()));
        }
        block5: while (this.buffer.hasRemaining()) {
            ChunkHeader chunkHeader = this.readChunkHeader();
            switch (chunkHeader.getChunkType()) {
                case 514: {
                    long typeSpecChunkBegin = this.buffer.position();
                    TypeSpecHeader typeSpecHeader = (TypeSpecHeader)chunkHeader;
                    long[] entryFlags = new long[(int)typeSpecHeader.getEntryCount()];
                    int i = 0;
                    while ((long)i < typeSpecHeader.getEntryCount()) {
                        entryFlags[i] = Buffers.readUInt(this.buffer);
                        ++i;
                    }
                    TypeSpec typeSpec = new TypeSpec(typeSpecHeader);
                    typeSpec.setEntryFlags(entryFlags);
                    typeSpec.setName(resourcePackage.getTypeStringPool().get(typeSpecHeader.getId() - 1));
                    resourcePackage.addTypeSpec(typeSpec);
                    this.buffer.position((int)(typeSpecChunkBegin + (long)typeSpecHeader.getBodySize()));
                    break;
                }
                case 513: {
                    long typeChunkBegin = this.buffer.position();
                    TypeHeader typeHeader = (TypeHeader)chunkHeader;
                    long[] offsets = new long[(int)typeHeader.getEntryCount()];
                    int i = 0;
                    while ((long)i < typeHeader.getEntryCount()) {
                        offsets[i] = Buffers.readUInt(this.buffer);
                        ++i;
                    }
                    Type type = new Type(typeHeader);
                    type.setName(resourcePackage.getTypeStringPool().get(typeHeader.getId() - 1));
                    long entryPos = typeChunkBegin + typeHeader.getEntriesStart() - (long)typeHeader.getHeaderSize();
                    this.buffer.position((int)entryPos);
                    ByteBuffer b = this.buffer.slice();
                    b.order(ByteOrder.LITTLE_ENDIAN);
                    type.setBuffer(b);
                    type.setKeyStringPool(resourcePackage.getKeyStringPool());
                    type.setOffsets(offsets);
                    type.setStringPool(this.stringPool);
                    resourcePackage.addType(type);
                    this.locales.add(type.getLocale());
                    this.buffer.position((int)(typeChunkBegin + (long)typeHeader.getBodySize()));
                    break;
                }
                case 512: {
                    pair.setRight((PackageHeader)chunkHeader);
                    break block5;
                }
                default: {
                    throw new ParserException("unexpected chunk type:" + chunkHeader.getChunkType());
                }
            }
        }
        return pair;
    }

    private ChunkHeader readChunkHeader() throws ParserException {
        long begin = this.buffer.position();
        int chunkType = Buffers.readUShort(this.buffer);
        int headerSize = Buffers.readUShort(this.buffer);
        long chunkSize = Buffers.readUInt(this.buffer);
        switch (chunkType) {
            case 2: {
                ResourceTableHeader resourceTableHeader = new ResourceTableHeader(chunkType, headerSize, chunkSize);
                resourceTableHeader.setPackageCount(Buffers.readUInt(this.buffer));
                this.buffer.position((int)(begin + (long)headerSize));
                return resourceTableHeader;
            }
            case 1: {
                StringPoolHeader stringPoolHeader = new StringPoolHeader(chunkType, headerSize, chunkSize);
                stringPoolHeader.setStringCount(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStyleCount(Buffers.readUInt(this.buffer));
                stringPoolHeader.setFlags(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStringsStart(Buffers.readUInt(this.buffer));
                stringPoolHeader.setStylesStart(Buffers.readUInt(this.buffer));
                this.buffer.position((int)(begin + (long)headerSize));
                return stringPoolHeader;
            }
            case 512: {
                PackageHeader packageHeader = new PackageHeader(chunkType, headerSize, chunkSize);
                packageHeader.setId(Buffers.readUInt(this.buffer));
                packageHeader.setName(ParseUtils.readStringUTF16(this.buffer, 128));
                packageHeader.setTypeStrings(Buffers.readUInt(this.buffer));
                packageHeader.setLastPublicType(Buffers.readUInt(this.buffer));
                packageHeader.setKeyStrings(Buffers.readUInt(this.buffer));
                packageHeader.setLastPublicKey(Buffers.readUInt(this.buffer));
                this.buffer.position((int)(begin + (long)headerSize));
                return packageHeader;
            }
            case 514: {
                TypeSpecHeader typeSpecHeader = new TypeSpecHeader(chunkType, headerSize, chunkSize);
                typeSpecHeader.setId(Buffers.readUByte(this.buffer));
                typeSpecHeader.setRes0(Buffers.readUByte(this.buffer));
                typeSpecHeader.setRes1(Buffers.readUShort(this.buffer));
                typeSpecHeader.setEntryCount(Buffers.readUInt(this.buffer));
                this.buffer.position((int)(begin + (long)headerSize));
                return typeSpecHeader;
            }
            case 513: {
                TypeHeader typeHeader = new TypeHeader(chunkType, headerSize, chunkSize);
                typeHeader.setId(Buffers.readUByte(this.buffer));
                typeHeader.setRes0(Buffers.readUByte(this.buffer));
                typeHeader.setRes1(Buffers.readUShort(this.buffer));
                typeHeader.setEntryCount(Buffers.readUInt(this.buffer));
                typeHeader.setEntriesStart(Buffers.readUInt(this.buffer));
                typeHeader.setConfig(this.readResTableConfig());
                this.buffer.position((int)(begin + (long)headerSize));
                return typeHeader;
            }
        }
        throw new ParserException("Unexpected chunk Type:" + Integer.toHexString(chunkType));
    }

    private ResTableConfig readResTableConfig() {
        long beginPos = this.buffer.position();
        ResTableConfig config = new ResTableConfig();
        long size = Buffers.readUInt(this.buffer);
        Buffers.skip(this.buffer, 4);
        config.setLanguage(new String(Buffers.readBytes(this.buffer, 2)).replace("\u0000", ""));
        config.setCountry(new String(Buffers.readBytes(this.buffer, 2)).replace("\u0000", ""));
        long endPos = this.buffer.position();
        Buffers.skip(this.buffer, (int)(size - (endPos - beginPos)));
        return config;
    }

    public ResourceTable getResourceTable() {
        return this.resourceTable;
    }

    public Set<Locale> getLocales() {
        return this.locales;
    }
}

