/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.apkparser.parser;

import com.jaredrummler.apkparser.parser.XmlNamespaces;
import com.jaredrummler.apkparser.parser.XmlStreamer;
import com.jaredrummler.apkparser.struct.xml.Attribute;
import com.jaredrummler.apkparser.struct.xml.XmlCData;
import com.jaredrummler.apkparser.struct.xml.XmlNamespaceEndTag;
import com.jaredrummler.apkparser.struct.xml.XmlNamespaceStartTag;
import com.jaredrummler.apkparser.struct.xml.XmlNodeEndTag;
import com.jaredrummler.apkparser.struct.xml.XmlNodeStartTag;
import com.jaredrummler.apkparser.utils.xml.XmlEscaper;
import java.util.List;

public class XmlTranslator
implements XmlStreamer {
    private StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
    private XmlNamespaces namespaces = new XmlNamespaces();
    private boolean isLastStartTag;
    private int shift;

    @Override
    public void onStartTag(XmlNodeStartTag xmlNodeStartTag) {
        if (this.isLastStartTag) {
            this.sb.append(">\n");
        }
        this.appendShift(this.shift++);
        this.sb.append('<');
        if (xmlNodeStartTag.getNamespace() != null) {
            String prefix = this.namespaces.getPrefixViaUri(xmlNodeStartTag.getNamespace());
            if (prefix != null) {
                this.sb.append(prefix).append(':');
            } else {
                this.sb.append(xmlNodeStartTag.getNamespace()).append(':');
            }
        }
        this.sb.append(xmlNodeStartTag.getName());
        List<XmlNamespaces.XmlNamespace> nps = this.namespaces.consumeNameSpaces();
        if (!nps.isEmpty()) {
            for (XmlNamespaces.XmlNamespace np : nps) {
                this.sb.append(" xmlns:").append(np.prefix).append("=\"").append(np.uri).append("\"");
            }
        }
        this.isLastStartTag = true;
        for (Attribute attribute : xmlNodeStartTag.getAttributes().value()) {
            this.onAttribute(attribute);
        }
    }

    private void onAttribute(Attribute attribute) {
        this.sb.append(' ');
        String namespace = this.namespaces.getPrefixViaUri(attribute.getNamespace());
        if (namespace == null) {
            namespace = attribute.getNamespace();
        }
        if (namespace != null && !namespace.isEmpty()) {
            this.sb.append(namespace).append(':');
        }
        String escapedFinalValue = XmlEscaper.escapeXml10(attribute.getValue());
        this.sb.append(attribute.getName()).append('=').append('\"').append(escapedFinalValue).append('\"');
    }

    @Override
    public void onEndTag(XmlNodeEndTag xmlNodeEndTag) {
        --this.shift;
        if (this.isLastStartTag) {
            this.sb.append(" />\n");
        } else {
            this.appendShift(this.shift);
            this.sb.append("</");
            if (xmlNodeEndTag.getNamespace() != null) {
                this.sb.append(xmlNodeEndTag.getNamespace()).append(':');
            }
            this.sb.append(xmlNodeEndTag.getName());
            this.sb.append(">\n");
        }
        this.isLastStartTag = false;
    }

    @Override
    public void onCData(XmlCData xmlCData) {
        this.appendShift(this.shift);
        this.sb.append(xmlCData.getValue()).append('\n');
        this.isLastStartTag = false;
    }

    @Override
    public void onNamespaceStart(XmlNamespaceStartTag tag) {
        this.namespaces.addNamespace(tag);
    }

    @Override
    public void onNamespaceEnd(XmlNamespaceEndTag tag) {
        this.namespaces.removeNamespace(tag);
    }

    private void appendShift(int shift) {
        for (int i = 0; i < shift; ++i) {
            this.sb.append('\t');
        }
    }

    public String getXml() {
        return this.sb.toString();
    }
}

