/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.apkparser.struct.resource;

import com.jaredrummler.apkparser.struct.StringPool;
import com.jaredrummler.apkparser.struct.resource.PackageHeader;
import com.jaredrummler.apkparser.struct.resource.Type;
import com.jaredrummler.apkparser.struct.resource.TypeSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourcePackage {
    private String name;
    private short id;
    private StringPool typeStringPool;
    private StringPool keyStringPool;
    private Map<Short, TypeSpec> typeSpecMap = new HashMap<Short, TypeSpec>();
    private Map<Short, List<Type>> typesMap = new HashMap<Short, List<Type>>();

    public ResourcePackage(PackageHeader header) {
        this.name = header.getName();
        this.id = (short)header.getId();
    }

    public void addTypeSpec(TypeSpec typeSpec) {
        this.typeSpecMap.put(typeSpec.getId(), typeSpec);
    }

    public TypeSpec getTypeSpec(Short id) {
        return this.typeSpecMap.get(id);
    }

    public void addType(Type type) {
        List<Type> types = this.typesMap.get(type.getId());
        if (types == null) {
            types = new ArrayList<Type>();
            this.typesMap.put(type.getId(), types);
        }
        types.add(type);
    }

    public List<Type> getTypes(Short id) {
        return this.typesMap.get(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public short getId() {
        return this.id;
    }

    public void setId(short id) {
        this.id = id;
    }

    public StringPool getTypeStringPool() {
        return this.typeStringPool;
    }

    public void setTypeStringPool(StringPool typeStringPool) {
        this.typeStringPool = typeStringPool;
    }

    public StringPool getKeyStringPool() {
        return this.keyStringPool;
    }

    public void setKeyStringPool(StringPool keyStringPool) {
        this.keyStringPool = keyStringPool;
    }

    public Map<Short, TypeSpec> getTypeSpecMap() {
        return this.typeSpecMap;
    }

    public void setTypeSpecMap(Map<Short, TypeSpec> typeSpecMap) {
        this.typeSpecMap = typeSpecMap;
    }

    public Map<Short, List<Type>> getTypesMap() {
        return this.typesMap;
    }

    public void setTypesMap(Map<Short, List<Type>> typesMap) {
        this.typesMap = typesMap;
    }
}

