/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class ByteArray<T extends ByteArray<T>> {
    private static final int COPY_BUFFER_SIZE = 8192;
    private boolean bound;
    private int storageLength;
    private int filledLength;
    private boolean growable;

    protected ByteArray(int filledLength, int storageLength, boolean growable) {
        this.storageLength = storageLength;
        this.setFilledLength(filledLength);
        this.growable = growable;
    }

    protected ByteArray(int filledLength, int storageLength) {
        this(filledLength, storageLength, false);
    }

    public int get(int index) {
        if (index < 0 || index >= this.filledLength) {
            return -1;
        }
        return this.internalGet(index) & 0xFF;
    }

    public int get(int index, byte[] b) {
        return this.get(index, b, 0, b.length);
    }

    public int get(int index, byte[] b, int offset, int length) {
        if (index < 0 || index >= this.filledLength) {
            return -1;
        }
        int actualLength = Math.min(length, this.filledLength - index);
        return this.internalGet(index, b, offset, actualLength);
    }

    public int length() {
        return this.filledLength;
    }

    public int size() {
        return this.storageLength;
    }

    public final boolean growable() {
        return this.growable;
    }

    public int setFilledLength(int filledLength) {
        this.filledLength = Math.min(filledLength, this.storageLength);
        return this.filledLength;
    }

    public void put(int index, byte b) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Attempt to write outside the bounds of the data.");
        }
        this.internalPut(index, b);
        this.filledLength = Math.max(this.filledLength, index + 1);
    }

    public int put(int index, byte[] b) {
        return this.put(index, b, 0, b.length);
    }

    public int put(int index, byte[] b, int offset, int length) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Attempt to write outside the bounds of the data.");
        }
        int actualLength = Math.min(length, this.size() - index);
        int bytesWritten = this.internalPut(index, b, offset, actualLength);
        this.filledLength = Math.max(this.filledLength, index + bytesWritten);
        return bytesWritten;
    }

    public int copyTo(ByteArray<? extends ByteArray<?>> array) {
        return this.copyTo(array, 0, this.length());
    }

    public int copyTo(ByteArray<? extends ByteArray<?>> array, int offset, int length) {
        return this.copyTo(0, array, offset, length);
    }

    public int copyTo(int dstOffset, ByteArray<? extends ByteArray<?>> array, int srcOffset, int length) {
        byte[] b = new byte[8192];
        int bytesRead = 0;
        int index = 0;
        int bufferLength = Math.min(b.length, length);
        while ((bytesRead = this.get(index + srcOffset, b, 0, bufferLength)) > 0) {
            int bytesWritten = array.put(index + dstOffset, b, 0, bytesRead);
            index += bytesRead;
            bufferLength = Math.min(b.length, length -= bytesRead);
        }
        return index;
    }

    public int copyTo(OutputStream os) throws IOException {
        return this.copyTo(os, 0, this.length());
    }

    public int copyTo(OutputStream os, int offset, int length) throws IOException {
        byte[] b = new byte[8192];
        int bytesRead = 0;
        int index = 0;
        int bufferLength = Math.min(b.length, length);
        while ((bytesRead = this.get(index + offset, b, 0, bufferLength)) > 0) {
            os.write(b, 0, bytesRead);
            bufferLength = Math.min(b.length, length - (index += bytesRead));
        }
        return index;
    }

    public void copyFrom(InputStream is, int length) throws IOException {
        byte[] b = new byte[8192];
        int bytesRead = 0;
        int index = 0;
        int bufferLength = Math.min(b.length, length);
        while ((bytesRead = is.read(b, 0, bufferLength)) > 0) {
            if (this.put(index, b, 0, bytesRead) != bytesRead) {
                throw new IOException("Error writing bytes.");
            }
            index += bytesRead;
            bufferLength = Math.min(b.length, length -= bytesRead);
        }
    }

    public void copyFrom(InputStream is) throws IOException {
        byte[] b = new byte[8192];
        int bytesRead = 0;
        int index = 0;
        int bufferLength = b.length;
        while ((bytesRead = is.read(b, 0, bufferLength)) > 0) {
            if (this.put(index, b, 0, bytesRead) != bytesRead) {
                throw new IOException("Error writing bytes.");
            }
            index += bytesRead;
        }
    }

    protected abstract void internalPut(int var1, byte var2);

    protected abstract int internalPut(int var1, byte[] var2, int var3, int var4);

    protected abstract int internalGet(int var1);

    protected abstract int internalGet(int var1, byte[] var2, int var3, int var4);

    public abstract void close();

    public String toString(int offset, int length) {
        if (length == -1) {
            length = this.length();
        }
        length = Math.min(length, this.length());
        StringBuilder sb = new StringBuilder();
        sb.append("[l=" + this.filledLength + ", s=" + this.size() + "]");
        if (length > 0) {
            sb.append("\n");
        }
        for (int i = 0; i < length; ++i) {
            int r = this.get(i + offset);
            if (r < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(r));
            sb.append(" ");
            if (i <= 0 || (i + 1) % 16 != 0) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(0, 0);
    }
}

