/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import com.google.typography.font.sfntly.data.ByteArray;
import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.MemoryByteArray;
import com.google.typography.font.sfntly.data.WritableFontData;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;

public class ReadableFontData
extends FontData {
    private volatile boolean checksumSet = false;
    private final Object checksumLock = new Object();
    private volatile long checksum;
    private volatile int[] checksumRange;

    public static ReadableFontData createReadableFontData(byte[] b) {
        MemoryByteArray ba = new MemoryByteArray(b);
        return new ReadableFontData(ba);
    }

    protected ReadableFontData(ByteArray<? extends ByteArray<?>> array) {
        super(array);
    }

    protected ReadableFontData(ReadableFontData data, int offset) {
        super(data, offset);
    }

    protected ReadableFontData(ReadableFontData data, int offset, int length) {
        super(data, offset, length);
    }

    @Override
    public ReadableFontData slice(int offset, int length) {
        if (offset < 0 || offset + length > this.size()) {
            throw new IndexOutOfBoundsException("Attempt to bind data outside of its limits.");
        }
        ReadableFontData slice = new ReadableFontData(this, offset, length);
        return slice;
    }

    @Override
    public ReadableFontData slice(int offset) {
        if (offset < 0 || offset > this.size()) {
            throw new IndexOutOfBoundsException("Attempt to bind data outside of its limits.");
        }
        ReadableFontData slice = new ReadableFontData(this, offset);
        return slice;
    }

    public String toString(int length) {
        StringBuilder sb = new StringBuilder();
        sb.append("[l=" + this.length() + ", cs=" + this.checksum() + "]\n");
        sb.append(this.array.toString(this.boundOffset(0), this.boundLength(0, length)));
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    public long checksum() {
        if (!this.checksumSet) {
            this.computeChecksum();
        }
        return this.checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeChecksum() {
        Object object = this.checksumLock;
        synchronized (object) {
            if (this.checksumSet) {
                return;
            }
            long sum = 0L;
            if (this.checksumRange == null) {
                sum = this.computeCheckSum(0, this.length());
            } else {
                for (int lowBoundIndex = 0; lowBoundIndex < this.checksumRange.length; lowBoundIndex += 2) {
                    int lowBound = this.checksumRange[lowBoundIndex];
                    int highBound = lowBoundIndex == this.checksumRange.length - 1 ? this.length() : this.checksumRange[lowBoundIndex + 1];
                    sum += this.computeCheckSum(lowBound, highBound);
                }
            }
            this.checksum = sum & 0xFFFFFFFFL;
            this.checksumSet = true;
        }
    }

    private long computeCheckSum(int lowBound, int highBound) {
        long sum = 0L;
        for (int i = lowBound; i <= highBound - 4; i += 4) {
            sum += this.readULong(i);
        }
        int off = highBound & 0xFFFFFFFC;
        if (off < highBound) {
            int b3 = this.readUByte(off);
            int b2 = off + 1 < highBound ? this.readUByte(off + 1) : 0;
            int b1 = off + 2 < highBound ? this.readUByte(off + 2) : 0;
            int b0 = 0;
            sum += (long)(b3 << 24 | b2 << 16 | b1 << 8 | b0);
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckSumRanges(int ... ranges) {
        Object object = this.checksumLock;
        synchronized (object) {
            this.checksumRange = (int[])(ranges != null && ranges.length > 0 ? Arrays.copyOf(ranges, ranges.length) : null);
            this.checksumSet = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] checkSumRange() {
        Object object = this.checksumLock;
        synchronized (object) {
            if (this.checksumRange != null && this.checksumRange.length > 0) {
                return Arrays.copyOf(this.checksumRange, this.checksumRange.length);
            }
            return new int[0];
        }
    }

    public int readUByte(int index) {
        if (!this.boundsCheck(index, 1)) {
            throw new IndexOutOfBoundsException("Index attempted to be read from is out of bounds: " + Integer.toHexString(index));
        }
        int b = this.array.get(this.boundOffset(index));
        if (b < 0) {
            throw new IndexOutOfBoundsException("Index attempted to be read from is out of bounds: " + Integer.toHexString(index));
        }
        return b;
    }

    public int readByte(int index) {
        if (!this.boundsCheck(index, 1)) {
            throw new IndexOutOfBoundsException("Index attempted to be read from is out of bounds: " + Integer.toHexString(index));
        }
        int b = this.array.get(this.boundOffset(index));
        if (b < 0) {
            throw new IndexOutOfBoundsException("Index attempted to be read from is out of bounds: " + Integer.toHexString(index));
        }
        return b << 24 >> 24;
    }

    public int readBytes(int index, byte[] b, int offset, int length) {
        int bytesRead = this.array.get(this.boundOffset(index), b, offset, this.boundLength(index, length));
        if (bytesRead < 0) {
            throw new IndexOutOfBoundsException("Index attempted to be read from is out of bounds: " + Integer.toHexString(index));
        }
        return bytesRead;
    }

    public int readChar(int index) {
        return this.readUByte(index);
    }

    public int readUShort(int index) {
        return 0xFFFF & (this.readUByte(index) << 8 | this.readUByte(index + 1));
    }

    public int readShort(int index) {
        return (this.readByte(index) << 8 | this.readUByte(index + 1)) << 16 >> 16;
    }

    public int readUInt24(int index) {
        return 0xFFFFFF & (this.readUByte(index) << 16 | this.readUByte(index + 1) << 8 | this.readUByte(index + 2));
    }

    public long readULong(int index) {
        return 0xFFFFFFFFL & (long)(this.readUByte(index) << 24 | this.readUByte(index + 1) << 16 | this.readUByte(index + 2) << 8 | this.readUByte(index + 3));
    }

    public int readULongAsInt(int index) {
        long ulong = this.readULong(index);
        if ((ulong & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            throw new ArithmeticException("Long value too large to fit into an integer.");
        }
        return (int)ulong;
    }

    public long readULongLE(int index) {
        return 0xFFFFFFFFL & (long)(this.readUByte(index) | this.readUByte(index + 1) << 8 | this.readUByte(index + 2) << 16 | this.readUByte(index + 3) << 24);
    }

    public int readLong(int index) {
        return this.readByte(index) << 24 | this.readUByte(index + 1) << 16 | this.readUByte(index + 2) << 8 | this.readUByte(index + 3);
    }

    public int readFixed(int index) {
        return this.readLong(index);
    }

    public BigDecimal readF2Dot14(int index) {
        throw new UnsupportedOperationException();
    }

    public long readDateTimeAsLong(int index) {
        return this.readULong(index) << 32 | this.readULong(index + 4);
    }

    public Date readLongDateTime(int index) {
        throw new UnsupportedOperationException();
    }

    public int readFUnit(int index) {
        throw new UnsupportedOperationException();
    }

    public int readFWord(int index) {
        return this.readShort(index);
    }

    public int readUFWord(int index) {
        return this.readUShort(index);
    }

    public int copyTo(OutputStream os) throws IOException {
        return this.array.copyTo(os, this.boundOffset(0), this.length());
    }

    public int copyTo(WritableFontData wfd) {
        return this.array.copyTo(wfd.boundOffset(0), wfd.array, this.boundOffset(0), this.length());
    }

    public int searchUShort(int startIndex, int startOffset, int endIndex, int endOffset, int length, int key) {
        int location = 0;
        int bottom = 0;
        int top = length;
        while (top != bottom) {
            location = (top + bottom) / 2;
            int locationStart = this.readUShort(startIndex + location * startOffset);
            if (key < locationStart) {
                top = location;
                continue;
            }
            int locationEnd = this.readUShort(endIndex + location * endOffset);
            if (key <= locationEnd) {
                return location;
            }
            bottom = location + 1;
        }
        return -1;
    }

    public int searchULong(int startIndex, int startOffset, int endIndex, int endOffset, int length, int key) {
        int location = 0;
        int bottom = 0;
        int top = length;
        while (top != bottom) {
            location = (top + bottom) / 2;
            int locationStart = this.readULongAsInt(startIndex + location * startOffset);
            if (key < locationStart) {
                top = location;
                continue;
            }
            int locationEnd = this.readULongAsInt(endIndex + location * endOffset);
            if (key <= locationEnd) {
                return location;
            }
            bottom = location + 1;
        }
        return -1;
    }

    public int searchUShort(int startIndex, int startOffset, int length, int key) {
        int location = 0;
        int bottom = 0;
        int top = length;
        while (top != bottom) {
            location = (top + bottom) / 2;
            int locationStart = this.readUShort(startIndex + location * startOffset);
            if (key < locationStart) {
                top = location;
                continue;
            }
            if (key > locationStart) {
                bottom = location + 1;
                continue;
            }
            return location;
        }
        return -1;
    }
}

