/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.opentype;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.opentype.SubstSubtable;
import com.google.typography.font.sfntly.table.opentype.component.NumRecordTable;
import com.google.typography.font.sfntly.table.opentype.component.RangeRecordTable;
import com.google.typography.font.sfntly.table.opentype.component.RecordsTable;

public class CoverageTable
extends SubstSubtable {
    public final RecordsTable<?> array;

    public CoverageTable(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data, base, dataIsCanonical);
        switch (this.format) {
            case 1: {
                this.array = new NumRecordTable(data, this.headerSize(), dataIsCanonical);
                break;
            }
            case 2: {
                this.array = new RangeRecordTable(data, this.headerSize(), dataIsCanonical);
                break;
            }
            default: {
                throw new IllegalArgumentException("coverage format " + this.format + " unexpected");
            }
        }
    }

    public NumRecordTable fmt1Table() {
        switch (this.format) {
            case 1: {
                return (NumRecordTable)this.array;
            }
        }
        throw new IllegalArgumentException("unexpected format table requested: " + this.format);
    }

    public RangeRecordTable fmt2Table() {
        switch (this.format) {
            case 2: {
                return (RangeRecordTable)this.array;
            }
        }
        throw new IllegalArgumentException("unexpected format table requested: " + this.format);
    }

    public static class Builder
    extends SubstSubtable.Builder<CoverageTable> {
        private final RecordsTable.Builder<?, ?> arrayBuilder;

        public Builder() {
            this.arrayBuilder = new NumRecordTable.Builder();
        }

        public Builder(ReadableFontData data, boolean dataIsCanonical) {
            super(data, dataIsCanonical);
            switch (this.format) {
                case 1: {
                    this.arrayBuilder = new NumRecordTable.Builder(data, this.headerSize(), dataIsCanonical);
                    break;
                }
                case 2: {
                    this.arrayBuilder = new RangeRecordTable.Builder(data, this.headerSize(), dataIsCanonical);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("coverage format " + this.format + " unexpected");
                }
            }
        }

        public Builder(CoverageTable table) {
            this(table.readFontData(), table.dataIsCanonical);
        }

        @Override
        public int subDataSizeToSerialize() {
            return super.subDataSizeToSerialize() + this.arrayBuilder.subDataSizeToSerialize();
        }

        @Override
        public int subSerialize(WritableFontData newData) {
            int newOffset = super.subSerialize(newData);
            return this.arrayBuilder.subSerialize(newData.slice(newOffset));
        }

        @Override
        protected CoverageTable subBuildTable(ReadableFontData data) {
            return new CoverageTable(data, 0, false);
        }

        @Override
        protected boolean subReadyToSerialize() {
            return super.subReadyToSerialize();
        }

        @Override
        public void subDataSet() {
            super.subDataSet();
            this.arrayBuilder.subDataSet();
        }
    }
}

