/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.opentype.component;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.SubTable;
import com.google.typography.font.sfntly.table.opentype.component.HeaderTable;
import com.google.typography.font.sfntly.table.opentype.component.TagOffsetRecord;
import com.google.typography.font.sfntly.table.opentype.component.TagOffsetRecordList;
import com.google.typography.font.sfntly.table.opentype.component.VisibleSubTable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public abstract class TagOffsetsTable<S extends SubTable>
extends HeaderTable
implements Iterable<S> {
    private final TagOffsetRecordList recordList;

    protected TagOffsetsTable(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data, base, dataIsCanonical);
        this.recordList = new TagOffsetRecordList(data.slice(this.headerSize() + base));
    }

    protected TagOffsetsTable(ReadableFontData data, boolean dataIsCanonical) {
        this(data, 0, dataIsCanonical);
    }

    public int count() {
        return this.recordList.count();
    }

    protected int tagAt(int index) {
        return ((TagOffsetRecord)this.recordList.get((int)index)).tag;
    }

    public S subTableAt(int index) {
        TagOffsetRecord record = (TagOffsetRecord)this.recordList.get(index);
        return this.subTableForRecord(record);
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            private Iterator<TagOffsetRecord> recordIterator;
            {
                this.recordIterator = TagOffsetsTable.this.recordList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.recordIterator.hasNext();
            }

            @Override
            public S next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                TagOffsetRecord record = this.recordIterator.next();
                return TagOffsetsTable.this.subTableForRecord(record);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected abstract S readSubTable(ReadableFontData var1, boolean var2);

    private S subTableForRecord(TagOffsetRecord record) {
        ReadableFontData newBase = this.data.slice(record.offset);
        return this.readSubTable(newBase, this.dataIsCanonical);
    }

    public static abstract class Builder<T extends HeaderTable, S extends SubTable>
    extends HeaderTable.Builder<T> {
        private TreeMap<Integer, VisibleSubTable.Builder<S>> builders;
        private int serializedLength;
        private int serializedCount;
        private final int base;

        protected Builder() {
            this.base = 0;
        }

        protected Builder(Builder<T, S> other) {
            this.builders = other.builders;
            this.dataIsCanonical = other.dataIsCanonical;
            this.base = other.base;
        }

        protected Builder(ReadableFontData data, int base, boolean dataIsCanonical) {
            super(data);
            this.base = base;
            this.dataIsCanonical = dataIsCanonical;
            if (!dataIsCanonical) {
                this.prepareToEdit();
            }
        }

        @Override
        public int subDataSizeToSerialize() {
            if (this.builders != null) {
                this.computeSizeFromBuilders();
            } else {
                this.computeSizeFromData(this.internalReadData().slice(this.headerSize() + this.base));
            }
            this.serializedLength += super.subDataSizeToSerialize();
            return this.serializedLength;
        }

        @Override
        public int subSerialize(WritableFontData newData) {
            if (this.serializedLength == 0) {
                return 0;
            }
            int writtenBytes = super.subSerialize(newData);
            if (this.builders != null) {
                return this.serializeFromBuilders(newData.slice(writtenBytes));
            }
            return this.serializeFromData(newData.slice(writtenBytes));
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        public void subDataSet() {
            this.builders = null;
        }

        @Override
        public T subBuildTable(ReadableFontData data) {
            return this.readTable(data, 0, true);
        }

        protected abstract T readTable(ReadableFontData var1, int var2, boolean var3);

        protected abstract VisibleSubTable.Builder<S> createSubTableBuilder();

        protected abstract VisibleSubTable.Builder<S> createSubTableBuilder(ReadableFontData var1, int var2, boolean var3);

        private void prepareToEdit() {
            if (this.builders == null) {
                this.initFromData(this.internalReadData(), this.headerSize() + this.base);
                this.setModelChanged();
            }
        }

        private void initFromData(ReadableFontData data, int base) {
            this.builders = new TreeMap();
            if (data == null) {
                return;
            }
            TagOffsetRecordList recordList = new TagOffsetRecordList(data = data.slice(base));
            if (recordList.count() == 0) {
                return;
            }
            int subTableLimit = recordList.limit();
            Iterator recordIterator = recordList.iterator();
            if (this.dataIsCanonical) {
                do {
                    int offset = subTableLimit;
                    TagOffsetRecord record = (TagOffsetRecord)recordIterator.next();
                    int tag = record.tag;
                    subTableLimit = record.offset;
                    int length = subTableLimit - offset;
                    VisibleSubTable.Builder<S> builder = this.createSubTableBuilder(data, offset, length, tag);
                    this.builders.put(tag, builder);
                } while (recordIterator.hasNext());
            } else {
                do {
                    TagOffsetRecord record = (TagOffsetRecord)recordIterator.next();
                    int offset = record.offset;
                    int tag = record.tag;
                    VisibleSubTable.Builder<S> builder = this.createSubTableBuilder(data, offset, -1, tag);
                    this.builders.put(tag, builder);
                } while (recordIterator.hasNext());
            }
        }

        private void computeSizeFromBuilders() {
            int len = 0;
            int count = 0;
            for (VisibleSubTable.Builder<S> builder : this.builders.values()) {
                int sublen = builder.subDataSizeToSerialize();
                if (sublen <= 0) continue;
                ++count;
                len += sublen;
            }
            if (len > 0) {
                len += TagOffsetRecordList.sizeOfListOfCount(count);
            }
            this.serializedLength = len;
            this.serializedCount = count;
        }

        private void computeSizeFromData(ReadableFontData data) {
            int len = 0;
            int count = 0;
            if (data != null) {
                len = data.length();
                count = new TagOffsetRecordList(data).count();
            }
            this.serializedLength = len;
            this.serializedCount = count;
        }

        private int serializeFromBuilders(WritableFontData newData) {
            int tableSize;
            int subTableFillPos = tableSize = TagOffsetRecordList.sizeOfListOfCount(this.serializedCount);
            TagOffsetRecordList recordList = new TagOffsetRecordList(newData);
            for (Map.Entry<Integer, VisibleSubTable.Builder<S>> entry : this.builders.entrySet()) {
                int tag = entry.getKey();
                VisibleSubTable.Builder<S> builder = entry.getValue();
                if (builder.serializedLength <= 0) continue;
                TagOffsetRecord record = new TagOffsetRecord(tag, subTableFillPos);
                recordList.add(record);
                subTableFillPos += builder.subSerialize(newData.slice(subTableFillPos));
            }
            recordList.writeTo(newData);
            return subTableFillPos;
        }

        private int serializeFromData(WritableFontData newData) {
            ReadableFontData data = this.internalReadData().slice(this.base);
            data.copyTo(newData);
            return data.length();
        }

        private VisibleSubTable.Builder<S> createSubTableBuilder(ReadableFontData data, int offset, int length, int tag) {
            boolean dataIsCanonical = length >= 0;
            ReadableFontData newData = dataIsCanonical ? data.slice(offset, length) : data.slice(offset);
            return this.createSubTableBuilder(newData, tag, dataIsCanonical);
        }
    }
}

