/*
 * Decompiled with CFR 0.152.
 */
package com.jaredsburrows.license;

import com.jaredsburrows.license.internal.ConsoleRenderer;
import com.jaredsburrows.license.internal.report.CsvReport;
import com.jaredsburrows.license.internal.report.HtmlReport;
import com.jaredsburrows.license.internal.report.JsonReport;
import com.jaredsburrows.license.internal.report.Report;
import com.jaredsburrows.license.internal.report.TextReport;
import java.io.File;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0010\u0018\u0000 f2\u00020\u0001:\u0001fB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010A\u001a\u00020B\"\b\b\u0000\u0010C*\u00020D2\u0006\u0010E\u001a\u00020\u00052\f\u0010F\u001a\b\u0012\u0004\u0012\u0002HC0GH\u0002J(\u0010H\u001a\u00020B\"\b\b\u0000\u0010C*\u00020D2\u0006\u0010E\u001a\u00020\u00052\f\u0010F\u001a\b\u0012\u0004\u0012\u0002HC0GH\u0002J0\u0010I\u001a\b\u0012\u0004\u0012\u00020J0\u00042\u0006\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010\u00052\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0002J*\u0010R\u001a\u00020,2\u0006\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010\u00052\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0002J \u0010S\u001a\u00020B2\u0006\u0010K\u001a\u00020L2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0002J\"\u0010T\u001a\u0004\u0018\u00010\u00052\u0006\u0010U\u001a\u0002072\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0002J\u001c\u0010V\u001a\b\u0012\u0004\u0012\u00020W0+2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Y0+H\u0002J\u0010\u0010Z\u001a\u00020B2\u0006\u0010N\u001a\u00020OH\u0002J\b\u0010[\u001a\u00020BH\u0007J\u0010\u0010\\\u001a\u00020B2\u0006\u0010N\u001a\u00020OH\u0002J\u000e\u0010]\u001a\u00020\u0010*\u0004\u0018\u00010\u0005H\u0002J\f\u0010^\u001a\u00020\u0010*\u00020,H\u0002J\f\u0010_\u001a\u00020,*\u000207H\u0002J\u0012\u0010`\u001a\b\u0012\u0004\u0012\u00020a0\u0004*\u000207H\u0002J\f\u0010b\u001a\u00020,*\u000207H\u0002J\f\u0010c\u001a\u00020,*\u000207H\u0002J\f\u0010d\u001a\u00020,*\u000207H\u0002J.\u0010e\u001a\u00020,*\u0002072\u0006\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010\u00052\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001e\u0010\u0018\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001e\u0010\u001b\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014R\u001e\u0010\u001e\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014R\u001e\u0010!\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0012\"\u0004\b#\u0010\u0014R\u001e\u0010$\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0012\"\u0004\b&\u0010\u0014R\u001e\u0010'\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0012\"\u0004\b)\u0010\u0014R$\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001c\u00101\u001a\u00020\u00058GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\f\"\u0004\b3\u0010\u000eR\u000e\u00104\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020706X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00109\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0012\"\u0004\b;\u0010\u0014R \u0010<\u001a\u0004\u0018\u00010,8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@\u00a8\u0006g"}, d2={"Lcom/jaredsburrows/license/LicenseReportTask;", "Lorg/gradle/api/DefaultTask;", "()V", "assetDirs", "", "Ljava/io/File;", "getAssetDirs", "()Ljava/util/List;", "setAssetDirs", "(Ljava/util/List;)V", "buildFile", "getBuildFile", "()Ljava/io/File;", "setBuildFile", "(Ljava/io/File;)V", "copyCsvReportToAssets", "", "getCopyCsvReportToAssets", "()Z", "setCopyCsvReportToAssets", "(Z)V", "copyHtmlReportToAssets", "getCopyHtmlReportToAssets", "setCopyHtmlReportToAssets", "copyJsonReportToAssets", "getCopyJsonReportToAssets", "setCopyJsonReportToAssets", "copyTextReportToAssets", "getCopyTextReportToAssets", "setCopyTextReportToAssets", "generateCsvReport", "getGenerateCsvReport", "setGenerateCsvReport", "generateHtmlReport", "getGenerateHtmlReport", "setGenerateHtmlReport", "generateJsonReport", "getGenerateJsonReport", "setGenerateJsonReport", "generateTextReport", "getGenerateTextReport", "setGenerateTextReport", "ignoredPatterns", "", "", "getIgnoredPatterns", "()Ljava/util/Set;", "setIgnoredPatterns", "(Ljava/util/Set;)V", "outputDir", "getOutputDir", "setOutputDir", "pomConfiguration", "projects", "", "Lorg/apache/maven/model/Model;", "tempPomConfiguration", "useVariantSpecificAssetDirs", "getUseVariantSpecificAssetDirs", "setUseVariantSpecificAssetDirs", "variantName", "getVariantName", "()Ljava/lang/String;", "setVariantName", "(Ljava/lang/String;)V", "copyReport", "", "T", "Lcom/jaredsburrows/license/internal/report/Report;", "file", "report", "Lkotlin/Function0;", "createReport", "findLicenses", "Lorg/apache/maven/model/License;", "mavenReader", "Lorg/apache/maven/model/io/xpp3/MavenXpp3Reader;", "pomFile", "configurations", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "dependencies", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "findVersion", "generatePOMInfo", "getParentPomFile", "model", "getResolvedArtifactsFromResolvedDependencies", "Lorg/gradle/api/artifacts/ResolvedArtifact;", "resolvedDependencies", "Lorg/gradle/api/artifacts/ResolvedDependency;", "initDependencies", "licenseReport", "setupEnvironment", "isNullOrEmpty", "isUrlValid", "pomDescription", "pomDevelopers", "Lorg/apache/maven/model/Developer;", "pomInceptionYear", "pomName", "pomUrl", "pomVersion", "Companion", "gradle-license-plugin"})
@SourceDebugExtension(value={"SMAP\nLicenseReportTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseReportTask.kt\ncom/jaredsburrows/license/LicenseReportTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,499:1\n1851#2,2:500\n766#2:503\n857#2,2:504\n1851#2,2:506\n766#2:508\n857#2,2:509\n1549#2:511\n1620#2,3:512\n1549#2:515\n1620#2,3:516\n1549#2:519\n1620#2,3:520\n1360#2:523\n1446#2,5:524\n1851#2,2:529\n766#2:531\n857#2,2:532\n766#2:534\n857#2:535\n2620#2,3:536\n858#2:539\n1549#2:540\n1620#2,3:541\n1002#2,2:544\n1851#2,2:546\n288#2,2:548\n1851#2,2:550\n1851#2,2:552\n1851#2,2:554\n1#3:502\n*S KotlinDebug\n*F\n+ 1 LicenseReportTask.kt\ncom/jaredsburrows/license/LicenseReportTask\n*L\n159#1:500,2\n184#1:503\n184#1:504,2\n185#1:506,2\n189#1:508\n189#1:509,2\n190#1:511\n190#1:512,3\n191#1:515\n191#1:516,3\n192#1:519\n192#1:520,3\n193#1:523\n193#1:524,5\n194#1:529,2\n215#1:531\n215#1:532,2\n217#1:534\n217#1:535\n219#1:536,3\n217#1:539\n221#1:540\n221#1:541,3\n251#1:544,2\n258#1:546,2\n304#1:548,2\n335#1:550,2\n418#1:552,2\n482#1:554,2\n*E\n"})
public class LicenseReportTask
extends DefaultTask {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Input
    @NotNull
    private List<? extends File> assetDirs = CollectionsKt.emptyList();
    @Optional
    @Input
    @Nullable
    private String variantName;
    @InputFile
    @Nullable
    private File buildFile;
    public File outputDir;
    @Input
    private boolean generateCsvReport;
    @Input
    private boolean generateHtmlReport;
    @Input
    private boolean generateJsonReport;
    @Input
    private boolean generateTextReport;
    @Input
    private boolean copyCsvReportToAssets;
    @Input
    private boolean copyHtmlReportToAssets;
    @Input
    private boolean copyJsonReportToAssets;
    @Input
    private boolean copyTextReportToAssets;
    @Input
    private boolean useVariantSpecificAssetDirs;
    @Input
    @NotNull
    private Set<String> ignoredPatterns = SetsKt.emptySet();
    @NotNull
    private final List<Model> projects = new ArrayList();
    @NotNull
    private String pomConfiguration = "poms";
    @NotNull
    private String tempPomConfiguration = "tempPoms";
    @NotNull
    private static final String ANDROID_SUPPORT_GROUP_ID = "com.android.support";
    @NotNull
    private static final String APACHE_LICENSE_NAME = "The Apache Software License";
    @NotNull
    private static final String APACHE_LICENSE_URL = "http://www.apache.org/licenses/LICENSE-2.0.txt";
    @NotNull
    private static final String OPEN_SOURCE_LICENSES = "open_source_licenses";

    public LicenseReportTask() {
        this.setDescription("Outputs licenses report for " + this.getName() + '.');
        this.setGroup("Reporting");
    }

    @NotNull
    public final List<File> getAssetDirs() {
        return this.assetDirs;
    }

    public final void setAssetDirs(@NotNull List<? extends File> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.assetDirs = list;
    }

    @Nullable
    public final String getVariantName() {
        return this.variantName;
    }

    public final void setVariantName(@Nullable String string) {
        this.variantName = string;
    }

    @Nullable
    public final File getBuildFile() {
        return this.buildFile;
    }

    public final void setBuildFile(@Nullable File file) {
        this.buildFile = file;
    }

    @OutputDirectory
    @NotNull
    public final File getOutputDir() {
        File file = this.outputDir;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        return null;
    }

    public final void setOutputDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.outputDir = file;
    }

    public final boolean getGenerateCsvReport() {
        return this.generateCsvReport;
    }

    public final void setGenerateCsvReport(boolean bl) {
        this.generateCsvReport = bl;
    }

    public final boolean getGenerateHtmlReport() {
        return this.generateHtmlReport;
    }

    public final void setGenerateHtmlReport(boolean bl) {
        this.generateHtmlReport = bl;
    }

    public final boolean getGenerateJsonReport() {
        return this.generateJsonReport;
    }

    public final void setGenerateJsonReport(boolean bl) {
        this.generateJsonReport = bl;
    }

    public final boolean getGenerateTextReport() {
        return this.generateTextReport;
    }

    public final void setGenerateTextReport(boolean bl) {
        this.generateTextReport = bl;
    }

    public final boolean getCopyCsvReportToAssets() {
        return this.copyCsvReportToAssets;
    }

    public final void setCopyCsvReportToAssets(boolean bl) {
        this.copyCsvReportToAssets = bl;
    }

    public final boolean getCopyHtmlReportToAssets() {
        return this.copyHtmlReportToAssets;
    }

    public final void setCopyHtmlReportToAssets(boolean bl) {
        this.copyHtmlReportToAssets = bl;
    }

    public final boolean getCopyJsonReportToAssets() {
        return this.copyJsonReportToAssets;
    }

    public final void setCopyJsonReportToAssets(boolean bl) {
        this.copyJsonReportToAssets = bl;
    }

    public final boolean getCopyTextReportToAssets() {
        return this.copyTextReportToAssets;
    }

    public final void setCopyTextReportToAssets(boolean bl) {
        this.copyTextReportToAssets = bl;
    }

    public final boolean getUseVariantSpecificAssetDirs() {
        return this.useVariantSpecificAssetDirs;
    }

    public final void setUseVariantSpecificAssetDirs(boolean bl) {
        this.useVariantSpecificAssetDirs = bl;
    }

    @NotNull
    public final Set<String> getIgnoredPatterns() {
        return this.ignoredPatterns;
    }

    public final void setIgnoredPatterns(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.ignoredPatterns = set;
    }

    @TaskAction
    public final void licenseReport() {
        CharSequence charSequence;
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        ConfigurationContainer configurationContainer = this.getProject().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
        ConfigurationContainer configurations = configurationContainer;
        DependencyHandler dependencyHandler = this.getProject().getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyHandler, (String)"project.dependencies");
        DependencyHandler dependencies = dependencyHandler;
        this.setupEnvironment(configurations);
        this.initDependencies(configurations);
        this.generatePOMInfo(mavenReader, configurations, dependencies);
        if (this.generateCsvReport) {
            CsvReport csvReport = new CsvReport(this.projects);
            File csvFile = new File(this.getOutputDir(), this.getName() + '.' + csvReport.extension());
            this.createReport(csvFile, (Function0)new Function0<CsvReport>(csvReport){
                final /* synthetic */ CsvReport $csvReport;
                {
                    this.$csvReport = $csvReport;
                    super(0);
                }

                @NotNull
                public final CsvReport invoke() {
                    return this.$csvReport;
                }
            });
            charSequence = this.variantName;
            if (!(charSequence == null || charSequence.length() == 0) && this.copyCsvReportToAssets) {
                this.copyReport(csvFile, (Function0)new Function0<CsvReport>(csvReport){
                    final /* synthetic */ CsvReport $csvReport;
                    {
                        this.$csvReport = $csvReport;
                        super(0);
                    }

                    @NotNull
                    public final CsvReport invoke() {
                        return this.$csvReport;
                    }
                });
            }
        }
        if (this.generateHtmlReport) {
            HtmlReport htmlReport = new HtmlReport(this.projects);
            File htmlFile = new File(this.getOutputDir(), this.getName() + '.' + htmlReport.extension());
            this.createReport(htmlFile, (Function0)new Function0<HtmlReport>(htmlReport){
                final /* synthetic */ HtmlReport $htmlReport;
                {
                    this.$htmlReport = $htmlReport;
                    super(0);
                }

                @NotNull
                public final HtmlReport invoke() {
                    return this.$htmlReport;
                }
            });
            charSequence = this.variantName;
            if (!(charSequence == null || charSequence.length() == 0) && this.copyHtmlReportToAssets) {
                this.copyReport(htmlFile, (Function0)new Function0<HtmlReport>(htmlReport){
                    final /* synthetic */ HtmlReport $htmlReport;
                    {
                        this.$htmlReport = $htmlReport;
                        super(0);
                    }

                    @NotNull
                    public final HtmlReport invoke() {
                        return this.$htmlReport;
                    }
                });
            }
        }
        if (this.generateJsonReport) {
            JsonReport jsonReport = new JsonReport(this.projects);
            File jsonFile = new File(this.getOutputDir(), this.getName() + '.' + jsonReport.extension());
            this.createReport(jsonFile, (Function0)new Function0<JsonReport>(jsonReport){
                final /* synthetic */ JsonReport $jsonReport;
                {
                    this.$jsonReport = $jsonReport;
                    super(0);
                }

                @NotNull
                public final JsonReport invoke() {
                    return this.$jsonReport;
                }
            });
            charSequence = this.variantName;
            if (!(charSequence == null || charSequence.length() == 0) && this.copyJsonReportToAssets) {
                this.copyReport(jsonFile, (Function0)new Function0<JsonReport>(jsonReport){
                    final /* synthetic */ JsonReport $jsonReport;
                    {
                        this.$jsonReport = $jsonReport;
                        super(0);
                    }

                    @NotNull
                    public final JsonReport invoke() {
                        return this.$jsonReport;
                    }
                });
            }
        }
        if (this.generateTextReport) {
            TextReport textReport = new TextReport(this.projects);
            File textFile = new File(this.getOutputDir(), this.getName() + '.' + textReport.extension());
            this.createReport(textFile, (Function0)new Function0<TextReport>(textReport){
                final /* synthetic */ TextReport $textReport;
                {
                    this.$textReport = $textReport;
                    super(0);
                }

                @NotNull
                public final TextReport invoke() {
                    return this.$textReport;
                }
            });
            charSequence = this.variantName;
            if (!(charSequence == null || charSequence.length() == 0) && this.copyTextReportToAssets) {
                this.copyReport(textFile, (Function0)new Function0<TextReport>(textReport){
                    final /* synthetic */ TextReport $textReport;
                    {
                        this.$textReport = $textReport;
                        super(0);
                    }

                    @NotNull
                    public final TextReport invoke() {
                        return this.$textReport;
                    }
                });
            }
        }
    }

    private final void setupEnvironment(ConfigurationContainer configurations) {
        ConfigurationContainer configurationContainer;
        StringBuilder stringBuilder = new StringBuilder().append(this.pomConfiguration);
        String string = this.variantName;
        if (string == null) {
            string = "";
        }
        this.pomConfiguration = stringBuilder.append(string).append(UUID.randomUUID()).toString();
        StringBuilder stringBuilder2 = new StringBuilder().append(this.tempPomConfiguration);
        String string2 = this.variantName;
        if (string2 == null) {
            string2 = "";
        }
        this.tempPomConfiguration = stringBuilder2.append(string2).append(UUID.randomUUID()).toString();
        ConfigurationContainer $this$setupEnvironment_u24lambda_u241 = configurationContainer = configurations;
        boolean bl = false;
        $this$setupEnvironment_u24lambda_u241.create(this.pomConfiguration);
        Iterable $this$forEach$iv = (Iterable)$this$setupEnvironment_u24lambda_u241;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Configuration configuration = (Configuration)element$iv;
            boolean bl2 = false;
            try {
                configuration.setCanBeResolved(true);
            }
            catch (Exception e) {
                this.getLogger().warn("Cannot resolve configuration " + configuration.getName(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initDependencies(ConfigurationContainer configurations) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable $this$forEach$iv;
        Object element$iv$iv2;
        Object $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Configuration configuration;
        Object it;
        String variant;
        LinkedHashSet configurationSet = new LinkedHashSet();
        Object object = new String[]{"api", "compile", "implementation"};
        List configurationList = CollectionsKt.mutableListOf((Object[])object);
        String string = this.variantName;
        if (string != null) {
            Object v1;
            block11: {
                variant = string;
                boolean bl = false;
                Iterable iterable = (Iterable)configurations;
                for (Object t : iterable) {
                    it = (Configuration)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)(variant + "RuntimeClasspath"))) continue;
                    v1 = t;
                    break block11;
                }
                v1 = null;
            }
            configuration = v1;
            if (configuration != null) {
                Configuration configuration2;
                Configuration it2 = configuration2 = configuration;
                boolean bl = false;
                ((Collection)configurationList).add(it2.getName());
            }
        }
        object = (Iterable)configurations;
        boolean $i$f$filter = false;
        variant = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv2 = bl.next();
            it = (Configuration)element$iv$iv2;
            boolean bl3 = false;
            if (!configurationList.contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Configuration it3 = (Configuration)element$iv;
            boolean bl4 = false;
            ((Collection)configurationSet).add(it3);
        }
        $this$forEach$iv = configurationSet;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl4 = $this$filterTo$iv$iv.iterator();
        while (bl4.hasNext()) {
            element$iv$iv2 = bl4.next();
            it = (Configuration)element$iv$iv2;
            boolean bl5 = false;
            if (!it.isCanBeResolved()) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Configuration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl6 = false;
            collection.add(it.getResolvedConfiguration());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResolvedConfiguration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl7 = false;
            collection.add(it.getLenientConfiguration());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (LenientConfiguration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl8 = false;
            collection.add(it.getAllModuleDependencies());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            it = (Set)element$iv$iv2;
            boolean bl9 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Iterable list$iv$iv = this.getResolvedArtifactsFromResolvedDependencies((Set<? extends ResolvedDependency>)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolvedArtifact artifact = (ResolvedArtifact)element$iv;
            boolean bl10 = false;
            ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
            String gav = id.getGroup() + ':' + id.getName() + ':' + id.getVersion() + "@pom";
            DependencySet dependencySet = configurations.getByName(this.pomConfiguration).getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"configurations\n         \u2026)\n          .dependencies");
            Collection collection2 = (Collection)dependencySet;
            configuration = this.getProject().getDependencies().add(this.pomConfiguration, (Object)gav);
            collection2.add(configuration);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generatePOMInfo(MavenXpp3Reader mavenReader, ConfigurationContainer configurations, DependencyHandler dependencies) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ResolvedArtifact artifact;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Set set = configurations.getByName(this.pomConfiguration).getResolvedConfiguration().getLenientConfiguration().getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"configurations\n      .ge\u2026guration\n      .artifacts");
        Iterable iterable = set;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResolvedArtifact it = (ResolvedArtifact)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)"pom")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block10: {
                artifact = (ResolvedArtifact)element$iv$iv;
                boolean bl2 = false;
                ModuleVersionIdentifier $this$generatePOMInfo_u24lambda_u2416_u24lambda_u2414 = artifact.getModuleVersion().getId();
                boolean bl3 = false;
                String depString = $this$generatePOMInfo_u24lambda_u2416_u24lambda_u2414.getGroup() + ':' + $this$generatePOMInfo_u24lambda_u2416_u24lambda_u2414.getName() + ':' + $this$generatePOMInfo_u24lambda_u2416_u24lambda_u2414.getVersion();
                Iterable $this$none$iv = this.ignoredPatterns;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl4 = false;
                        if (!StringsKt.contains$default((CharSequence)depString, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Model model;
            artifact = (ResolvedArtifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File pomFile = artifact.getFile();
            Model model2 = mavenReader.read((Reader)ReaderFactory.newXmlReader((File)pomFile), false);
            List licenses = null;
            licenses = this.findLicenses(mavenReader, pomFile, configurations, dependencies);
            if (licenses.isEmpty()) {
                this.getLogger().warn(this.getName() + " dependency does not have a license.");
                licenses = new ArrayList();
            }
            ModuleVersionIdentifier module = artifact.getModuleVersion().getId();
            Model $this$generatePOMInfo_u24lambda_u2418_u24lambda_u2417 = model = new Model();
            boolean bl5 = false;
            String string = module.getGroup();
            if (string == null) {
                string = "";
            }
            $this$generatePOMInfo_u24lambda_u2418_u24lambda_u2417.setGroupId(((Object)StringsKt.trim((CharSequence)string)).toString());
            String string2 = module.getName();
            if (string2 == null) {
                string2 = "";
            }
            $this$generatePOMInfo_u24lambda_u2418_u24lambda_u2417.setArtifactId(((Object)StringsKt.trim((CharSequence)string2)).toString());
            Intrinsics.checkNotNullExpressionValue((Object)model2, (String)"model");
            $this$generatePOMInfo_u24lambda_u2418_u24lambda_u2417.setVersion(this.pomVersion(model2, mavenReader, pomFile, configurations, dependencies));
            $this$generatePOMInfo_u24lambda_u2418_u24lambda_u2417.setName(this.pomName(model2));
            $this$generatePOMInfo_u24lambda_u2418_u24lambda_u2417.setDescription(this.pomDescription(model2));
            $this$generatePOMInfo_u24lambda_u2418_u24lambda_u2417.setUrl(this.pomUrl(model2));
            $this$generatePOMInfo_u24lambda_u2418_u24lambda_u2417.setInceptionYear(this.pomInceptionYear(model2));
            $this$generatePOMInfo_u24lambda_u2418_u24lambda_u2417.setLicenses(licenses);
            $this$generatePOMInfo_u24lambda_u2418_u24lambda_u2417.setDevelopers(this.pomDevelopers(model2));
            Model project = model;
            ((Collection)this.projects).add(project);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        List<Model> $this$sortBy$iv = this.projects;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b) {
                    Model it = (Model)a2;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    String string2 = string;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                    String string3 = string2.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                    it = (Model)b;
                    Comparable comparable = (Comparable)((Object)string3);
                    bl = false;
                    String string4 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.name");
                    string2 = string4;
                    Locale locale2 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
                    String string5 = string2.toLowerCase(locale2);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(locale)");
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string5)));
                }
            });
        }
    }

    private final Set<ResolvedArtifact> getResolvedArtifactsFromResolvedDependencies(Set<? extends ResolvedDependency> resolvedDependencies) {
        HashSet resolvedArtifacts = new HashSet();
        Iterable $this$forEach$iv = resolvedDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolvedDependency resolvedDependency = (ResolvedDependency)element$iv;
            boolean bl = false;
            try {
                Collection collection;
                if (Intrinsics.areEqual((Object)resolvedDependency.getModuleVersion(), (Object)"unspecified")) {
                    collection = resolvedArtifacts;
                    Set set = resolvedDependency.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"resolvedDependency.children");
                    CollectionsKt.addAll((Collection)collection, (Iterable)this.getResolvedArtifactsFromResolvedDependencies(set));
                    continue;
                }
                collection = resolvedArtifacts;
                Set set = resolvedDependency.getAllModuleArtifacts();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"resolvedDependency.allModuleArtifacts");
                CollectionsKt.addAll((Collection)collection, (Iterable)set);
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to process " + resolvedDependency.getName(), (Throwable)e);
            }
        }
        return resolvedArtifacts;
    }

    /*
     * WARNING - void declaration
     */
    private final File getParentPomFile(Model model, ConfigurationContainer configurations, DependencyHandler dependencies) {
        Object v8;
        Collection collection;
        block4: {
            void $this$firstOrNull$iv;
            Parent parent;
            Parent parent2 = parent = model.getParent();
            String string = parent2 != null ? parent2.getGroupId() : null;
            if (string == null) {
                string = "";
            }
            String groupId = string;
            Parent parent3 = parent;
            String string2 = parent3 != null ? parent3.getArtifactId() : null;
            if (string2 == null) {
                string2 = "";
            }
            String artifactId = string2;
            Parent parent4 = parent;
            String string3 = parent4 != null ? parent4.getVersion() : null;
            if (string3 == null) {
                string3 = "";
            }
            String version = string3;
            String dependency = groupId + ':' + artifactId + ':' + version + "@pom";
            configurations.create(this.tempPomConfiguration);
            DependencySet dependencySet = configurations.getByName(this.tempPomConfiguration).getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"configurations\n      .ge\u2026tion)\n      .dependencies");
            collection = (Collection)dependencySet;
            Object object = dependencies.add(this.tempPomConfiguration, (Object)dependency);
            collection.add(object);
            Set set = configurations.getByName(this.tempPomConfiguration).getResolvedConfiguration().getLenientConfiguration().getArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"configurations\n      .ge\u2026guration\n      .artifacts");
            object = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ResolvedArtifact it = (ResolvedArtifact)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"pom")) continue;
                v8 = element$iv;
                break block4;
            }
            v8 = null;
        }
        collection = v8;
        File pomFile = collection != null ? collection.getFile() : null;
        configurations.remove((Object)configurations.getByName(this.tempPomConfiguration));
        return pomFile;
    }

    private final <T extends Report> void createReport(File file, Function0<? extends T> report) {
        File file2;
        Report newReport = (Report)report.invoke();
        File $this$createReport_u24lambda_u2422 = file2 = file;
        boolean bl = false;
        $this$createReport_u24lambda_u2422.delete();
        $this$createReport_u24lambda_u2422.getParentFile().mkdirs();
        FilesKt.writeText$default((File)$this$createReport_u24lambda_u2422, (String)newReport.toString(), null, (int)2, null);
        this.getLogger().lifecycle("Wrote " + newReport.name() + " report to " + new ConsoleRenderer().asClickableFileUrl(file) + '.');
    }

    private final <T extends Report> void copyReport(File file, Function0<? extends T> report) {
        Report newReport = (Report)report.invoke();
        Iterable $this$forEach$iv = this.assetDirs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File licenseFile;
            File file2;
            File directory = (File)element$iv;
            boolean bl = false;
            File $this$copyReport_u24lambda_u2424_u24lambda_u2423 = file2 = (licenseFile = new File(directory.getPath(), "open_source_licenses." + newReport.extension()));
            boolean bl2 = false;
            $this$copyReport_u24lambda_u2424_u24lambda_u2423.delete();
            $this$copyReport_u24lambda_u2424_u24lambda_u2423.getParentFile().mkdirs();
            FilesKt.writeText$default((File)$this$copyReport_u24lambda_u2424_u24lambda_u2423, (String)FilesKt.readText$default((File)file, null, (int)1, null), null, (int)2, null);
            this.getLogger().lifecycle("Copied " + newReport.name() + " report to " + new ConsoleRenderer().asClickableFileUrl(licenseFile) + '.');
        }
    }

    private final String findVersion(MavenXpp3Reader mavenReader, File pomFile, ConfigurationContainer configurations, DependencyHandler dependencies) {
        String version;
        if (this.isNullOrEmpty(pomFile)) {
            return "";
        }
        Model model = mavenReader.read((Reader)ReaderFactory.newXmlReader((File)pomFile), false);
        Intrinsics.checkNotNullExpressionValue((Object)model, (String)"model");
        String name = this.pomName(model);
        if (((CharSequence)name).length() == 0) {
            this.getLogger().warn("POM file is missing a name: " + pomFile);
            return "";
        }
        String string = model.getVersion();
        if (string == null) {
            string = "";
        }
        if (((CharSequence)(version = ((Object)StringsKt.trim((CharSequence)string)).toString())).length() > 0) {
            return ((Object)StringsKt.trim((CharSequence)version)).toString();
        }
        String string2 = model.getParent().getArtifactId();
        if (string2 == null) {
            string2 = "";
        }
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString()).length() > 0) {
            return this.findVersion(mavenReader, this.getParentPomFile(model, configurations, dependencies), configurations, dependencies);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private final List<License> findLicenses(MavenXpp3Reader mavenReader, File pomFile, ConfigurationContainer configurations, DependencyHandler dependencies) {
        if (this.isNullOrEmpty(pomFile)) {
            return new ArrayList();
        }
        Model model = mavenReader.read((Reader)ReaderFactory.newXmlReader((File)pomFile), false);
        Intrinsics.checkNotNullExpressionValue((Object)model, (String)"model");
        String name = this.pomName(model);
        if (((CharSequence)name).length() == 0) {
            this.getLogger().warn("POM file is missing a name: " + pomFile);
            return new ArrayList();
        }
        String string = model.getGroupId();
        if (string == null) {
            string = "";
        }
        if (Intrinsics.areEqual((Object)ANDROID_SUPPORT_GROUP_ID, (Object)((Object)StringsKt.trim((CharSequence)string)).toString())) {
            License license;
            License $this$findLicenses_u24lambda_u2425 = license = new License();
            boolean bl = false;
            $this$findLicenses_u24lambda_u2425.setName(APACHE_LICENSE_NAME);
            $this$findLicenses_u24lambda_u2425.setUrl(APACHE_LICENSE_URL);
            return CollectionsKt.listOf((Object)license);
        }
        List list = model.getLicenses();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if (!((Collection)list).isEmpty()) {
            void $this$forEach$iv;
            List licenses = new ArrayList();
            List list2 = model.getLicenses();
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterable $this$findLicenses_u24lambda_u2425 = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                License license;
                String licenseUrl;
                License license2 = (License)element$iv;
                boolean bl = false;
                String string2 = license2.getName();
                if (string2 == null) {
                    string2 = "";
                }
                String licenseName = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                String string3 = license2.getUrl();
                if (string3 == null) {
                    string3 = "";
                }
                if (!this.isUrlValid(licenseUrl = ((Object)StringsKt.trim((CharSequence)string3)).toString())) continue;
                Collection collection = licenses;
                License $this$findLicenses_u24lambda_u2427_u24lambda_u2426 = license = new License();
                boolean bl2 = false;
                $this$findLicenses_u24lambda_u2427_u24lambda_u2426.setName(licenseName);
                $this$findLicenses_u24lambda_u2427_u24lambda_u2426.setUrl(licenseUrl);
                collection.add(license);
            }
            return licenses;
        }
        this.getLogger().info("Project, " + name + ", has no license in POM file.");
        Parent parent = model.getParent();
        String string4 = parent != null ? parent.getArtifactId() : null;
        if (string4 == null) {
            string4 = "";
        }
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)string4)).toString()).length() > 0) {
            return this.findLicenses(mavenReader, this.getParentPomFile(model, configurations, dependencies), configurations, dependencies);
        }
        return new ArrayList();
    }

    private final boolean isUrlValid(String $this$isUrlValid) {
        URI uri = null;
        try {
            uri = new URL($this$isUrlValid).toURI();
        }
        catch (Exception e) {
            this.getLogger().warn($this$isUrlValid + " dependency has an invalid license URL; skipping license", (Throwable)e);
        }
        return uri != null;
    }

    private final String pomVersion(Model $this$pomVersion, MavenXpp3Reader mavenReader, File pomFile, ConfigurationContainer configurations, DependencyHandler dependencies) {
        CharSequence charSequence;
        CharSequence charSequence2;
        String string = $this$pomVersion.getVersion();
        if (string == null) {
            string = "";
        }
        if ((charSequence2 = (CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString()).length() == 0) {
            boolean bl = false;
            charSequence = this.findVersion(mavenReader, pomFile, configurations, dependencies);
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private final String pomName(Model $this$pomName) {
        CharSequence charSequence;
        CharSequence charSequence2;
        String string = $this$pomName.getName();
        if (string == null) {
            string = "";
        }
        if ((charSequence2 = (CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString()).length() == 0) {
            boolean bl = false;
            String string2 = $this$pomName.getArtifactId();
            if (string2 == null) {
                string2 = "";
            }
            charSequence = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private final String pomDescription(Model $this$pomDescription) {
        String string = $this$pomDescription.getDescription();
        if (string == null) {
            string = "";
        }
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private final String pomUrl(Model $this$pomUrl) {
        String string = $this$pomUrl.getUrl();
        if (string == null) {
            string = "";
        }
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private final String pomInceptionYear(Model $this$pomInceptionYear) {
        String string = $this$pomInceptionYear.getInceptionYear();
        if (string == null) {
            string = "";
        }
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private final List<Developer> pomDevelopers(Model $this$pomDevelopers) {
        List developers = new ArrayList();
        List list = $this$pomDevelopers.getDevelopers();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Developer developer;
            Developer developer2 = (Developer)element$iv;
            boolean bl = false;
            Collection collection = developers;
            Developer $this$pomDevelopers_u24lambda_u2431_u24lambda_u2430 = developer = new Developer();
            boolean bl2 = false;
            String string = developer2.getName();
            if (string == null) {
                string = "";
            }
            $this$pomDevelopers_u24lambda_u2431_u24lambda_u2430.setId(((Object)StringsKt.trim((CharSequence)string)).toString());
            collection.add(developer);
        }
        return developers;
    }

    private final boolean isNullOrEmpty(File $this$isNullOrEmpty) {
        return $this$isNullOrEmpty == null || $this$isNullOrEmpty.length() == 0L;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jaredsburrows/license/LicenseReportTask$Companion;", "", "()V", "ANDROID_SUPPORT_GROUP_ID", "", "APACHE_LICENSE_NAME", "APACHE_LICENSE_URL", "OPEN_SOURCE_LICENSES", "gradle-license-plugin"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

