/*
 * Decompiled with CFR 0.152.
 */
package com.jashmore.sqs.util.annotation;

import com.jashmore.sqs.argument.MethodParameter;
import com.jashmore.sqs.util.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;

public final class AnnotationUtils {
    public static <A extends Annotation> Optional<A> findMethodAnnotation(Method methodToProcess, Class<A> annotationClass) {
        Preconditions.checkNotNull((Object)methodToProcess, (String)"methodToProcess should not be null");
        Preconditions.checkNotNull(annotationClass, (String)"annotationClass should not be null");
        return AnnotationUtils.findForEachChainedMethodStack(methodToProcess, method -> Optional.ofNullable(method.getAnnotation(annotationClass)));
    }

    public static <A extends Annotation> Optional<A> findParameterAnnotation(MethodParameter methodParameterToProcess, Class<A> annotationClass) {
        return AnnotationUtils.findForEachChainedMethodStack(methodParameterToProcess.getMethod(), method -> Optional.ofNullable(method.getParameters()[methodParameterToProcess.getParameterIndex()].getAnnotation(annotationClass)));
    }

    private static <T> Optional<T> findForEachChainedMethodStack(Method method, Function<Method, Optional<T>> methodVisitor) {
        Optional<T> matchedValue = methodVisitor.apply(method);
        if (matchedValue.isPresent()) {
            return matchedValue;
        }
        Class<?> methodClass = method.getDeclaringClass();
        Class<?> superClass = methodClass.getSuperclass();
        if (superClass == Object.class || superClass == null) {
            return Optional.empty();
        }
        try {
            Method superClassMethod = superClass.getMethod(method.getName(), method.getParameterTypes());
            return AnnotationUtils.findForEachChainedMethodStack(superClassMethod, methodVisitor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return Optional.empty();
        }
    }

    @Generated
    private AnnotationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

