/*
 * Decompiled with CFR 0.152.
 */
package com.jashmore.sqs.util.properties;

import java.time.Duration;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropertyUtils.class);

    public static long safelyGetLongValue(String propertyName, Supplier<Long> valueSupplier, long defaultValue) {
        return PropertyUtils.safelyGetValue(propertyName, valueSupplier, defaultValue, aLong -> true);
    }

    public static long safelyGetPositiveLongValue(String propertyName, Supplier<Long> valueSupplier, long defaultValue) {
        return PropertyUtils.safelyGetValue(propertyName, valueSupplier, defaultValue, aLong -> aLong > 0L);
    }

    public static long safelyGetPositiveOrZeroLongValue(String propertyName, Supplier<Long> valueSupplier, long defaultValue) {
        return PropertyUtils.safelyGetValue(propertyName, valueSupplier, defaultValue, aLong -> aLong >= 0L);
    }

    public static int safelyGetIntegerValue(String propertyName, Supplier<Integer> valueSupplier, int defaultValue) {
        return PropertyUtils.safelyGetValue(propertyName, valueSupplier, defaultValue, aInteger -> true);
    }

    public static int safelyGetPositiveIntegerValue(String propertyName, Supplier<Integer> valueSupplier, int defaultValue) {
        return PropertyUtils.safelyGetValue(propertyName, valueSupplier, defaultValue, aInteger -> aInteger > 0);
    }

    public static int safelyGetPositiveOrZeroIntegerValue(String propertyName, Supplier<Integer> valueSupplier, int defaultValue) {
        return PropertyUtils.safelyGetValue(propertyName, valueSupplier, defaultValue, aInteger -> aInteger >= 0);
    }

    public static Duration safelyGetPositiveOrZeroDuration(String propertyName, Supplier<Duration> valueSupplier, Duration defaultValue) {
        return PropertyUtils.safelyGetValue(propertyName, valueSupplier, defaultValue, duration -> !duration.isNegative());
    }

    private static <T> T safelyGetValue(String propertyName, Supplier<T> valueSupplier, T defaultValue, Predicate<T> valueValidator) {
        try {
            return (T)Optional.ofNullable(valueSupplier.get()).filter(value -> {
                if (!valueValidator.test(value)) {
                    log.error("Invalid value {} for property {} returning default value {}", new Object[]{value, propertyName, defaultValue});
                    return false;
                }
                return true;
            }).orElse(defaultValue);
        }
        catch (RuntimeException throwable) {
            log.error("Error obtaining Property value {} returning default value {}", new Object[]{propertyName, defaultValue, throwable});
            return defaultValue;
        }
    }

    @Generated
    private PropertyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

