/*
 * Decompiled with CFR 0.152.
 */
package com.jashmore.sqs.util.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;

public final class CollectionUtils {
    public static <T> List<T> immutableListOf(T element) {
        return Collections.singletonList(element);
    }

    public static <T> List<T> immutableListOf(T one, T two) {
        return Collections.unmodifiableList(Arrays.asList(one, two));
    }

    public static <T> List<T> immutableListOf(T one, T two, T three) {
        return Collections.unmodifiableList(Arrays.asList(one, two, three));
    }

    public static <T> List<T> immutableListOf(T one, T two, T three, T four) {
        return Collections.unmodifiableList(Arrays.asList(one, two, three, four));
    }

    public static <T> List<T> immutableListOf(T one, T two, T three, T four, T five) {
        return Collections.unmodifiableList(Arrays.asList(one, two, three, four, five));
    }

    public static <T> List<T> immutableListFrom(Collection<T> one, Collection<T> two) {
        ArrayList<T> underlyingList = new ArrayList<T>(one.size() + two.size());
        underlyingList.addAll(one);
        underlyingList.addAll(two);
        return Collections.unmodifiableList(underlyingList);
    }

    public static <T, S> Map<T, S> immutableMapOf(T keyOne, S valueOne, T keyTwo, S valueTwo) {
        HashMap<T, S> internalMap = new HashMap<T, S>();
        internalMap.put(keyOne, valueOne);
        internalMap.put(keyTwo, valueTwo);
        return Collections.unmodifiableMap(internalMap);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> pairsToMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    @Generated
    private CollectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

