/*
 * Decompiled with CFR 0.152.
 */
package com.jashmore.sqs.util.collections;

import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public final class QueueUtils {
    public static <T> void drain(BlockingQueue<T> queue, Collection<T> drainToCollection, int desiredElements, Duration durationToWait) throws InterruptedException {
        long endTimeInMs = System.currentTimeMillis() + durationToWait.toMillis();
        for (int elementsLeft = desiredElements; elementsLeft > 0; --elementsLeft) {
            int actualElementsDrained = queue.drainTo(drainToCollection, elementsLeft);
            if (actualElementsDrained == elementsLeft) {
                return;
            }
            elementsLeft -= actualElementsDrained;
            T element = queue.poll(endTimeInMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            if (element == null) {
                return;
            }
            drainToCollection.add(element);
        }
    }

    @Generated
    private QueueUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

