/*
 * Decompiled with CFR 0.152.
 */
package com.jashmore.sqs.util.thread;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import lombok.Generated;

public final class ThreadUtils {
    public static ThreadFactory multiNamedThreadFactory(String threadNamePrefix) {
        return new NamedThreadFactory(threadCount -> threadNamePrefix + "-" + threadCount);
    }

    public static ThreadFactory singleNamedThreadFactory(String threadName) {
        return new NamedThreadFactory(threadCount -> threadName);
    }

    @Generated
    private ThreadUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadFactory delegate;
        private final AtomicLong threadCount = new AtomicLong(0L);
        private Function<Long, String> nameGenerator;

        public NamedThreadFactory(Function<Long, String> nameGenerator) {
            this.delegate = Executors.defaultThreadFactory();
            this.nameGenerator = nameGenerator;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.delegate.newThread(runnable);
            thread.setName(this.nameGenerator.apply(this.threadCount.getAndIncrement()));
            return thread;
        }
    }
}

