/*
 * Decompiled with CFR 0.152.
 */
package com.jasonclawson.jackson.dataformat.hocon;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.jasonclawson.jackson.dataformat.hocon.HoconTreeTraversingParser;
import com.jasonclawson.jackson.dataformat.hocon.UTF8Reader;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;

public class HoconFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_HOCON = "HOCON";
    private static final byte UTF8_BOM_1 = -17;
    private static final byte UTF8_BOM_2 = -69;
    private static final byte UTF8_BOM_3 = -65;

    public HoconFactory() {
        this(null);
    }

    public HoconFactory(ObjectCodec oc) {
        super(oc);
    }

    public HoconFactory(HoconFactory src, ObjectCodec oc) {
        super((JsonFactory)src, oc);
    }

    public HoconFactory copy() {
        this._checkInvalidCopy(HoconFactory.class);
        return new HoconFactory(this, null);
    }

    protected Object readResolve() {
        return new HoconFactory(this, this._objectCodec);
    }

    public String getFormatName() {
        return FORMAT_NAME_HOCON;
    }

    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        if (!acc.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte b = acc.nextByte();
        if (b == -17) {
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            b = acc.nextByte();
        }
        if (b == 123 || Character.isLetter((char)b) || Character.isDigit((char)b)) {
            return MatchStrength.WEAK_MATCH;
        }
        return MatchStrength.INCONCLUSIVE;
    }

    public HoconTreeTraversingParser createParser(String content) throws IOException, JsonParseException {
        Reader r = new StringReader(content);
        IOContext ctxt = this._createContext(r, true);
        if (this._inputDecorator != null) {
            r = this._inputDecorator.decorate(ctxt, r);
        }
        return this._createParser(r, ctxt);
    }

    public HoconTreeTraversingParser createParser(File f) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(f, true);
        InputStream in = new FileInputStream(f);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }

    public HoconTreeTraversingParser createParser(URL url) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(url, true);
        InputStream in = this._optimizedStreamFromURL(url);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }

    public HoconTreeTraversingParser createParser(InputStream in) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(in, false);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }

    public JsonParser createParser(Reader r) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(r, false);
        if (this._inputDecorator != null) {
            r = this._inputDecorator.decorate(ctxt, r);
        }
        return this._createParser(r, ctxt);
    }

    public HoconTreeTraversingParser createParser(byte[] data) throws IOException, JsonParseException {
        InputStream in;
        IOContext ctxt = this._createContext(data, true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data, 0, data.length)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data, 0, data.length, ctxt);
    }

    public HoconTreeTraversingParser createParser(byte[] data, int offset, int len) throws IOException, JsonParseException {
        InputStream in;
        IOContext ctxt = this._createContext(data, true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data, offset, len)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data, offset, len, ctxt);
    }

    @Deprecated
    public HoconTreeTraversingParser createJsonParser(String content) throws IOException, JsonParseException {
        return this.createParser(content);
    }

    @Deprecated
    public HoconTreeTraversingParser createJsonParser(File f) throws IOException, JsonParseException {
        return this.createParser(f);
    }

    @Deprecated
    public HoconTreeTraversingParser createJsonParser(URL url) throws IOException, JsonParseException {
        return this.createParser(url);
    }

    @Deprecated
    public HoconTreeTraversingParser createJsonParser(InputStream in) throws IOException, JsonParseException {
        return this.createParser(in);
    }

    @Deprecated
    public JsonParser createJsonParser(Reader r) throws IOException, JsonParseException {
        return this.createParser(r);
    }

    @Deprecated
    public HoconTreeTraversingParser createJsonParser(byte[] data) throws IOException, JsonParseException {
        return this.createParser(data);
    }

    @Deprecated
    public HoconTreeTraversingParser createJsonParser(byte[] data, int offset, int len) throws IOException, JsonParseException {
        return this.createParser(data, offset, len);
    }

    public JsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    public JsonGenerator createGenerator(OutputStream out) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    public JsonGenerator createGenerator(Writer out) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(OutputStream out) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(Writer out) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    protected HoconTreeTraversingParser _createParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        Reader r = this._createReader(in, null, ctxt);
        return this._createParser(r, ctxt);
    }

    protected HoconTreeTraversingParser _createParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        ConfigParseOptions options = ConfigParseOptions.defaults();
        Config config = ConfigFactory.parseReader((Reader)r, (ConfigParseOptions)options);
        Config resolvedConfig = config.resolve();
        return new HoconTreeTraversingParser(resolvedConfig.root(), this._objectCodec);
    }

    protected HoconTreeTraversingParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException, JsonParseException {
        Reader r = this._createReader(data, offset, len, null, ctxt);
        return this._createParser(r, ctxt);
    }

    protected JsonGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    @Deprecated
    protected JsonGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    protected Reader _createReader(InputStream in, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == null) {
            enc = JsonEncoding.UTF8;
        }
        if (enc == JsonEncoding.UTF8) {
            boolean autoClose = ctxt.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            return new UTF8Reader(in, autoClose);
        }
        return new InputStreamReader(in, enc.getJavaName());
    }

    protected Reader _createReader(byte[] data, int offset, int len, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == null) {
            enc = JsonEncoding.UTF8;
        }
        if (enc == null || enc == JsonEncoding.UTF8) {
            return new UTF8Reader(data, offset, len, true);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data, offset, len);
        return new InputStreamReader((InputStream)in, enc.getJavaName());
    }
}

