/*
 * Decompiled with CFR 0.152.
 */
package com.jasonclawson.jackson.dataformat.hocon;

import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.jasonclawson.jackson.dataformat.hocon.HoconTreeTraversingParser;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public abstract class HoconNodeCursor
extends JsonStreamContext {
    protected final HoconNodeCursor _parent;
    protected String _currentName;

    public HoconNodeCursor(int contextType, HoconNodeCursor p) {
        this._type = contextType;
        this._index = -1;
        this._parent = p;
    }

    public HoconNodeCursor getParent() {
        return this._parent;
    }

    public String getCurrentName() {
        return this._currentName;
    }

    public void overrideCurrentName(String name) {
        this._currentName = name;
    }

    public String constructPath() {
        return this.constructPath(new StringBuilder()).toString();
    }

    private StringBuilder constructPath(StringBuilder initial) {
        if (this._parent != null) {
            return this._parent.constructPath(initial).append('.').append(this._currentName);
        }
        return initial.append(this._currentName);
    }

    public abstract JsonToken nextToken();

    public abstract JsonToken endToken();

    public abstract ConfigValue currentNode();

    public abstract boolean currentHasChildren();

    protected static boolean isArray(ConfigValue value) {
        return value.valueType() == ConfigValueType.LIST;
    }

    protected static boolean isObject(ConfigValue value) {
        return value.valueType() == ConfigValueType.OBJECT;
    }

    protected static JsonToken asJsonToken(ConfigValue value) {
        return HoconTreeTraversingParser.asJsonToken(value);
    }

    public final HoconNodeCursor iterateChildren() {
        ConfigValue n = this.currentNode();
        if (n == null) {
            throw new IllegalStateException("No current node");
        }
        boolean numericallyIndexed = HoconNodeCursor.isNumericallyIndexed(n);
        if (!numericallyIndexed) {
            if (HoconNodeCursor.isArray(n)) {
                return new Array(n, this);
            }
            if (HoconNodeCursor.isObject(n)) {
                return new Object(n, this);
            }
        } else {
            return new NumericallyIndexedObjectBackedArray(n, this);
        }
        throw new IllegalStateException("Current node of type " + n.getClass().getName());
    }

    public static boolean isNumericallyIndexed(ConfigValue n) {
        java.lang.Object unwrapped = n.unwrapped();
        if (unwrapped instanceof Map) {
            try {
                Map map = (Map)unwrapped;
                if (map.isEmpty()) {
                    return false;
                }
                for (String key : map.keySet()) {
                    try {
                        Integer.parseInt(key);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    protected static final class Object
    extends HoconNodeCursor {
        protected Iterator<Map.Entry<String, ConfigValue>> _contents;
        protected Map.Entry<String, ConfigValue> _current;
        protected boolean _needEntry;

        public Object(ConfigValue n, HoconNodeCursor p) {
            super(2, p);
            this._contents = ((ConfigObject)n).entrySet().iterator();
            this._needEntry = true;
        }

        @Override
        public JsonToken nextToken() {
            if (this._needEntry) {
                if (!this._contents.hasNext()) {
                    this._currentName = null;
                    this._current = null;
                    return null;
                }
                this._needEntry = false;
                this._current = this._contents.next();
                this._currentName = this._current == null ? null : this._current.getKey();
                return JsonToken.FIELD_NAME;
            }
            this._needEntry = true;
            return Object.asJsonToken(this._current.getValue());
        }

        @Override
        public JsonToken endToken() {
            return JsonToken.END_OBJECT;
        }

        @Override
        public ConfigValue currentNode() {
            return this._current == null ? null : this._current.getValue();
        }

        @Override
        public boolean currentHasChildren() {
            if (this.currentNode() instanceof ConfigList) {
                return !((ConfigList)this.currentNode()).isEmpty();
            }
            if (this.currentNode() instanceof ConfigObject) {
                return !((ConfigObject)this.currentNode()).isEmpty();
            }
            return false;
        }
    }

    protected static final class NumericallyIndexedObjectBackedArray
    extends HoconNodeCursor {
        protected Iterator<ConfigValue> _contents;
        protected ConfigValue _currentNode;

        public NumericallyIndexedObjectBackedArray(ConfigValue n, HoconNodeCursor p) {
            super(1, p);
            TreeMap sortedContents = new TreeMap();
            for (Map.Entry entry : ((ConfigObject)n).entrySet()) {
                try {
                    Integer key = Integer.parseInt((String)entry.getKey());
                    sortedContents.put(key, entry.getValue());
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Key: '" + (String)entry.getKey() + "' in object could not be parsed to an Integer, therefor we cannot be using a " + ((java.lang.Object)((java.lang.Object)this)).getClass().getSimpleName());
                }
            }
            this._contents = sortedContents.values().iterator();
        }

        @Override
        public JsonToken nextToken() {
            if (!this._contents.hasNext()) {
                this._currentNode = null;
                return null;
            }
            this._currentNode = this._contents.next();
            return NumericallyIndexedObjectBackedArray.asJsonToken(this._currentNode);
        }

        @Override
        public JsonToken endToken() {
            return JsonToken.END_ARRAY;
        }

        @Override
        public ConfigValue currentNode() {
            return this._currentNode;
        }

        @Override
        public boolean currentHasChildren() {
            if (this.currentNode() instanceof ConfigList) {
                return !((ConfigList)this.currentNode()).isEmpty();
            }
            if (this.currentNode() instanceof ConfigObject) {
                return !((ConfigObject)this.currentNode()).isEmpty();
            }
            return false;
        }
    }

    protected static final class Array
    extends HoconNodeCursor {
        protected Iterator<ConfigValue> _contents;
        protected ConfigValue _currentNode;

        public Array(ConfigValue n, HoconNodeCursor p) {
            super(1, p);
            this._contents = ((ConfigList)n).iterator();
        }

        @Override
        public JsonToken nextToken() {
            if (!this._contents.hasNext()) {
                this._currentNode = null;
                return null;
            }
            this._currentNode = this._contents.next();
            return Array.asJsonToken(this._currentNode);
        }

        @Override
        public JsonToken endToken() {
            return JsonToken.END_ARRAY;
        }

        @Override
        public ConfigValue currentNode() {
            return this._currentNode;
        }

        @Override
        public boolean currentHasChildren() {
            if (this.currentNode() instanceof ConfigList) {
                return !((ConfigList)this.currentNode()).isEmpty();
            }
            if (this.currentNode() instanceof ConfigObject) {
                return !((ConfigObject)this.currentNode()).isEmpty();
            }
            return false;
        }
    }

    protected static final class RootValue
    extends HoconNodeCursor {
        protected ConfigValue _node;
        protected boolean _done = false;

        public RootValue(ConfigValue n, HoconNodeCursor p) {
            super(0, p);
            this._node = n;
        }

        @Override
        public JsonToken nextToken() {
            if (!this._done) {
                this._done = true;
                return RootValue.asJsonToken(this._node);
            }
            this._node = null;
            return null;
        }

        @Override
        public JsonToken endToken() {
            return null;
        }

        @Override
        public ConfigValue currentNode() {
            return this._node;
        }

        @Override
        public boolean currentHasChildren() {
            return false;
        }
    }
}

