/*
 * Decompiled with CFR 0.152.
 */
package com.jauntsdn.netty.handler.codec.http.websocketx;

import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketDecoder;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketFrameFactory;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketFrameListener;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketProtocol;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;

final class DefaultWebSocketDecoder
extends WebSocketDecoder {
    WebSocketFrameFactory frameFactory;
    final int maxFramePayloadLength;
    int state = 0;
    ByteBuf partialPrefix;
    int partialMask;
    ByteBuf partialPayload;
    int partialRemaining;
    int frameFlags;
    int opcode;
    boolean fin;
    boolean masking;
    int length;
    int fragmentedTotalLength = -1;

    DefaultWebSocketDecoder(int maxFramePayloadLength) {
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.partialPrefix = ctx.alloc().buffer(2, 2);
        super.handlerAdded(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.partialPrefix.release();
        ByteBuf payload = this.partialPayload;
        if (payload != null) {
            payload.release();
        }
        super.channelInactive(ctx);
    }

    @Override
    public void frameListener(ChannelHandlerContext ctx, WebSocketFrameListener webSocketFrameListener, WebSocketFrameFactory frameFactory) {
        super.frameListener(ctx, webSocketFrameListener, frameFactory);
        this.frameFactory = frameFactory;
    }

    @Override
    WebSocketFrameFactory frameFactory() {
        return this.frameFactory;
    }

    @Override
    void decode(ChannelHandlerContext ctx, ByteBuf in) {
        int st = this.state;
        int readableBytes = in.readableBytes();
        block7: while (readableBytes > 0) {
            switch (st) {
                case 0: {
                    int result;
                    int length;
                    int prefix;
                    if (readableBytes >= 4) {
                        int prefixLength;
                        prefix = in.getInt(in.readerIndex());
                        int flags = prefix >> 24 & 0xF0;
                        boolean finFlag = prefix < 0;
                        int maskAndLen = prefix >> 16;
                        int len = maskAndLen & 0x7F;
                        boolean maskFlag = (maskAndLen & 0x80) == 128;
                        int code = prefix >> 24 & 0xF;
                        if (len <= 125) {
                            length = len;
                            prefixLength = 2;
                        } else if (len == 126) {
                            length = prefix & 0xFFFF;
                            prefixLength = 4;
                        } else {
                            WebSocketProtocol.close(ctx, this, WebSocketCloseStatus.MESSAGE_TOO_BIG, "frame payload is too large - exceeds 65535");
                            return;
                        }
                        int result2 = WebSocketProtocol.validate(ctx, this, flags, code, length, this.fragmentedTotalLength, this.maxFramePayloadLength);
                        if (result2 == -128) {
                            return;
                        }
                        this.fragmentedTotalLength = result2;
                        in.skipBytes(prefixLength);
                        readableBytes -= prefixLength;
                        int mask = 0;
                        if (maskFlag) {
                            if (readableBytes >= 4) {
                                mask = in.readInt();
                                readableBytes -= 4;
                            } else {
                                this.length = length;
                                this.partialRemaining = 4;
                                this.partialMask = 0;
                                this.opcode = code;
                                this.fin = finFlag;
                                st = 2;
                                continue block7;
                            }
                        }
                        if (readableBytes >= length) {
                            ByteBuf payload = in.readRetainedSlice(length);
                            if (maskFlag) {
                                DefaultWebSocketDecoder.unmask(payload, mask);
                            }
                            readableBytes -= length;
                            this.onFrameRead(ctx, finFlag, code, payload);
                            continue block7;
                        }
                        if (maskFlag) {
                            this.partialMask = mask;
                            this.masking = true;
                        }
                        ByteBuf partial = this.partialPayload = ctx.alloc().buffer(length);
                        if (readableBytes > 0) {
                            partial.writeBytes(in);
                        }
                        this.partialRemaining = length - readableBytes;
                        readableBytes = 0;
                        this.opcode = code;
                        this.fin = finFlag;
                        st = 3;
                        continue block7;
                    }
                    if (readableBytes >= 2) {
                        prefix = in.readShort();
                        readableBytes -= 2;
                        this.fin = prefix < 0;
                        boolean finFlag = this.fin;
                        int flagsAndOpcode = prefix >> 8;
                        int code = this.opcode = flagsAndOpcode & 0xF;
                        int flags = this.frameFlags = flagsAndOpcode & 0xF0;
                        int len = prefix & 0x7F;
                        this.masking = (prefix & 0x80) == 128;
                        boolean maskFlag = this.masking;
                        if (len <= 125) {
                            length = len;
                            result = WebSocketProtocol.validate(ctx, this, flags, code, length, this.fragmentedTotalLength, this.maxFramePayloadLength);
                            if (result == -128) {
                                return;
                            }
                            this.fragmentedTotalLength = result;
                            if (maskFlag) {
                                this.length = length;
                                this.partialRemaining = 4;
                                this.partialMask = 0;
                                st = 2;
                                continue block7;
                            }
                            if (length <= readableBytes) {
                                if (length == 0) {
                                    this.onFrameRead(ctx, finFlag, code, Unpooled.EMPTY_BUFFER);
                                } else {
                                    this.onFrameRead(ctx, finFlag, code, in.readRetainedSlice(length));
                                    readableBytes -= length;
                                }
                                st = 0;
                                continue block7;
                            }
                            ByteBuf partial = ctx.alloc().buffer(length);
                            partial.writeBytes(in);
                            this.partialPayload = partial;
                            this.partialRemaining = length - readableBytes;
                            readableBytes = 0;
                            this.opcode = code;
                            this.fin = finFlag;
                            st = 3;
                            continue block7;
                        }
                        if (len == 126) {
                            this.length = len;
                            if (readableBytes > 0) {
                                this.partialPrefix.writeBytes(in);
                            }
                            this.partialRemaining = 2 - readableBytes;
                            readableBytes = 0;
                            this.opcode = code;
                            this.fin = finFlag;
                            st = 1;
                            continue block7;
                        }
                        WebSocketProtocol.close(ctx, this, WebSocketCloseStatus.MESSAGE_TOO_BIG, "frame payload is too large - exceeds 65535");
                        return;
                    }
                    this.partialPrefix.writeBytes(in);
                    readableBytes = 0;
                    this.partialRemaining = 1;
                    st = 1;
                    continue block7;
                }
                case 1: {
                    int result;
                    int toRead = Math.min(readableBytes, this.partialRemaining);
                    this.partialPrefix.writeBytes(in, toRead);
                    readableBytes -= toRead;
                    int remaining = this.partialRemaining -= toRead;
                    if (remaining != 0) continue block7;
                    if (this.length == 126) {
                        this.length = 0;
                        int extendedLength = this.partialPrefix.getUnsignedShort(0);
                        this.partialPrefix.writerIndex(0);
                        int result3 = WebSocketProtocol.validate(ctx, this, this.frameFlags, this.opcode, extendedLength, this.fragmentedTotalLength, this.maxFramePayloadLength);
                        if (result3 == -128) {
                            return;
                        }
                        this.fragmentedTotalLength = result3;
                        if (this.masking) {
                            this.length = extendedLength;
                            this.partialRemaining = 4;
                            this.partialMask = 0;
                            st = 2;
                            continue block7;
                        }
                        if (extendedLength <= readableBytes) {
                            this.onFrameRead(ctx, this.fin, this.opcode, in.readRetainedSlice(extendedLength));
                            readableBytes -= extendedLength;
                            st = 0;
                            continue block7;
                        }
                        ByteBuf partial = ctx.alloc().buffer(extendedLength);
                        partial.writeBytes(in);
                        this.partialPayload = partial;
                        this.partialRemaining = extendedLength - readableBytes;
                        readableBytes = 0;
                        st = 3;
                        continue block7;
                    }
                    short prefix = this.partialPrefix.getShort(0);
                    this.partialPrefix.writerIndex(0);
                    this.fin = prefix < 0;
                    int flagsAndOpcode = prefix >> 8;
                    int flags = flagsAndOpcode & 0xF0;
                    int code = this.opcode = flagsAndOpcode & 0xF;
                    int len = prefix & 0x7F;
                    this.masking = (prefix & 0x80) == 128;
                    boolean maskFlag = this.masking;
                    if (len <= 125) {
                        result = WebSocketProtocol.validate(ctx, this, flags, code, len, this.fragmentedTotalLength, this.maxFramePayloadLength);
                        if (result == -128) {
                            return;
                        }
                        this.fragmentedTotalLength = result;
                        if (maskFlag) {
                            this.length = len;
                            this.partialRemaining = 4;
                            this.partialMask = 0;
                            st = 2;
                            continue block7;
                        }
                        this.length = 0;
                        this.partialPayload = ctx.alloc().buffer(len);
                        this.partialRemaining = len;
                        st = 3;
                        continue block7;
                    }
                    if (len == 126) {
                        if (readableBytes >= 2) {
                            len = in.readUnsignedShort();
                            readableBytes -= 2;
                            result = WebSocketProtocol.validate(ctx, this, flags, code, len, this.fragmentedTotalLength, this.maxFramePayloadLength);
                            if (result == -128) {
                                return;
                            }
                            this.fragmentedTotalLength = result;
                            if (maskFlag) {
                                this.length = len;
                                this.partialRemaining = 4;
                                this.partialMask = 0;
                                st = 2;
                                continue block7;
                            }
                            this.length = 0;
                            this.partialPayload = ctx.alloc().buffer(len);
                            this.partialRemaining = len;
                            st = 3;
                            continue block7;
                        }
                        this.length = len;
                        if (readableBytes > 0) {
                            this.partialPrefix.writeByte((int)in.readByte());
                            --readableBytes;
                            this.partialRemaining = 1;
                            continue block7;
                        }
                        this.partialRemaining = 2;
                        continue block7;
                    }
                    WebSocketProtocol.close(ctx, this, WebSocketCloseStatus.MESSAGE_TOO_BIG, "frame payload is too large - exceeds 65535");
                    return;
                }
                case 2: {
                    int remaining = this.partialRemaining;
                    int toRead = Math.min(readableBytes, remaining);
                    readableBytes -= toRead;
                    int mask = this.partialMask;
                    for (int i = 0; i < toRead; ++i) {
                        mask |= (in.readByte() & 0xFF) << 8 * --remaining;
                    }
                    if (remaining == 0) {
                        int len = this.length;
                        this.length = 0;
                        if (len <= readableBytes) {
                            ByteBuf payload = in.readRetainedSlice(len);
                            readableBytes -= len;
                            DefaultWebSocketDecoder.unmask(payload, mask);
                            this.onFrameRead(ctx, this.fin, this.opcode, payload);
                            st = 0;
                            continue block7;
                        }
                        this.partialMask = mask;
                        this.partialPayload = ctx.alloc().buffer(len);
                        this.partialRemaining = len;
                        st = 3;
                        continue block7;
                    }
                    this.partialMask = mask;
                    this.partialRemaining = remaining;
                    continue block7;
                }
                case 3: {
                    int remaining = this.partialRemaining;
                    int toRead = Math.min(readableBytes, remaining);
                    ByteBuf partial = this.partialPayload;
                    partial.writeBytes(in, toRead);
                    remaining = this.partialRemaining -= toRead;
                    readableBytes -= toRead;
                    if (remaining != 0) continue block7;
                    this.partialPayload = null;
                    if (this.masking) {
                        DefaultWebSocketDecoder.unmask(partial, this.partialMask);
                    }
                    this.onFrameRead(ctx, this.fin, this.opcode, partial);
                    st = 0;
                    continue block7;
                }
                case 4: {
                    continue block7;
                }
            }
            throw new IllegalStateException("unexpected decoding state: " + this.state);
        }
        this.state = st;
    }

    @Override
    void closeInbound() {
        this.state = 4;
    }

    static void unmask(ByteBuf payload, int mask) {
        int cur;
        int readableBytes = payload.readableBytes();
        if (readableBytes >= 8) {
            long longMask = (long)mask & 0xFFFFFFFFL;
            longMask |= longMask << 32;
            for (cur = 0; cur < readableBytes - 7; cur += 8) {
                payload.setLong(cur, payload.getLong(cur) ^ longMask);
            }
        }
        if (cur < readableBytes - 3) {
            payload.setInt(cur, payload.getInt(cur) ^ mask);
            cur += 4;
        }
        int offset = 0;
        while (cur < readableBytes) {
            payload.setByte(cur, payload.getByte(cur) ^ DefaultWebSocketDecoder.byteAtIndex(mask, offset++ & 3));
            ++cur;
        }
    }

    static int byteAtIndex(int mask, int index) {
        return mask >> 8 * (3 - index) & 0xFF;
    }
}

